ORCA/M Asm65816 2.1.0

0001 0000                       title ' Memory Manager'
0002 0000              ********************************************************************************
0003 0000              *
0004 0000              * Memory manager  Tool Set #2
0005 0000              *
0006 0000              * (C) Copyright 1985-1989,1991
0007 0000              * Apple Computer, Inc.
0008 0000              * All Rights Reserved
0009 0000              *
0010 0000              * Original Code 
0011 0000              * by Rich Williams January 1986
0012 0000              *
0013 0000              *       'Memory [management] is the treasury and guardian of all things'
0014 0000              *        Cicero, De Oratore. Bk. i, sec. 5
0015 0000              *
0016 0000              *
0017 0000              * RamDisk         Tool Set #13
0018 0000              *       The ramdisk tool has been integrated into the memory manager
0019 0000              *       but it is a separate tool with a separate dispatch table
0020 0000              *
0021 0000              *
0022 0000              * Revision 2.00
0023 0000              *
0024 0000              * September 1986 by Rich Williams
0025 0000              *
0026 0000              * The patches from 1.1 have been included into the rom including:
0027 0000              *
0028 0000              * 1) The restart routine now doesn't throw out valid handles
0029 0000              *
0030 0000              * 2) New handles are created with ID number $F0FF
0031 0000              *
0032 0000              * 3) The purge routines are now in the rom
0033 0000              *
0034 0000              * Changes not part of 1.1
0035 0000              *
0036 0000              * 1) BlockMove ignores high byte of 4 byte address
0037 0000              *
0038 0000              * 2) Ramdisk now returns bytes transferred count on DIB call
0039 0000              *
0040 0000              * 3) Purge and Compact optimized for banks 0 and 1. Purge in 1.1 was updated
0041 0000              *
0042 0000              * 4) SetHandleSize makes handle temporarily unpurgable
0043 0000              *
0044 0000              * 5) With a last minute phone patch by Steve, Fern and Mike dictated
0045 0000              *    by Rich at 5:52 pm on 2 Mar 87.
0046 0000              *
0047 0000              *
0048 0000              * Revision 3.00
0049 0000              *
0050 0000              * Converted to MAX.
0051 0000              *
0052 0000              * Incorporated patch?
0053 0000              *
0054 0000              *
0055 0000              * 25 Aug 88         Steven Glass
0056 0000              *
0057 0000              * Made the peeker a separate entity again.  Also separated out the 
0058 0000              * equates.
0059 0000              *
0060 0000              * 30 Aug 88         Steven Glass
0061 0000              *
0062 0000              * Added global variables LastLowHandle and LastHighHandle.  These are
0063 0000              * set by SearchUp and SearchDown every time a handle is found.  Search
0064 0000              * now calls SearchUpFast and SearchDownFast which start their searches
0065 0000              * using the values in LastLowhandle and LastHighHandle.
0066 0000              *
0067 0000              * DisposeHandle, DisposeAll and DoPurge all call CheckRecent to make sure
0068 0000              * that the values in SearchUpFast and SearchDownFast are all valid.
0069 0000              *
0070 0000              * Added debugging code to DisposeHandle and NewHandle, so that the handles
0071 0000              * being acted on are written to a specific location.
0072 0000              *
0073 0000              * Added conditional compile code that ignores most of BootInit when making
0074 0000              * a version to run in RAM.  The RAM version patches the vectors and
0075 0000              * always zeros the power byte.  It assumes all other memory manager data
0076 0000              * structures are intact and valid.
0077 0000              *
0078 0000              * 04 Oct 88         Steven Glass
0079 0000              *
0080 0000              * The Original design of the OOM Queue let it run only after the memory 
0081 0000              * manager failed to make room.
0082 0000              *
0083 0000              * By calling the Queue before the MM compacts, and purges, we can allow 
0084 0000              * for an application to write its own (and more sophisticated) purge routines.
0085 0000              *
0086 0000              * 06 Oct 88         Steven Glass
0087 0000              *
0088 0000              * SetHandleSize can move a handle from the used list to the purgelist if the 
0089 0000              * new size is zero.  When this happens, we have to check the recently allocated
0090 0000              * handle so we won't start our search from the purge list.
0091 0000              *
0092 0000              * 15 Oct 88         Steven Glass
0093 0000              *
0094 0000              * Rewrote SearchFail code to be more understandable.  The number of 
0095 0000              * retries is now different than when rich first wrote it.  This made it 
0096 0000              * necessary to rewrite a little of the purge code to keep things working.
0097 0000              *
0098 0000              * 23 Oct 88         Steven Glass
0099 0000              *
0100 0000              * Changed the searchup, searchdown and fastsearchup and fastsearchdown routines
0101 0000              * so that they would not remember the handle found if the handle was fixed bank
0102 0000              * or fixed loc.
0103 0000              *
0104 0000              * Added second entry point to MakeIDMask so that it would not check for non-zero
0105 0000              * major ID.
0106 0000              *
0107 0000              * Changed purgeall to use new entry to MakeIDMask.  Makes it possible to
0108 0000              * purge all purgables at once.
0109 0000              *
0110 0000              * Changed SearchFail to use new PurgeAll.
0111 0000              *
0112 0000              * 30 Oct 88         Steven Glass
0113 0000              *
0114 0000              * Added ClearRecent, a routine to zero the last found handles.  ClearRecent
0115 0000              * is called at MMReset, MMBootinit and WarmStart.
0116 0000              *
0117 0000              * 31 Oct 88         Steven Glass
0118 0000              *
0119 0000              * Made PurgeAll return bizzare errors again.
0120 0000              *
0121 0000              * 23 Nov 88         John Arkley
0122 0000              *
0123 0000              * Fixed bug in RD ExecPCCmd routine to return properly when an out-of-range cmd
0124 0000              * call is made from SmartPort due to the 'additional' SmartPort commands.
0125 0000              *
0126 0000              * Made RAM Disk use one and only one handle.
0127 0000              *
0128 0000              * 30 Nov 88         Steven Glass
0129 0000              *
0130 0000              * Fixed a bug in CheckRecent where bad values were used if the handle being
0131 0000              * passed was not valid.
0132 0000              *
0133 0000              * Made a number of routines "public" for use with the patch file.
0134 0000              *
0135 0000              * Changed DisposeAll to check the calling routine to make sure that 
0136 0000              * the caller is not disposing of himself.  This mistake seems to be 
0137 0000              * common in appications and somehow they were lucky until recently.
0138 0000              *
0139 0000              * 21 Dec 88         Steven Glass
0140 0000              *
0141 0000              * Incorporated SetHandleSize patch so that handle is re-derefed after resized
0142 0000              * in case it moves.
0143 0000              *
0144 0000              * 08 Jan 89         Steven Glass
0145 0000              *
0146 0000              * Also zeroed the FirstOOMPtr in BootInit and Reset so that OOM queue is cleared.
0147 0000              *
0148 0000              * 19 Jan 89         John Arkley
0149 0000              *
0150 0000              * Fix RAMDISK routine MAKEDISK to clear stack before error exit so it RTSs back
0151 0000              * back to the initcommand routine with an error.
0152 0000              *
0153 0000              * 16 Feb 89         Harry Yee
0154 0000              *
0155 0000              * Calls DeleteFromOOMQueue and AddToOOMQueue were not passing error codes to
0156 0000              * the exit routines. BRC #41432, 41841.
0157 0000              *
0158 0000              * 3/31/89           Mensch
0159 0000              *
0160 0000              * Fixed OOMQueue so that it would properly compare the amount of memory freed to
0161 0000              * the amount needed.
0162 0000              *
0163 0000              * 4/21/89           Mensch
0164 0000              *
0165 0000              * Made disposeall not return an error when an app tries to dispose of itself.
0166 0000              * (The dispose does not occur however...)
0167 0000              *
0168 0000              * 11/13/89          Mensch
0169 0000              *
0170 0000              * Fixed the verify routine so that its test for a valid handle is a little more
0171 0000              * robust than it was before. This is for the DisposeHandle bug (DisposeHandle($fbfbfb)
0172 0000              * would screw up the hint something horrible...) BRC#53386
0173 0000              *
0174 0000              ********************************************************************************
0175 0000
0176 0000
0177 0000                       string asis 
0178 0000                       eject 
0179 0000
0180 0000                       include 'm16.util2' 
0181 0000                       include 'm16.misctool' 
0182 0000                       include 'm16.memory' 
0183 0000
0184 0000                       include 'mm.macros' 
0185 0000
0186 0000                       include 'mm.equates.asm' 
0187 0000                       title ' Forward Address and Entries'
0188 0000              ;-----------------------------------------------
0189 0000              ;
0190 0000              ;   Forward addresses and entries
0191 0000              ;
0192 0000              ;-----------------------------------------------
0193 0000
0194 0000                       ENTRY BlockMove
0195 0000                       ENTRY CheckHandle
0196 0000                       ENTRY CompactMem
0197 0000                       ENTRY DIB
0198 0000                       ENTRY DisposAll
0199 0000                       ENTRY DisposHandle
0200 0000                       ENTRY DoPurge
0201 0000                       ENTRY ExecPCCmd
0202 0000                       ENTRY FindHandle
0203 0000                       ENTRY FreeMem
0204 0000                       ENTRY GetAttr
0205 0000                       ENTRY GetBlockA
0206 0000                       ENTRY GetDiskSize
0207 0000                       ENTRY GetHandleSize
0208 0000                       ENTRY GetNext
0209 0000                       ENTRY GetPrev
0210 0000                       ENTRY GetNextFree
0211 0000                       ENTRY GetPrevFree
0212 0000                       ENTRY HLock
0213 0000                       ENTRY HLockAll
0214 0000                       ENTRY HUnlock
0215 0000                       ENTRY HUnlockAll
0216 0000                       ENTRY HandToHand
0217 0000                       ENTRY HandToPtr
0218 0000                       ENTRY InsertFrBlock
0219 0000                       ENTRY InsertFree
0220 0000                       ENTRY InsertHandle
0221 0000                       ENTRY InsertPurge
0222 0000                       ENTRY Link2
0223 0000                       ENTRY MMBootInit
0224 0000                       ENTRY MMReset
0225 0000                       ENTRY MMShutdown
0226 0000                       ENTRY MMStartup
0227 0000                       ENTRY MMStatus
0228 0000                       ENTRY MMVersion
0229 0000                       ENTRY MakeIDMask
0230 0000                       ENTRY MakeIDMask2
0231 0000                       ENTRY MaxBlock
0232 0000                       ENTRY MoveAttr
0233 0000                       ENTRY NewHandle
0234 0000                       ENTRY PCControl
0235 0000                       ENTRY PCData
0236 0000                       ENTRY PCInit
0237 0000                       ENTRY PCReadBlk
0238 0000                       ENTRY PCStatus
0239 0000                       ENTRY PCWriteBlk
0240 0000                       ENTRY PtrToHand
0241 0000                       ENTRY PurgeAll
0242 0000                       ENTRY PurgeHandle
0243 0000                       ENTRY RDLink
0244 0000                       ENTRY ReallocHandle
0245 0000                       ENTRY RemoveHandle
0246 0000                       ENTRY RestoreHandle
0247 0000                       ENTRY ScanHandles
0248 0000                       ENTRY SearchHandle
0249 0000                       ENTRY SearchDown
0250 0000                       ENTRY SearchDownFast
0251 0000                       ENTRY SearchID
0252 0000                       ENTRY SearchUp
0253 0000                       ENTRY SetHandleSize
0254 0000                       ENTRY SetPurge
0255 0000                       ENTRY SetPurgeAll
0256 0000                       ENTRY Start0
0257 0000                       ENTRY StartX
0258 0000                       ENTRY StartXTop
0259 0000                       ENTRY TestMem
0260 0000                       ENTRY TotalMem
0261 0000                       ENTRY TrimFree
0262 0000                       ENTRY Validate
0263 0000                       ENTRY VerifyH2
0264 0000                       ENTRY VerifyHandle
0265 0000                       ENTRY XCheckFit
0266 0000                       ENTRY XCleanUp
0267 0000                       ENTRY XCompact
0268 0000                       ENTRY XCreateHandles
0269 0000                       ENTRY XGetFree
0270 0000                       ENTRY XLink
0271 0000                       ENTRY XMMPatcher
0272 0000                       ENTRY XMoveData
0273 0000                       ENTRY XPurge
0274 0000                       ENTRY XRealloc
0275 0000                       ENTRY XRestart
0276 0000                       ENTRY XSearch
0277 0000                       ENTRY XSearchFail
0278 0000                       ENTRY XUserPurge
0279 0000                       ENTRY XWarmStart
0280 0000
0281 0000                       ENTRY CheckRecent
0282 0000                       ENTRY ClearRecent
0283 0000                       ENTRY AddToOOMQueue
0284 0000                       ENTRY DeleteFromOOMQueue
0285 0000                       ENTRY RealFreeMem
0286 0000
0287 0000
0288 0000                       Title 'Call Table'
0289 0000              ********************************************************************************
0290 0000              *
0291 0000              * Memory manager call table
0292 0000              *  This is the dispatch table for the MM calls
0293 0000              *
0294 0000              *  Beware!!! if it moves from $FF0000, make sure tool locator is updated
0295 0000              *
0296 0000              ********************************************************************************
0297 0000
0298 0000                       EXPORT MMCallTable
0299 0000              MMCallTable PROC 
0300 0000                       longa on
0301 0000                       longi on
0302 0000
0303 0000 30 00 00 00           DC L:(TableEnd-mmCallTable)/4  ; # entries + 1
0304 0004
0305 0004 ED 01 FC 00           DC L:MMBootInit-1              ;01 Boot time call
0306 0008 8E 04 FC 00           DC L:MMStartup-1               ;02 Application init call
0307 000C E3 04 FC 00           DC L:MMShutdown-1              ;03 App quit
0308 0010 F7 04 FC 00           DC L:MMVersion-1               ;04 Version #
0309 0014 FF 04 FC 00           DC L:MMReset-1                 ;05 Reset call
0310 0018 1A 05 FC 00           DC L:MMStatus-1                ;06 Active status
0311 001C 06 01 FC 00           DC L:NotImp-1
0312 0020 06 01 FC 00           DC L:NotImp-1
0313 0024
0314 0024 22 05 FC 00           DC L:NewHandle-1               ;09 NewHandle
0315 0028 8E 05 FC 00           DC L:ReallocHandle-1           ;0A ReallocHandle
0316 002C EC 05 FC 00           DC L:RestoreHandle-1           ;0B RestoreHandle
0317 0030 E6 12 FC 00           DC L:AddToOOMQueue-1           ;0C
0318 0034 01 13 FC 00           DC L:DeleteFromOOMQueue-1      ;0D
0319 0038 06 01 FC 00           DC L:NotImp-1
0320 003C 06 01 FC 00           DC L:NotImp-1
0321 0040
0322 0040 22 06 FC 00           DC L:DisposHandle-1            ;10 DisposHandle
0323 0044 42 06 FC 00           DC L:DisposAll-1               ;11 DisposAll
0324 0048 7F 06 FC 00           DC L:PurgeHandle-1             ;12 PurgeHandle
0325 004C 8D 06 FC 00           DC L:PurgeAll-1                ;13 PurgeAll
0326 0050 06 01 FC 00           DC L:NotImp-1
0327 0054 06 01 FC 00           DC L:NotImp-1
0328 0058 06 01 FC 00           DC L:NotImp-1
0329 005C 06 01 FC 00           DC L:NotImp-1
0330 0060
0331 0060 CA 06 FC 00           DC L:GetHandleSize-1           ;18 GetHandleSize
0332 0064 E2 06 FC 00           DC L:SetHandleSize-1           ;19 SetHandleSize
0333 0068 0D 08 FC 00           DC L:FindHandle-1              ;1A FindHandle
0334 006C 3F 08 FC 00           DC L:FreeMem-1                 ;1B FreeMem
0335 0070 C3 08 FC 00           DC L:MaxBlock-1                ;1C MaxBlock
0336 0074 EE 08 FC 00           DC L:TotalMem-1                ;1D TotalMem
0337 0078 FF 08 FC 00           DC L:CheckHandle-1             ;1E CheckHandle
0338 007C 0A 09 FC 00           DC L:CompactMem-1              ;1F CompactMem
0339 0080
0340 0080 20 09 FC 00           DC L:HLock-1                   ;20 HLock
0341 0084 35 09 FC 00           DC L:HLockAll-1                ;21 HLockAll
0342 0088 89 09 FC 00           DC L:HUnlock-1                 ;22 HUnlock
0343 008C 9E 09 FC 00           DC L:HUnlockAll-1              ;23 HUnlockAll
0344 0090 BE 09 FC 00           DC L:SetPurge-1                ;24 SetPurge
0345 0094 DD 09 FC 00           DC L:SetPurgeAll-1             ;25 SetPurgeAll
0346 0098 06 01 FC 00           DC L:NotImp-1                  ;26 DeRef
0347 009C 06 01 FC 00           DC L:NotImp-1
0348 00A0
0349 00A0 07 0A FC 00           DC L:PtrToHand-1               ;28 PtrToHand
0350 00A4 44 0A FC 00           DC L:HandToPtr-1               ;29 HandToPtr
0351 00A8 81 0A FC 00           DC L:HandToHand-1              ;2A HandToHand
0352 00AC CD 0A FC 00           DC L:BlockMove-1               ;2B BlockMove
0353 00B0 06 01 FC 00           DC L:NotImp-1                  ;2C
0354 00B4 06 01 FC 00           DC L:NotImp-1                  ;2D
0355 00B8 06 01 FC 00           DC L:NotImp-1                  ;2E
0356 00BC 6B 08 FC 00           DC L:RealFreeMem-1             ;2F RealFreeMem
0357 00C0              TableEnd  
0358 00C0                       eject 
0359 00C0              ********************************************************************************
0360 00C0              *
0361 00C0              * Ram Disk call table
0362 00C0              *
0363 00C0              * Beware!!! if this moves from $FF00C0 make sure tool locator is updated
0364 00C0              *
0365 00C0              ********************************************************************************
0366 00C0                       EXPORT RDCallTable 
0367 00C0              RDCallTable                             ;
0368 00C0
0369 00C0 10 00 00 00           DC L:(RDTblEnd-RDCallTable)/4  ; # entries + 1
0370 00C4
0371 00C4 FF 00 FC 00           DC L:RDNotImp-1                ;01 Boot time call
0372 00C8 FF 00 FC 00           DC L:RDNotImp-1                ;02 Application init call
0373 00CC FF 00 FC 00           DC L:RDNotImp-1                ;03 App quit
0374 00D0 F7 04 FC 00           DC L:MMVersion-1               ;04 Version #
0375 00D4 FF 00 FC 00           DC L:RDNotImp-1                ;05 Reset call
0376 00D8 1A 05 FC 00           DC L:MMStatus-1                ;06 Active status
0377 00DC FF 00 FC 00           DC L:RDNotImp-1
0378 00E0 FF 00 FC 00           DC L:RDNotImp-1
0379 00E4
0380 00E4 FF 00 FC 00           DC L:RDNotImp-1                ;09 Kill
0381 00E8 55 16 FC 00           DC L:ExecPCCmd-1               ;0A Exec P.C. call
0382 00EC FF 00 FC 00           DC L:RDNotImp-1                ;0B SetDiskSize
0383 00F0 A3 14 FC 00           DC L:GetDiskSize-1             ;0C GetDiskSize
0384 00F4 FF 00 FC 00           DC L:RDNotImp-1
0385 00F8 FF 00 FC 00           DC L:RDNotImp-1
0386 00FC FF 00 FC 00           DC L:RDNotImp-1
0387 0100
0388 0100
0389 0100              RDTblEnd                                ; 
0390 0100
0391 0100 22 89 01 FC  RDNotImp jsl   RDLink
0392 0104 4C C4 01              jmp   XCleanUp
0393 0107
0394 0107
0395 0107 22 88 16 E1  NotImp   jsl   Link                     ;Link & Unlink to fix stack
0396 010B 5C 8C 16 E1           jml   CleanUp
0397 010F
0398 010F                       ENDP 
0399 010F
0400 010F
0401 010F
0402 010F
0403 010F              ********************************************************************************
0404 010F              *
0405 010F              * ParmCnt
0406 010F              *
0407 010F              * This table has the number of bytes of parameters for each call
0408 010F              *
0409 010F              ********************************************************************************
0410 010F              ParmCnt  PROC 
0411 010F
0412 010F 00                    DC B:00                        ;01 Boot time call
0413 0110 00                    DC B:00                        ;02 Application init call
0414 0111 02                    DC B:02                        ;03 App quit
0415 0112 00                    DC B:00                        ;04 Version #
0416 0113 00                    DC B:00                        ;05 Reset
0417 0114 00                    DC B:00                        ;06 Status
0418 0115 00                    DC B:00
0419 0116 00                    DC B:00
0420 0117
0421 0117 0C                    DC B:12                        ;09 New Handle
0422 0118 10                    DC B:16                        ;0A ReallocHandle
0423 0119 04                    DC B:04                        ;0B RestoreHandle
0424 011A 04                    DC B:04                        ;0C AddToOOMQueue
0425 011B 04                    DC B:04                        ;0D DeleteFromOOMQueue
0426 011C 00                    DC B:00
0427 011D 00                    DC B:00
0428 011E
0429 011E 04                    DC B:04                        ;10 DisposHandle
0430 011F 02                    DC B:02                        ;11 DisposAll
0431 0120 04                    DC B:04                        ;12 PurgeHandle
0432 0121 02                    DC B:02                        ;13 PurgeAll
0433 0122 00                    DC B:00
0434 0123 00                    DC B:00
0435 0124 00                    DC B:00
0436 0125 00                    DC B:00
0437 0126
0438 0126 04                    DC B:04                        ;18 GetHandleSize
0439 0127 08                    DC B:08                        ;19 SetHandleSize
0440 0128 04                    DC B:04                        ;1A FindHandle
0441 0129 00                    DC B:00                        ;1B FreeMem
0442 012A 00                    DC B:00                        ;1C MaxBlock
0443 012B 00                    DC B:00                        ;1D TotalMem
0444 012C 04                    DC B:04                        ;1E CheckHandle
0445 012D 00                    DC B:00                        ;1F CompactMem
0446 012E
0447 012E 04                    DC B:04                        ;20 HLock
0448 012F 02                    DC B:02                        ;21 HLockAll
0449 0130 04                    DC B:04                        ;22 HUnlock
0450 0131 02                    DC B:02                        ;23 HUnlockAll
0451 0132 06                    DC B:06                        ;24 SetPurge
0452 0133 04                    DC B:04                        ;25 SetPurgeAll
0453 0134 04                    DC B:04                        ;26 DeRef
0454 0135 00                    DC B:00
0455 0136
0456 0136 0C                    DC B:12                        ;28 PtrToHnd
0457 0137 0C                    DC B:12                        ;29 HandToPtr
0458 0138 0C                    DC B:12                        ;2A HandToHand
0459 0139 0C                    DC B:12                        ;2B BlockMove
0460 013A 00                    DC B:00
0461 013B 00                    DC B:00
0462 013C 00                    DC B:00
0463 013D 00                    DC B:00
0464 013E
0465 013E                       ENDP 
0466 013E              ********************************************************************************
0467 013E              *
0468 013E              * RDParmCnt - Parameter counts for ramdisk calls
0469 013E              *
0470 013E              ********************************************************************************
0471 013E              RDParmCnt PROC 
0472 013E
0473 013E 00                    DC B:00                        ;01 Boot time call
0474 013F 00                    DC B:00                        ;02 Application init call
0475 0140 00                    DC B:00                        ;03 App quit
0476 0141 00                    DC B:00                        ;04 Version #
0477 0142 00                    DC B:00                        ;05 Reset
0478 0143 00                    DC B:00                        ;06 Status
0479 0144 00                    DC B:00
0480 0145 00                    DC B:00
0481 0146
0482 0146 00                    DC B:00                        ;09 Kill
0483 0147 00                    DC B:00                        ;0A ExecPCCall
0484 0148 00                    DC B:00                        ;0B SetDiskSize
0485 0149 00                    DC B:00                        ;0C GetDiskSize
0486 014A 00                    DC B:00
0487 014B 00                    DC B:00
0488 014C 00                    DC B:00
0489 014D
0490 014D                       ENDP 
0491 014D
0492 014D
0493 014D
0494 014D              ********************************************************************************
0495 014D              *
0496 014D              * Vectors - This is the defaults for the patch vectors in $E1
0497 014D              *
0498 014D              * THE ORDER MUST BE THE SAME AS THE EQUATES
0499 014D              *
0500 014D              ********************************************************************************
0501 014D              Vectors  PROC 
0502 014D
0503 014D 5C 8A 04 FC           jml   XMMPatcher
0504 0151 5C 8B 04 FC           jml   XWarmStart
0505 0155 5C 99 01 FC           jml   XLink
0506 0159 5C C4 01 FC           jml   XCleanUp
0507 015D 5C F2 0A FC           jml   XSearch
0508 0161 5C 55 0C FC           jml   XCheckFit
0509 0165 5C C0 0D FC           jml   XRealloc
0510 0169 5C 4A 0E FC           jml   XGetFree
0511 016D 5C DD 0F FC           jml   XCreateHandles
0512 0171 5C A0 10 FC           jml   XMoveData
0513 0175 5C 88 11 FC           jml   XSearchFail
0514 0179 5C DA 11 FC           jml   XCompact
0515 017D 5C 1D 13 FC           jml   XPurge
0516 0181
0517 0181                       ENTRY UpDefault
0518 0181              UPDefault                               ;
0519 0181 5C 50 12 FC           jml   XUserPurge
0520 0185 5C 3B 03 FC           jml   XRestart
0521 0189
0522 0189
0523 0189                       ENDP 
0524 0189
0525 0189
0526 0189
0527 0189                       eject 
0528 0189              ********************************************************************************
0529 0189              *
0530 0189              * RDLink - This routine is called by every RAM disk entry point
0531 0189              *        It saves the number of parameters
0532 0189              *        the D & B registers
0533 0189              *        moves the stack down by ZPSize bytes
0534 0189              *        move the Direct register to the stack
0535 0189              *
0536 0189              ********************************************************************************
0537 0189              RDLink   PROC 
0538 0189                       longa on
0539 0189                       longi on
0540 0189
0541 0189 8A                    txa   
0542 018A EB                    xba   
0543 018B E2 30                 sep   #$30                     ;Into 8 bit mode
0544 018D                       longa off
0545 018D                       longi off
0546 018D
0547 018D 29 FF                 and   #$FF
0548 018F AA                    tax                            ;X = Index for parm count
0549 0190
0550 0190 A9 E1                 lda   #$E1                     ;Bank reg for later
0551 0192 48                    pha   
0552 0193 BF 3D 01 FC           lda   >RDParmCnt-1,x           ;Get # parameters
0553 0197 80 0E                 bra   Link2
0554 0199
0555 0199                       ENDP 
0556 0199
0557 0199
0558 0199
0559 0199
0560 0199              ********************************************************************************
0561 0199              *
0562 0199              * Link - This routine is called by every entry point
0563 0199              *        It saves the number of parameters
0564 0199              *        the D & B registers
0565 0199              *        moves the stack down by ZPSize bytes
0566 0199              *        move the Direct register to the stack
0567 0199              *
0568 0199              * Called VIA $E1 vector
0569 0199              *
0570 0199              * Link2 entry point from ram disk
0571 0199              *
0572 0199              ********************************************************************************
0573 0199              XLink    PROC 
0574 0199                       longa on
0575 0199                       longi on
0576 0199
0577 0199 8A                    txa   
0578 019A EB                    xba   
0579 019B E2 30                 sep   #$30                     ;Into 8 bit mode
0580 019D                       longa off
0581 019D                       longi off
0582 019D
0583 019D 29 FF                 and   #$FF
0584 019F AA                    tax                            ;X = Index for parm count
0585 01A0
0586 01A0 A9 E1                 lda   #$E1                     ;Bank reg for later
0587 01A2 48                    pha   
0588 01A3 BF 0E 01 FC           lda   >ParmCnt-1,x             ;Get number of parameters
0589 01A7
0590 01A7                       ENTRY Link2
0591 01A7              Link2                                   ;       
0592 01A7
0593 01A7 C2 30                 rep   #$30
0594 01A9                       longa on
0595 01A9                       longi on
0596 01A9
0597 01A9 FA                    plx                            ;Save return address
0598 01AA 7A                    ply                            ;and bank
0599 01AB 29 FF 00              and   #$00FF                   ;Lower byte valid
0600 01AE 48                    pha   
0601 01AF 3B                    tsc                            ;Pull stack down
0602 01B0 38                    sec   
0603 01B1 E9 24 00              sbc   #ZPSize
0604 01B4 1B                    tcs   
0605 01B5 8B                    phb   
0606 01B6 0B                    phd   
0607 01B7 5B                    tcd   
0608 01B8 64 23                 stz   retry
0609 01BA 64 01                 stz   error                    ;Clear the error
0610 01BC 5A                    phy                            ;Push RTL addr and bank
0611 01BD DA                    phx   
0612 01BE 22 64 00 E1           jsl   IncBusyFlg               ;Mark us busy
0613 01C2 AB                    plb                            ;B = $E1
0614 01C3 6B                    rtl   
0615 01C4
0616 01C4                       ENDP 
0617 01C4
0618 01C4              ********************************************************************************
0619 01C4              *
0620 01C4              * CleanUp - Jumped to to exit from a tool
0621 01C4              *           It restores stack, D & B
0622 01C4              *           Pulls the parameters off off the stack
0623 01C4              *           Loads error code into A
0624 01C4              *           Sets C=1 if A <> 0
0625 01C4              *
0626 01C4              * Calls goes through vector in $E1
0627 01C4              *
0628 01C4              ********************************************************************************
0629 01C4              XCleanup PROC 
0630 01C4                       longa on
0631 01C4                       longi on
0632 01C4
0633 01C4 22 68 00 E1           jsl   DecBusyFlg               ;Open for business!
0634 01C8 A6 25                 ldx   numparms                 ;Get # params into X
0635 01CA A5 2B                 lda   return+4                 ;Move return address
0636 01CC 95 2B                 sta   return+4,x
0637 01CE A5 29                 lda   return+2
0638 01D0 95 29                 sta   return+2,x
0639 01D2 A5 27                 lda   return
0640 01D4 95 27                 sta   return,x
0641 01D6 3B                    tsc                            ;Now fix the stack
0642 01D7 18                    clc   
0643 01D8 65 25                 adc   numparms                 ;Stack = stack + ZP + parms
0644 01DA 69 29 00              adc   #ZPSize+5
0645 01DD AA                    tax                            ;Save it for now
0646 01DE 2B                    pld   
0647 01DF AB                    plb   
0648 01E0 68                    pla                            ;Get error code
0649 01E1 C9 01 00              cmp   #1                       ;C = 1 if <> 0
0650 01E4 9A                    txs                            ;Really fix the stack
0651 01E5 B0 01                 bcs   ErrorExit
0652 01E7 6B                    rtl                            ;Go back to user
0653 01E8
0654 01E8 6B           ErrorExit rtl                           ;Something to trigger off of
0655 01E9
0656 01E9
0657 01E9                       ENDP 
0658 01E9
0659 01E9
0660 01E9
0661 01E9              ********************************************************************************
0662 01E9              *
0663 01E9              * QuickExit - Quick exit for routines not using local ZP and having no errors
0664 01E9              *
0665 01E9              ********************************************************************************
0666 01E9              QuickExit PROC 
0667 01E9                       longa on
0668 01E9                       longi on
0669 01E9
0670 01E9 A9 00 00              lda   #0
0671 01EC 18                    clc   
0672 01ED 6B                    rtl   
0673 01EE
0674 01EE                       ENDP 
0675 01EE
0676 01EE                       Title ' Initialization stuff'
0677 01EE              ********************************************************************************
0678 01EE              *
0679 01EE              * Initialization routines
0680 01EE              *
0681 01EE              ********************************************************************************
0682 01EE
0683 01EE
0684 01EE
0685 01EE              ********************************************************************************
0686 01EE              *
0687 01EE              * BootInit
0688 01EE              *  This is the power up call to the memory mananger
0689 01EE              *  If PowerFlag is 0, it will:
0690 01EE              *    Determine how much memory is in the computer
0691 01EE              *    Initialize all MM constants and pointers
0692 01EE              *    Create 1K worth of pointers
0693 01EE              *    Busy out all of the areas not used by the MM
0694 01EE              *
0695 01EE              *  Caution: This call wipes the machine and frees everything
0696 01EE              *
0697 01EE              *
0698 01EE              * Change History
0699 01EE              *
0700 01EE              * 30 Aug 88         Steven Glass
0701 01EE              *
0702 01EE              * Added conditional compile code below to make it possible to run the memory
0703 01EE              * manager in RAM.
0704 01EE              *
0705 01EE              * 08 Jan 89         Steven Glass
0706 01EE              *
0707 01EE              * Also zeroed the FirstOOMPtr so that reboot clears the OOM
0708 01EE              * queue.
0709 01EE              *
0710 01EE              ********************************************************************************
0711 01EE
0712 01EE              MMBootInit PROC 
0713 01EE                       longa on
0714 01EE                       longi on
0715 01EE
0716 01EE              ; See if a true power up
0717 01EE AF FE 15 E1           lda   PowerFlag
0718 01F2 10 17                 bpl   NoRestart
0719 01F4
0720 01F4 22 88 16 E1           jsl   Link
0721 01F8
0722 01F8 20 90 14              jsr   ClearRecent
0723 01FB              ;
0724 01FB              ; Clear the OOM queue.
0725 01FB              ;
0726 01FB 9C 38 16              stz   |FirstOOMPtr
0727 01FE 9C 3A 16              stz   |FirstOOMPtr+2
0728 0201
0729 0201
0730 0201 22 B8 16 E1           jsl   Restart                  ;See if warm start
0731 0205 B0 08                 bcs   PowerUp                  ;If failed then cold start
0732 0207 5C 8C 16 E1           jml   Cleanup
0733 020B
0734 020B 22 99 01 FC  NoRestart jsl   XLink                   ;Vectors not set up yet
0735 020F
0736 020F              ; First clear out all of our pointers
0737 020F
0738 020F A9 00 00     PowerUp  lda   #nil
0739 0212 A2 00 05              ldx   #MMRamEnd-MMRam-1        ;# bytes to nil out
0740 0215 9D FE 15     biClear  sta   |MMram,x
0741 0218 CA                    dex   
0742 0219 CA                    dex   
0743 021A 10 F9                 bpl   biClear
0744 021C
0745 021C              ; Now make HandleBuf a bunch of handles
0746 021C A9 E8 1A              lda   #50*HSize+(HandleBuf**$FFFF) ;Make 51 handles
0747 021F AA                    tax   
0748 0220              ; Mark This handle as next of lower handle
0749 0220 9F FC FF E0  biLinkH  sta   >$E10000-HSize+Hndl_Next,x
0750 0224 A9 E1 00              lda   #^HandleBuf
0751 0227 9F FE FF E0           sta   >$E10000-Hsize+Hndl_Next+2,x
0752 022B 8A                    txa   
0753 022C 38                    sec   
0754 022D E9 14 00              sbc   #HSize                   ;Go down one handle
0755 0230
0756 0230              ; Mark this handle as previous of higher handle
0757 0230 AA                    tax   
0758 0231 9D 20 00              sta   |HSize+Hndl_Prev,x
0759 0234 A9 E1 00              lda   #^HandleBuf
0760 0237 9D 22 00              sta   |HSize+Hndl_Prev+2,x
0761 023A 8A                    txa   
0762 023B C9 00 17              cmp   #HandleBuf**$FFFF        ;Last one?
0763 023E D0 E0                 bne   biLinkH                  ;Go link next one
0764 0240
0765 0240              ; The first 6 handles go in MemList and the rest are free
0766 0240
0767 0240 A9 00 00              lda   #nil                     ;Split the list between 6 & 7
0768 0243 8D 74 17              sta   |5*HSize+HandleBuf+Hndl_Next
0769 0246 8D 76 17              sta   |5*Hsize+HandleBuf+Hndl_Next+2
0770 0249 8D 84 17              sta   |6*HSize+HandleBuf+Hndl_Prev
0771 024C 8D 86 17              sta   |6*Hsize+HandleBuf+Hndl_Prev+2
0772 024F
0773 024F              ; Initialize FreeList, MemList, PurgeList and init Mem01 - MemFF
0774 024F A2 1E 00              ldx   #30
0775 0252 BF E5 02 FC  SetPtr   lda   >PtrInit,x
0776 0256 9D 00 16              sta   |MemList,x
0777 0259 CA                    dex   
0778 025A CA                    dex   
0779 025B 10 F5                 bpl   SetPtr
0780 025D
0781 025D              ; Now add the addresses and size info to the memlist segments
0782 025D A2 00 00              ldx   #0
0783 0260 9B                    txy   
0784 0261 BF B5 02 FC  BusyLoop lda   >HInit,x
0785 0265 99 00 17              sta   |HandleBuf+Hndl_Addr,y   ;-$E1 to make orca work
0786 0268 BF B7 02 FC           lda   >HInit+2,x
0787 026C 99 02 17              sta   |HandleBuf+Hndl_Addr+2,y
0788 026F BF B9 02 FC           lda   >HInit+4,x               ;Now the size
0789 0273 99 08 17              sta   |HandleBuf+Hndl_Size,y
0790 0276 BF BB 02 FC           lda   >HInit+6,x
0791 027A 99 0A 17              sta   |HandleBuf+Hndl_Size+2,y
0792 027D A9 00 C0              lda   #Attr_Locked+Attr_Fixed
0793 0280 99 04 17              sta   |Handlebuf+Hndl_Attr,y   ;Lock it down
0794 0283 8A                    txa   
0795 0284 18                    clc   
0796 0285 69 08 00              adc   #8
0797 0288 AA                    tax   
0798 0289 98                    tya   
0799 028A 69 14 00              adc   #HSize
0800 028D A8                    tay   
0801 028E C9 78 00              cmp   #HSize*6
0802 0291 90 CE                 blt   BusyLoop
0803 0293
0804 0293              ; Now fix the 4th segment for the actual amount of ram in the machine
0805 0293 20 05 03              jsr   TestMem                  ;Get memory size
0806 0296 8D 3E 17              sta   |HandleBuf+HSize*3+Hndl_Addr+2
0807 0299 8A                    txa   
0808 029A 8D 46 17              sta   |HandleBuf+HSize*3+Hndl_Size+2
0809 029D
0810 029D              ; Initialize the vectors in $E1
0811 029D A2 3A 00              ldx   #Vlen
0812 02A0 BF 4D 01 FC  VectLoop lda   >Vectors,x
0813 02A4 9D 80 16              sta   |MMPatcher,x
0814 02A7 CA                    dex   
0815 02A8 CA                    dex   
0816 02A9 10 F5                 bpl   VectLoop
0817 02AB
0818 02AB              ; Mark that we are up and running!
0819 02AB A9 FF FF              lda   #True
0820 02AE 8D FE 15              sta   |PowerFlag
0821 02B1
0822 02B1 5C 8C 16 E1           jml   CleanUp                  ;Go home
0823 02B5
0824 02B5              ; HInit - Table of initial handle data
0825 02B5                       ENTRY HInit
0826 02B5              HInit                                   ; 
0827 02B5 00 00 00 00           DC L:$00000000
0828 02B9 00 08 00 00           DC L:$800
0829 02BD 00 C0 00 00           DC L:$0000C000
0830 02C1 00 48 00 00           DC L:$00010800-$0000C000
0831 02C5 00 C0 01 00           DC L:$0001C000
0832 02C9 00 40 00 00           DC L:$00020000-$0001C000
0833 02CD 00 00 02 00           DC L:$00020000
0834 02D1 00 20 DE 00           DC L:$00E02000-$00020000
0835 02D5 00 C0 E0 00           DC L:$00E0C000
0836 02D9 00 60 00 00           DC L:$00E12000-$00E0C000
0837 02DD 00 C0 E1 00           DC L:$00E1C000
0838 02E1 00 40 1E FF           DC L:$FFFFFFFF-$00E1C000+1
0839 02E5
0840 02E5              ; PtrInit - Table of initial values for list pointers
0841 02E5                       ENTRY PtrInit
0842 02E5              PtrInit                                 ; 
0843 02E5 00 17 E1 00           DC L:HandleBuf                 ;MemList
0844 02E9 00 00 00 00           DC L:nil                       ;PurgeList
0845 02ED 78 17 E1 00           DC L:HandleBuf+HSize*6         ;FreeList
0846 02F1 14 17 E1 00           DC L:HandleBuf+HSize           ;Mem01
0847 02F5 28 17 E1 00           DC L:HandleBuf+HSize*2         ;Mem02
0848 02F9 3C 17 E1 00           DC L:HandleBuf+HSize*3         ;MemE0
0849 02FD 50 17 E1 00           DC L:HandleBuf+HSize*4         ;MemE1
0850 0301 64 17 E1 00           DC L:HandleBuf+HSize*5         ;MemFF
0851 0305
0852 0305
0853 0305                       ENDP 
0854 0305
0855 0305              ********************************************************************************
0856 0305              *
0857 0305              * TESTMEM - Tests the memory size
0858 0305              *  This routine writes the complement of the bank number in banks 2 - DF
0859 0305              *  and then scans down until it can read one back
0860 0305              *
0861 0305              * Outputs A: Start of unreadable banks X: Number of empty banks
0862 0305              *
0863 0305              ********************************************************************************
0864 0305              TestMem  PROC 
0865 0305                       longa on
0866 0305                       longi on
0867 0305
0868 0305 A9 00 00              lda   #$0000                   ;Starts at $7F0000
0869 0308 85 03                 sta   addr
0870 030A A9 7F 00              lda   #$007F
0871 030D 85 05                 sta   addr+2
0872 030F 49 FF FF              eor   #$FFFF
0873 0312 87 03        WriteLoop sta   [addr]                  ;Write complement in bank
0874 0314 C6 05                 dec   addr+2
0875 0316 1A                    inc   A                        ;Go to next bank
0876 0317 C9 FE FF              cmp   #$FFFE
0877 031A D0 F6                 bne   WriteLoop
0878 031C A9 7F 00              lda   #$007F                   ;Now read em back
0879 031F 85 05                 sta   addr+2
0880 0321 49 FF FF              eor   #$FFFF
0881 0324 A2 60 00              ldx   #$0060                   ;Count # unused banks
0882 0327 C7 03        TestLoop cmp   [addr]
0883 0329 F0 09                 beq   GoodBank                 ;Found a good bank?
0884 032B E8                    inx   
0885 032C C6 05                 dec   addr+2
0886 032E 1A                    inc   A
0887 032F C9 FE FF              cmp   #$FFFE
0888 0332 D0 F3                 bne   TestLoop                 ;Restore contents
0889 0334 A5 05        GoodBank lda   addr+2                   ;Get highest readable bank
0890 0336 1A                    inc   A                        ;Lowest unreadable bank
0891 0337 8D 24 16              sta   |NumBanks                ;Save it away
0892 033A 60                    rts   
0893 033B
0894 033B                       ENDP 
0895 033B
0896 033B
0897 033B
0898 033B              ********************************************************************************
0899 033B              *
0900 033B              * Restart - This tests for a warm start of the MM
0901 033B              *              If the power up byte if 0, then it fails
0902 033B              *              If the memory lists are inconsistent, then it fails
0903 033B              *              If a warm start is done then all blocks not owned by the MM
0904 033B              *               are disposed
0905 033B              *
0906 033B              *           Outputs: C = 1 if warm start failed and cold start must be done
0907 033B              *
0908 033B              * Rev 2 changes: Fixed so it doesn't dispose valid handles
0909 033B              *
0910 033B              ********************************************************************************
0911 033B              XRestart PROC 
0912 033B                       longa on
0913 033B                       longi on
0914 033B
0915 033B 20 A7 03              jsr   Validate                 ;Check the memory lists
0916 033E D0 65                 bne   NoRestart
0917 0340
0918 0340              * Get rid of all non MM blocks
0919 0340 20 E4 03              jsr   ScanHandles              ;Mark handles that we must keep
0920 0343 A2 04 00              ldx   #PurgeList-MemList
0921 0346 20 48 04              jsr   TrimFree                 ;Trim the purge list
0922 0349 A2 08 00              ldx   #FreeList-MemList
0923 034C 20 48 04              jsr   TrimFree
0924 034F
0925 034F 20 23 0C              jsr   Start0                   ;Go through all used segs
0926 0352 20 0A 0F     TrimLoop jsr   GetNext                  ;Hndl1 = next block
0927 0355 F0 4C                 beq   TrimDone
0928 0357 A0 06 00              ldy   #Hndl_Owner              ;Get the owner
0929 035A B7 0F                 lda   [Hndl1],y
0930 035C 89 00 FF              bit   #$FF00                   ;Is high byte MM
0931 035F D0 0E                 bne   TrimIt                   ;Throw it out if not
0932 0361 C9 FF 00              cmp   #SaveID                  ;Save it as free?
0933 0364 D0 EC                 bne   TrimLoop
0934 0366 88                    dey   
0935 0367 88                    dey   
0936 0368 B7 0F                 lda   [Hndl1],y                ;don't dispose block of handles
0937 036A 89 00 10              bit   #Attr_Handle
0938 036D D0 E3                 bne   TrimLoop
0939 036F
0940 036F              * The block needs to be discarded. Check if MM owns the handle!
0941 036F A5 0F 85 17  TrimIt   move_l hndl1,hndl
0942 0377 A5 15 48 A5           push_l hndl2                   ;Save the next handle to check
0943 037D 20 DC 0D              jsr   RemoveHandle             ;Remove it from where it is
0944 0380 A0 06 00              ldy   #hndl_owner
0945 0383 B7 17                 lda   [hndl],y
0946 0385 29 00 FF              and   #$FF00                   ;MM's?  Rev2 change.
0947 0388 F0 0E                 beq   KeepIt
0948 038A A5 19                 lda   hndl+2                   ;Is it the MMs
0949 038C C9 E1 00              cmp   #$00E1
0950 038F D0 0A                 bne   NotMine
0951 0391 A5 17                 lda   hndl
0952 0393 C9 00 1B              cmp   #$1B00
0953 0396 B0 03                 bge   NotMine
0954 0398 20 8B 0E     KeepIt   jsr   InsertFree               ;Put it in free handle list
0955 039B 68 85 13 68  NotMine  pop_l hndl2                    ;Get the next one to check
0956 03A1 80 AF                 bra   TrimLoop
0957 03A3
0958 03A3 18           TrimDone clc   
0959 03A4 6B                    rtl   
0960 03A5
0961 03A5 38           NoRestart sec   
0962 03A6 6B                    rtl   
0963 03A7
0964 03A7                       ENDP 
0965 03A7
0966 03A7
0967 03A7
0968 03A7              ********************************************************************************
0969 03A7              *
0970 03A7              * Validate-    This routine checks the memory lists for consistency
0971 03A7              *              For each element in the list hndl.next.prev must equal hndl
0972 03A7              *
0973 03A7              *              outputs: Z = 1 if lists OK
0974 03A7              *
0975 03A7              ********************************************************************************
0976 03A7              Validate PROC 
0977 03A7                       longa on
0978 03A7                       longi on
0979 03A7
0980 03A7 A2 00 00              ldx   #0                       ;Check memlist
0981 03AA 20 C8 03              jsr   CheckList
0982 03AD D0 34                 bne   Done                     ;Br if bad
0983 03AF
0984 03AF              * MemList's last block should be at $E1C000. If it isn't then the list has been
0985 03AF              * fragmented and we should cold start.
0986 03AF A5 1F                 lda   addr2                    ;Addr2 should be $00E1C000
0987 03B1 C9 00 C0              cmp   #$C000
0988 03B4 D0 2D                 bne   Done
0989 03B6 A5 21                 lda   addr2+2
0990 03B8 C9 E1 00              cmp   #$00E1
0991 03BB D0 26                 bne   Done
0992 03BD A2 04 00              ldx   #4                       ;Check purgelist
0993 03C0 20 C8 03              jsr   CheckList
0994 03C3 D0 1E                 bne   Done                     ;Br if bad
0995 03C5 A2 08 00              ldx   #8                       ;Check freelist. Fall into CheckList
0996 03C8
0997 03C8
0998 03C8              * CheckList - scans a single list
0999 03C8                       ENTRY CheckList
1000 03C8              CheckList                               ; 
1001 03C8 20 26 0C              jsr   StartX                   ;Get start of list
1002 03CB F0 16                 beq   Done                     ;Done if nil
1003 03CD
1004 03CD              * For each element in list make sure that the next one points back to it
1005 03CD              * Sets Z = 0 if bad list Z = 1 if list OK
1006 03CD 20 0A 0F     CheckLoop jsr   GetNext
1007 03D0 F0 11                 beq   Done                     ;Done if next is nil
1008 03D2 A0 0C 00              ldy   #hndl_prev               ;Get previous of next
1009 03D5 B7 13                 lda   [hndl2],y
1010 03D7 C5 0F                 cmp   hndl1                    ;Should be same as hndl1
1011 03D9 D0 08                 bne   Done
1012 03DB C8                    iny   
1013 03DC C8                    iny   
1014 03DD B7 13                 lda   [hndl2],y
1015 03DF C5 11                 cmp   hndl1+2
1016 03E1 F0 EA                 beq   CheckLoop                ;Loop if OK
1017 03E3
1018 03E3 60           Done     rts   
1019 03E4
1020 03E4                       ENDP 
1021 03E4
1022 03E4
1023 03E4
1024 03E4              ********************************************************************************
1025 03E4              *
1026 03E4              * ScanHandles - This routines scans down the list of used handles
1027 03E4              *              If it finds a block of handles, it looks if any segment
1028 03E4              *              is owned by the MM. If so, the block is preserved through reset
1029 03E4              *
1030 03E4              * Revision 2 - Fix to make FFFF ID for disposed block of handles
1031 03E4              *
1032 03E4              *
1033 03E4              ********************************************************************************
1034 03E4              ScanHandles PROC 
1035 03E4                       longa on
1036 03E4                       longi on
1037 03E4
1038 03E4 AF 00 16 E1           lda   >MemList                 ;Look down the list of used handles
1039 03E8 85 17                 sta   Hndl
1040 03EA AF 02 16 E1           lda   >MemList+2
1041 03EE 85 19                 sta   Hndl+2
1042 03F0
1043 03F0 A0 10 00     Loop     ldy   #hndl_next               ;Go to the next handle
1044 03F3 B7 17                 lda   [Hndl],y
1045 03F5 AA                    tax   
1046 03F6 C8                    iny   
1047 03F7 C8                    iny   
1048 03F8 B7 17                 lda   [Hndl],y
1049 03FA 85 19                 sta   Hndl+2
1050 03FC 86 17                 stx   Hndl
1051 03FE 05 19                 ora   Hndl+2                   ;Done if nil
1052 0400 F0 2E                 beq   Done
1053 0402
1054 0402              * Check if it is a block of handles
1055 0402 A0 04 00              ldy   #hndl_attr
1056 0405 B7 17                 lda   [Hndl],y
1057 0407 89 00 10              bit   #attr_handle
1058 040A F0 E4                 beq   Loop                     ;Br if not handles
1059 040C
1060 040C              * It's a block of handles.  Check if we have to keep any
1061 040C              * Hndl is also the address of the block
1062 040C A0 08 00              ldy   #hndl_size               ;Low byte of size. High = 0
1063 040F B7 17                 lda   [Hndl],y
1064 0411 38                    sec                            ;Make index for owner of last one
1065 0412 E9 0E 00              sbc   #HSize-hndl_owner
1066 0415 AA                    tax                            ;Save in X for later
1067 0416 A8           KeepCheck tay   
1068 0417 B7 17                 lda   [Hndl],y                 ;Get the owner
1069 0419 29 00 FF              and   #$FF00                   ;If High word 0 then MM own's it!
1070 041C F0 13                 beq   KeepEm                   ;If so, then keep them
1071 041E 98                    tya                            ;Go down to next handle
1072 041F 38                    sec   
1073 0420 E9 14 00              sbc   #HSize
1074 0423 C9 14 00              cmp   #HSize
1075 0426 B0 EE                 bge   KeepCheck
1076 0428
1077 0428 A8                    tay   
1078 0429 A9 FF FF              lda   #$FFFF                   ;Mark block as disposable
1079 042C 97 17                 sta   [Hndl],y
1080 042E 80 C0                 bra   Loop                     ;Don't keep the block
1081 0430
1082 0430 60           Done     rts   
1083 0431
1084 0431
1085 0431 8A           KeepEm   txa                            ;Get index to last one
1086 0432 A8           KeepEm2  tay   
1087 0433 B7 17                 lda   [Hndl],y                 ;Get the owner
1088 0435 29 00 FF              and   #$FF00                   ;Does MM own it?
1089 0438 F0 05                 beq   OwnerOK                  ;If so, leave alove
1090 043A A9 FF 00              lda   #SaveID                  ;Mark as spare to be saved
1091 043D 97 17                 sta   [Hndl],y
1092 043F 98           OwnerOK  tya                            ;Go to next one
1093 0440 38                    sec   
1094 0441 E9 14 00              sbc   #HSize
1095 0444 10 EC                 bpl   KeepEm2
1096 0446 80 A8                 bra   Loop
1097 0448
1098 0448                       ENDP 
1099 0448
1100 0448
1101 0448              ********************************************************************************
1102 0448              *
1103 0448              * TrimFree - Removes any non memory manager block from the free or purge list
1104 0448              *
1105 0448              * Inputs:      X = list to trim
1106 0448              *
1107 0448              * This routine was replaced in rev 2. Rev 1 would lose handles in $E1
1108 0448              *
1109 0448              ********************************************************************************
1110 0448              TrimFree PROC 
1111 0448                       longa on
1112 0448                       longi on
1113 0448
1114 0448 BF 02 16 E1           lda   >MemList+2,x             ;Get the desired list
1115 044C 48                    pha   
1116 044D BF 00 16 E1           lda   >MemList,x
1117 0451 48                    pha   
1118 0452
1119 0452 68           Loop     pla                            ;Get the handle to do
1120 0453 85 17                 sta   Hndl
1121 0455 68                    pla   
1122 0456 85 19                 sta   Hndl+2
1123 0458 05 17                 ora   Hndl                     ;Nil?
1124 045A F0 2D                 beq   Done
1125 045C
1126 045C A0 12 00              ldy   #hndl_next+2             ;Get the next handle
1127 045F B7 17                 lda   [Hndl],y                 ;and save it on the stack
1128 0461 48                    pha   
1129 0462 88                    dey   
1130 0463 88                    dey   
1131 0464 B7 17                 lda   [Hndl],y
1132 0466 48                    pha   
1133 0467
1134 0467 A0 06 00              ldy   #hndl_owner              ;If handle belongs to MM
1135 046A B7 17                 lda   [hndl],y                 ;then leave it where it is
1136 046C C9 FF 00              cmp   #$00FF
1137 046F 90 E1                 blt   Loop
1138 0471 08                    php                            ;If Z = 1 then put in free list
1139 0472 20 DC 0D              jsr   RemoveHandle             ;Remove it from the list
1140 0475 28                    plp                            ;Did we want to save it?
1141 0476 F0 0C                 beq   KeepIt                   ;owner was 00FF
1142 0478 A5 18                 lda   hndl+1                   ;Is it in $E11700 - $E11AFF?
1143 047A C9 17 E1              cmp   #$E117                   ;< $E11700?
1144 047D 90 D3                 blt   Loop
1145 047F C9 1B E1              cmp   #$E11B                   ;> $E11B00
1146 0482 B0 CE                 bge   Loop
1147 0484
1148 0484 20 8B 0E     KeepIt   jsr   InsertFree               ;Put it in the free list
1149 0487 80 C9                 bra   Loop
1150 0489
1151 0489 60           Done     rts   
1152 048A
1153 048A                       ENDP 
1154 048A
1155 048A
1156 048A              ********************************************************************************
1157 048A              *
1158 048A              * MMPatcher - Used to Patch ram patches to the MM into the tool locator
1159 048A              *
1160 048A              ********************************************************************************
1161 048A              XMMPatcher PROC 
1162 048A                       longa on
1163 048A                       longi on
1164 048A
1165 048A 6B                    rtl   
1166 048B
1167 048B                       ENDP 
1168 048B
1169 048B
1170 048B
1171 048B              ********************************************************************************
1172 048B              *
1173 048B              * WarmStart - called via a JSL from the tool locator after tool initialization
1174 048B              *
1175 048B              ********************************************************************************
1176 048B              XWarmStart PROC 
1177 048B                       longa on
1178 048B                       longi on
1179 048B
1180 048B 20 90 14              jsr   ClearRecent
1181 048E
1182 048E 6B                    rtl   
1183 048F
1184 048F                       ENDP 
1185 048F
1186 048F                       Title ' Standard Calls'
1187 048F              ********************************************************************************
1188 048F              *
1189 048F              * Standard tool calls
1190 048F              *
1191 048F              ********************************************************************************
1192 048F
1193 048F
1194 048F              ********************************************************************************
1195 048F              *
1196 048F              * MMStartup - Application init for the memory manager
1197 048F              *
1198 048F              * outputs:     OwnerID returned on the stack
1199 048F              *
1200 048F              ********************************************************************************
1201 048F              MMStartup PROC 
1202 048F                       IMPORT GetIDOfCallingRoutine 
1203 048F                       longa on
1204 048F                       longi on
1205 048F
1206 048F 22 88 16 E1           jsl   Link
1207 0493
1208 0493 20 A5 04              jsr   GetIDOfCallingRoutine
1209 0496 90 06                 bcc   BadID
1210 0498 85 2D                 sta   Parms
1211 049A 5C 8C 16 E1  GetOut   jml   CleanUp
1212 049E
1213 049E A9 07 02     BadID    lda   #IDErr
1214 04A1 85 01                 sta   error
1215 04A3 80 F5                 bra   GetOut
1216 04A5
1217 04A5                       ENDP 
1218 04A5
1219 04A5
1220 04A5
1221 04A5
1222 04A5              ****************************************************************
1223 04A5              *
1224 04A5              GetIDOfCallingRoutine PROC EXPORT  
1225 04A5              *
1226 04A5              * This little routine looks back on the stack at the routine
1227 04A5              * making a memory manager call.  It then finds what handle
1228 04A5              * that memory is contained in and returns the user ID of
1229 04A5              * the handle.
1230 04A5              *
1231 04A5              *
1232 04A5              * Inputs:
1233 04A5              *                   on direct page
1234 04A5              *
1235 04A5              * Outputs:
1236 04A5              *                   a-reg has user ID or zero
1237 04A5              *                   carry set => no error
1238 04A5              *                   carry clear => error
1239 04A5              *
1240 04A5                       longa on                       ; mode
1241 04A5                       longi on
1242 04A5              *
1243 04A5              ****************************************************************
1244 04A5
1245 04A5 A5 2A                 lda   return+3                 ;Make actual return address
1246 04A7 18                    clc   
1247 04A8 69 01 00              adc   #1
1248 04AB 85 03                 sta   addr
1249 04AD A5 2C                 lda   return+5
1250 04AF 69 00 00              adc   #0
1251 04B2 29 FF 00              and   #$00FF                   ;High bits unused
1252 04B5 85 05                 sta   addr+2
1253 04B7 20 23 0C              jsr   Start0                   ;Start searching through main memory
1254 04BA 20 0A 0F     Loop     jsr   GetNext                  ;Scan through the blocks
1255 04BD F0 19                 beq   AddrFound
1256 04BF A5 03 C5 1B           cmp_l addr,addr1               ;If < addr1 then in hndl1
1257 04C7 90 0F                 blt   AddrFound
1258 04C9 A5 03 C5 1F           cmp_l addr,addr2               ;If < addr2 then free
1259 04D1 B0 E7                 bge   Loop
1260 04D3
1261 04D3 A9 00 00     NoOwner  lda   #0                       ;No Owner
1262 04D6 18                    clc                            ;Indicate error
1263 04D7 60                    rts   
1264 04D8
1265 04D8 A0 06 00     AddrFound ldy   #Hndl_Owner             ;Get the owner
1266 04DB B7 0F                 lda   [hndl1],y
1267 04DD 89 00 F0              bit   #$F000                   ;Check high bits
1268 04E0 F0 F1                 beq   NoOwner
1269 04E2 38                    sec                            ;Indicate no error
1270 04E3 60                    rts   
1271 04E4
1272 04E4
1273 04E4
1274 04E4
1275 04E4                       ENDP 
1276 04E4
1277 04E4
1278 04E4              ********************************************************************************
1279 04E4              *
1280 04E4              * MMShutdown - Application shutdown
1281 04E4              *
1282 04E4              ********************************************************************************
1283 04E4              MMShutdown PROC EXPORT
1284 04E4                       longa on
1285 04E4                       longi on
1286 04E4
1287 04E4 22 88 16 E1           jsl   Link
1288 04E8
1289 04E8 A9 50 12              lda   #<XUserPurge             ;Reset the user purge routine
1290 04EB 8D B5 16              sta   |UserPurge+1
1291 04EE A9 12 FC              lda   #>XUserPurge
1292 04F1 8D B6 16              sta   |UserPurge+2
1293 04F4
1294 04F4 5C 8C 16 E1           jml   CleanUp
1295 04F8
1296 04F8                       ENDP 
1297 04F8
1298 04F8
1299 04F8
1300 04F8              ********************************************************************************
1301 04F8              *
1302 04F8              * GetVersion - Returns the version number
1303 04F8              *
1304 04F8              ********************************************************************************
1305 04F8              MMVersion PROC 
1306 04F8                       longa on
1307 04F8                       longi on
1308 04F8
1309 04F8 A9 00 03              lda   #Version                 ;Version #
1310 04FB 83 07                 sta   7,s
1311 04FD 4C E9 01              jmp   QuickExit                ;No error
1312 0500
1313 0500                       ENDP 
1314 0500
1315 0500
1316 0500
1317 0500              ********************************************************************************
1318 0500              *
1319 0500              * MMReset -    Called at reset
1320 0500              *              Returns error if MM lists invalid
1321 0500              *
1322 0500              * Change History
1323 0500              *
1324 0500              * 08 Jan 89         Steven Glass
1325 0500              *
1326 0500              * Also zeroed the FirstOOMPtr so that reset clears the OOM
1327 0500              * queue.
1328 0500              *
1329 0500              ********************************************************************************
1330 0500              MMReset  PROC 
1331 0500                       longa on
1332 0500                       longi on
1333 0500
1334 0500 22 88 16 E1           jsl   Link
1335 0504 20 90 14              jsr   ClearRecent              ;zero the most recently found handles.
1336 0507              ;
1337 0507              ; Clear the OOM queue.
1338 0507              ;
1339 0507 9C 38 16              stz   |FirstOOMPtr
1340 050A 9C 3A 16              stz   |FirstOOMPtr+2
1341 050D
1342 050D
1343 050D 20 A7 03              jsr   Validate                 ;Check the lists
1344 0510 F0 05                 beq   Done                     ;Br if OK
1345 0512 A9 01 02              lda   #MFullErr                ;Return an error
1346 0515 85 01                 sta   Error
1347 0517 5C 8C 16 E1  Done     jml   Cleanup
1348 051B
1349 051B                       ENDP 
1350 051B
1351 051B
1352 051B              ********************************************************************************
1353 051B              *
1354 051B              * Status - Returns if tool is active
1355 051B              *
1356 051B              ********************************************************************************
1357 051B              MMstatus PROC 
1358 051B                       longa on
1359 051B                       longi on
1360 051B
1361 051B A9 FF FF              lda   #true                    ;Return active
1362 051E 83 07                 sta   7,s
1363 0520 4C E9 01              jmp   QuickExit
1364 0523
1365 0523                       ENDP 
1366 0523
1367 0523
1368 0523                       title ' Creation and Dispose calls'
1369 0523              ********************************************************************************
1370 0523              *
1371 0523              *  NewHandle - Allocate a new handle
1372 0523              *
1373 0523              ********************************************************************************
1374 0523              NewHandle PROC 
1375 0523                       longa on
1376 0523                       longi on
1377 0523
1378 0523 22 88 16 E1           jsl   link                     ;Fix stack etc.
1379 0527
1380 0527
1381 0527              ;
1382 0527              ;---------------------------------------------------
1383 0527              ; Last minute phone patch from Rich applied 2 Mar 87
1384 0527              ;---------------------------------------------------
1385 0527 A9 FF FF              lda   #$FFFF
1386 052A 85 09                 sta   Owner
1387 052C              ;---------------------------------------------------
1388 052C              ; End of last minute phone patch from Rich
1389 052C              ;---------------------------------------------------
1390 052C              ;
1391 052C 22 9C 16 E1           jsl   GetFree                  ;Get a free handle
1392 0530 90 25                 bcc   full                     ;Br if err
1393 0532 A2 0A 00              ldx   #10                      ;Move parameters
1394 0535 B5 2D        MoveParms lda   parms,x
1395 0537 95 03                 sta   addr,x
1396 0539 CA                    dex   
1397 053A CA                    dex   
1398 053B 10 F8                 bpl   MoveParms
1399 053D A5 09                 lda   owner                    ;If owner = 0 somethings wrong
1400 053F F0 11                 beq   BadID
1401 0541 A5 0B                 lda   size                     ;Making an empty handle?
1402 0543 05 0D                 ora   size+2
1403 0545 F0 34                 beq   MakeEmpty
1404 0547 22 90 16 E1           jsl   Search                   ;Go get the segment
1405 054B 90 0A                 bcc   Full                     ;Br if error
1406 054D 20 84 0D              jsr   InsertHandle             ;Put handle in used list
1407 0550 80 11                 bra   Done
1408 0552
1409 0552 A9 07 02     BadID    lda   #IDErr                   ;Bad owner ID
1410 0555 80 03                 bra   ErrExit
1411 0557 A9 01 02     Full     lda   #MFullErr                ;Memory Full!!!
1412 055A 85 01        ErrExit  sta   error
1413 055C 20 8B 0E              jsr   InsertFree               ;Put the handle back
1414 055F 64 17                 stz   hndl                     ;Return nil pointer
1415 0561 64 19                 stz   hndl+2
1416 0563 A5 17 85 39  Done     move_l hndl,ResHndl            ;Return handle to caller
1417 056B
1418 056B              ;-----------------------------------------------------------
1419 056B              ;
1420 056B              ; As a debugging aid to those of us with Logic Analyzers,
1421 056B              ; we write the handle to a fixed location too.
1422 056B              ;
1423 056B A5 39                 lda   ResHndl
1424 056D 8F FC FF FE           sta   >NewDebugLoc
1425 0571 A5 3B                 lda   ResHndl+2
1426 0573 8F FE FF FE           sta   >NewDebugLoc+2
1427 0577
1428 0577              ;-----------------------------------------------------------
1429 0577
1430 0577 5C 8C 16 E1           jml   CleanUp
1431 057B
1432 057B
1433 057B
1434 057B A5 07        MakeEmpty lda   attr                    ;Is it locked or anything?
1435 057D 89 03 C0              bit   #Attr_Locked+Attr_Fixed+Attr_Addr+Attr_Bank
1436 0580 F0 05                 beq   NotLocked                ;Br if OK
1437 0582 A9 04 02              lda   #LockErr
1438 0585 80 D3                 bra   ErrExit                  ;Return error
1439 0587 20 A6 0D     NotLocked jsr   MoveAttr                ;Move attributes into block
1440 058A 20 02 0F              jsr   InsertPurge              ;Put it in the purge list
1441 058D 80 D4                 bra   Done
1442 058F
1443 058F                       ENDP 
1444 058F
1445 058F
1446 058F              ********************************************************************************
1447 058F              *
1448 058F              *  ReallocHandle - Creates a new handle with a purged one
1449 058F              *
1450 058F              ********************************************************************************
1451 058F              ReallocHandle PROC 
1452 058F                       longa on
1453 058F                       longi on
1454 058F
1455 058F 22 88 16 E1           jsl   link                     ;Fix stack etc.
1456 0593 20 50 10              jsr   VerifyHandle             ;Get the inputted handle
1457 0596 A7 17                 lda   [Hndl]                   ;Make sure addr is nil
1458 0598 A0 02 00              ldy   #hndl_addr+2
1459 059B 17 17                 ora   [Hndl],y
1460 059D F0 09                 beq   IsEmpty
1461 059F A9 03 02              lda   #NotNilErr               ;Return bad handle if not empty
1462 05A2 85 01                 sta   Error
1463 05A4 5C 8C 16 E1           jml   CleanUp
1464 05A8
1465 05A8
1466 05A8
1467 05A8 20 DC 0D     IsEmpty  jsr   RemoveHandle             ;Remove it from purged list
1468 05AB A2 0A 00              ldx   #10                      ;Move parameters
1469 05AE B5 31        MoveParms lda   parms+4,x
1470 05B0 95 03                 sta   addr,x
1471 05B2 CA                    dex   
1472 05B3 CA                    dex   
1473 05B4 10 F8                 bpl   MoveParms
1474 05B6 A5 09                 lda   owner                    ;If owner = 0 somethings wrong
1475 05B8 F0 11                 beq   BadID
1476 05BA A5 0B                 lda   size                     ;Making an empty handle?
1477 05BC 05 0D                 ora   size+2
1478 05BE F0 1C                 beq   MakeEmpty
1479 05C0 22 90 16 E1           jsl   Search                   ;Go get the segment
1480 05C4 90 0A                 bcc   Full                     ;Br if error
1481 05C6 20 84 0D              jsr   InsertHandle             ;Put handle in used list
1482 05C9 80 0D                 bra   Done
1483 05CB
1484 05CB A9 07 02     BadID    lda   #IDErr                   ;Bad owner ID
1485 05CE 80 03                 bra   ErrExit
1486 05D0 A9 01 02     Full     lda   #MFullErr                ;Memory Full!!!
1487 05D3 85 01        ErrExit  sta   error
1488 05D5 20 02 0F     PutPurge jsr   InsertPurge              ;Put the handle back
1489 05D8 5C 8C 16 E1  Done     jml   CleanUp
1490 05DC
1491 05DC A5 07        MakeEmpty lda   attr                    ;Is it locked or anything?
1492 05DE 89 03 C0              bit   #Attr_Locked+Attr_Fixed+Attr_Addr+Attr_Bank
1493 05E1 F0 05                 beq   NotLocked                ;Br if OK
1494 05E3 A9 04 02              lda   #LockErr
1495 05E6 80 EB                 bra   ErrExit                  ;Return error
1496 05E8 20 A6 0D     NotLocked jsr   MoveAttr                ;Move attributes into block
1497 05EB 80 E8                 bra   PutPurge
1498 05ED
1499 05ED                       ENDP 
1500 05ED
1501 05ED
1502 05ED
1503 05ED
1504 05ED              ********************************************************************************
1505 05ED              *
1506 05ED              * RestoreHandle - used to restore a purged handle
1507 05ED              *
1508 05ED              * inputs:      parmhndl - handle to be restored
1509 05ED              *
1510 05ED              * Note: the handle can't be restored if it is in a fixed bank or address
1511 05ED              *
1512 05ED              ********************************************************************************
1513 05ED              RestoreHandle PROC 
1514 05ED                       longa on
1515 05ED                       longi on
1516 05ED
1517 05ED 22 88 16 E1           jsl   Link
1518 05F1 20 50 10              jsr   VerifyHandle             ;Make sure it is a good handle
1519 05F4 20 B3 0D              jsr   GetAttr                  ;Get the attributes
1520 05F7
1521 05F7 A5 03                 lda   addr                     ;Must be empty
1522 05F9 05 05                 ora   addr+2
1523 05FB F0 05                 beq   IsEmpty
1524 05FD
1525 05FD A9 03 02              lda   #NotNilErr               ;not empty!!!!!!!
1526 0600 80 1B                 bra   ErrExit
1527 0602
1528 0602 A5 07        IsEmpty  lda   attr                     ;Can't be fixed addr
1529 0604 89 03 00              bit   #Attr_Addr+Attr_Bank
1530 0607 F0 05                 beq   AttrsOK
1531 0609 A9 08 02              lda   #AttrErr                 ;Invalid attributes
1532 060C 80 0F                 bra   ErrExit
1533 060E
1534 060E
1535 060E A5 0B        AttrsOK  lda   size                     ;If size = 0, leave it purged
1536 0610 05 0D                 ora   size+2
1537 0612 F0 0B                 beq   Done
1538 0614
1539 0614 22 98 16 E1           jsl   Realloc                  ;Reallocate the handle
1540 0618 90 05                 bcc   Done                     ;Br if OK
1541 061A
1542 061A A9 01 02              lda   #MFullErr                ;Didn't work
1543 061D 85 01        ErrExit  sta   Error
1544 061F 5C 8C 16 E1  Done     jml   CleanUp
1545 0623
1546 0623                       ENDP 
1547 0623
1548 0623
1549 0623
1550 0623
1551 0623              ********************************************************************************
1552 0623              *
1553 0623              * DisposHandle - Purges a handle and puts it in the FreeList
1554 0623              *
1555 0623              * inputs:      ParmHndl: Handle to be disposed
1556 0623              *
1557 0623              * Change History
1558 0623              *
1559 0623              * 30 Aug 88         Steven Glass
1560 0623              *
1561 0623              * Added call to CheckRecent.
1562 0623              *
1563 0623              * This compares the handle being disposed against the handle most recently
1564 0623              * allocated and clears the variable if they are equal.
1565 0623              *
1566 0623              ********************************************************************************
1567 0623              DisposHandle PROC 
1568 0623              DisposeHandle  
1569 0623                       longa on
1570 0623                       longi on
1571 0623
1572 0623 22 88 16 E1           jsl   link
1573 0627 20 50 10              jsr   VerifyHandle             ;Make sure it's valid
1574 062A 20 4F 14              jsr   CheckRecent              ;Clean up last allocated list if necessary 29 Aug 88 SEG
1575 062D 20 DC 0D              jsr   RemoveHandle             ;Remove it from where it is
1576 0630 20 8B 0E              jsr   InsertFree               ;Put it in free handle list
1577 0633
1578 0633              ;-----------------------------------------------------------
1579 0633              ;
1580 0633              ; As a debugging aid to those of us with Logic Analyzers,
1581 0633              ; we write the handle to a fixed location too.
1582 0633              ;
1583 0633 A5 17                 lda   hndl
1584 0635 8F F8 FF FE           sta   >DisposeDebugLoc
1585 0639 A5 19                 lda   hndl+2
1586 063B 8F FA FF FE           sta   >DisposeDebugLoc+2
1587 063F
1588 063F              ;-----------------------------------------------------------
1589 063F
1590 063F 5C 8C 16 E1           jml   CleanUp
1591 0643
1592 0643                       ENDP 
1593 0643
1594 0643
1595 0643
1596 0643              *******************************************************************************
1597 0643              *
1598 0643              * DisposAll - Disposes all of an owners handles
1599 0643              *
1600 0643              * Inputs:      parms = ownerID
1601 0643              *
1602 0643              *
1603 0643              * Change History
1604 0643              *
1605 0643              * 30 Aug 88         Steven Glass
1606 0643              *
1607 0643              * Added call to check recent inside the loop that does the dipsosing.
1608 0643              * This makes the check of any disposed handles against the most
1609 0643              * recently allocated.
1610 0643              *
1611 0643              * 06 Nov 88         Steven Glass
1612 0643              *
1613 0643              * Changed order of two calls:  CheckRecent and RemoveHandle.  Want to 
1614 0643              * check the recent list before removing it.
1615 0643              *
1616 0643              * 30 Nov 88         Steven Glass
1617 0643              *
1618 0643              * Check to see of the ID of the calling routine is the same the ID passed.
1619 0643              * If it is the same, then they are disposing of themselves, which is not 
1620 0643              * safe so we don't allow it.
1621 0643              *
1622 0643              *******************************************************************************
1623 0643              DisposAll PROC 
1624 0643                       longa on
1625 0643                       longi on
1626 0643
1627 0643 22 88 16 E1           jsl   link
1628 0647
1629 0647 20 A5 04              jsr   GetIDOfCallingRoutine
1630 064A
1631 064A C5 2D                 cmp   Parms
1632 064C D0 07                 bne   IsOK
1633 064E
1634 064E A9 00 00              lda   #$0000                   ; 4/21/89 Mensch cause IDErr broke too many apps
1635 0651 85 01                 sta   Error
1636 0653 80 12                 bra   BadID
1637 0655
1638 0655 20 56 09     IsOK     jsr   MakeIDMask
1639 0658 B0 0D                 bcs   BadID                    ;Br if bad id
1640 065A 20 6B 06              jsr   DoIt                     ;Free used handles
1641 065D AD 06 16              lda   |PurgeList+2             ;Now do the purged handles
1642 0660 AA                    tax   
1643 0661 AD 04 16              lda   |PurgeList
1644 0664 20 6B 06              jsr   DoIt
1645 0667 5C 8C 16 E1  BadID    jml   CleanUp                  ;All done
1646 066B
1647 066B              * This routine scans through a list and frees them
1648 066B 20 62 0D     DoIt     jsr   SearchID                 ;Find a matching owner in used handl
1649 066E 90 0F                 bcc   Done                     ;Br if no more
1650 0670 48                    pha                            ;Save a,x
1651 0671 DA                    phx   
1652 0672 20 4F 14              jsr   CheckRecent              ;Clean up last allocated list if necessary 29 Aug 88 SEG
1653 0675 20 DC 0D              jsr   RemoveHandle             ;Remove it from where it is
1654 0678 20 8B 0E              jsr   InsertFree               ;Put it in the free list
1655 067B FA                    plx   
1656 067C 68                    pla   
1657 067D 80 EC                 bra   DoIt
1658 067F 60           Done     rts   
1659 0680
1660 0680                       ENDP 
1661 0680
1662 0680
1663 0680
1664 0680              ********************************************************************************
1665 0680              *
1666 0680              * PurgeHandle - Purges a handle
1667 0680              *
1668 0680              * inputs:      ParmHndl: Handle to be purged
1669 0680              *
1670 0680              * note: The handle must be unlocked and purgeable
1671 0680              *
1672 0680              ********************************************************************************
1673 0680              PurgeHandle PROC 
1674 0680                       longa on
1675 0680                       longi on
1676 0680
1677 0680 22 88 16 E1           jsl   link
1678 0684 20 50 10              jsr   VerifyHandle
1679 0687 20 A9 06              jsr   DoPurge                  ;Purge it
1680 068A 5C 8C 16 E1           jml   Cleanup
1681 068E
1682 068E                       ENDP 
1683 068E
1684 068E
1685 068E
1686 068E              *******************************************************************************
1687 068E              *
1688 068E              * PurgeAll - Purges all of an owners purgeable handles
1689 068E              *
1690 068E              * Inputs:      parms = ownerID
1691 068E              *
1692 068E              *
1693 068E              * Change History
1694 068E              *
1695 068E              * 23 Oct 88         Steven Glass
1696 068E              *
1697 068E              * Used MakeIDMask2 so that 0 can be passed as master ID.
1698 068E              *
1699 068E              * Added stz error at AlmostDone, since none of the errors returned
1700 068E              * mean anything and a purgeall is supposed to go purge what can
1701 068E              * be purged and leave the rest.
1702 068E              *
1703 068E              * 31 Oct 88         Steven Glass
1704 068E              *
1705 068E              * Removed stz error.  Someone relied on this random error.  Verrrrry
1706 068E              * weird, but we have to keep the Apps running.
1707 068E              *
1708 068E              *******************************************************************************
1709 068E              PurgeAll PROC 
1710 068E                       longa on
1711 068E                       longi on
1712 068E
1713 068E 22 88 16 E1           jsl   link
1714 0692
1715 0692 20 84 09              jsr   MakeIDMask2
1716 0695 B0 0E                 bcs   Done                     ;Br if bad ID
1717 0697 20 62 0D     Loop     jsr   SearchID                 ;Find a matching owner
1718 069A 90 09                 bcc   Done                     ;Br if no more
1719 069C 48                    pha                            ;Save a,x
1720 069D DA                    phx   
1721 069E 20 A9 06              jsr   DoPurge                  ;Purge it
1722 06A1 FA                    plx   
1723 06A2 68                    pla   
1724 06A3 80 F2                 bra   Loop
1725 06A5
1726 06A5 5C 8C 16 E1  Done     jml   CleanUp                  ;All done
1727 06A9
1728 06A9                       ENDP 
1729 06A9
1730 06A9
1731 06A9
1732 06A9              ********************************************************************************
1733 06A9              *
1734 06A9              * DoPurge - purges a handle
1735 06A9              *
1736 06A9              * Inputs: hndl = handle to be purged
1737 06A9              *
1738 06A9              ********************************************************************************
1739 06A9              DoPurge  PROC 
1740 06A9                       longa on
1741 06A9                       longi on
1742 06A9
1743 06A9 A0 04 00              ldy   #Hndl_Attr               ;Get attributes of handle
1744 06AC B7 17                 lda   [hndl],y
1745 06AE 30 10                 bmi   IsLocked                 ;Br if locked
1746 06B0 89 00 03              bit   #Attr_Purge              ;Can we purge it
1747 06B3 F0 10                 beq   NoPurge                  ;Br if level 0
1748 06B5 20 4F 14              jsr   CheckRecent              ;Clean up last allocated list if necessary 29 Aug 88 SEG
1749 06B8 20 DC 0D              jsr   RemoveHandle
1750 06BB 20 02 0F              jsr   InsertPurge
1751 06BE 80 0A                 bra   Done
1752 06C0 A9 04 02     IsLocked lda   #LockErr
1753 06C3 80 03                 bra   Done1
1754 06C5 A9 05 02     Nopurge  lda   #PurgeErr
1755 06C8 85 01        Done1    sta   error
1756 06CA 60           Done     rts   
1757 06CB
1758 06CB                       ENDP 
1759 06CB
1760 06CB
1761 06CB                       title ' Information on block calls'
1762 06CB              ********************************************************************************
1763 06CB              *
1764 06CB              * GetHandleSize - Gets the size of a handle
1765 06CB              *
1766 06CB              * inputs:      ParmHndl = Handle to get size of
1767 06CB              *
1768 06CB              * outputs:     Size of handle
1769 06CB              *
1770 06CB              ********************************************************************************
1771 06CB              GetHandleSize PROC 
1772 06CB                       longa on
1773 06CB                       longi on
1774 06CB
1775 06CB 22 88 16 E1           jsl   Link
1776 06CF 20 50 10              jsr   VerifyHandle             ;Valid handle?
1777 06D2 A0 08 00 B7           geth_l Hndl,Parms+4,hndl_size  ;Get the size
1778 06DF 5C 8C 16 E1           jml   CleanUp
1779 06E3
1780 06E3                       ENDP 
1781 06E3
1782 06E3              ********************************************************************************
1783 06E3              *
1784 06E3              * SetHandleSize - Resizes a handle
1785 06E3              *                 The handle is grown or shrunk as appropriate
1786 06E3              *
1787 06E3              * Inputs:      ParmHndl = Handle to change
1788 06E3              *              Parms+4  = New size
1789 06E3              * Outputs:     none
1790 06E3              *
1791 06E3              * Revision2:   Handle made unpurgable while allocating
1792 06E3              *
1793 06E3              ********************************************************************************
1794 06E3              SetHandleSize PROC 
1795 06E3                       longa on
1796 06E3                       longi on
1797 06E3
1798 06E3 22 88 16 E1           jsl   link
1799 06E7 20 50 10              jsr   VerifyHandle             ;Get and check inputted handle
1800 06EA 20 B3 0D              jsr   GetAttr                  ;Get the properties of the handle
1801 06ED A5 03                 lda   addr                     ;If addr = 0 then size must be 0
1802 06EF 05 05                 ora   addr+2
1803 06F1 D0 06                 bne   NotNil
1804 06F3 A5 0B                 lda   size
1805 06F5 05 0D                 ora   size+2
1806 06F7 D0 45                 bne   IsPurged                 ;Br if purged
1807 06F9
1808 06F9 A6 0D        NotNil   ldx   size+2                   ;Switch new size and old
1809 06FB A5 33                 lda   parms+6
1810 06FD 86 33                 stx   parms+6
1811 06FF 85 0D                 sta   size+2
1812 0701 A6 0B                 ldx   size
1813 0703 A5 31                 lda   parms+4
1814 0705 86 31                 stx   parms+4
1815 0707 85 0B                 sta   size
1816 0709 38                    sec   
1817 070A E5 31                 sbc   parms+4                  ;Compare new size to old
1818 070C AA                    tax                            ;Save result
1819 070D A5 0D                 lda   size+2
1820 070F E5 33                 sbc   parms+6
1821 0711 D0 03                 bne   IsDiff                   ;Is there a size change?
1822 0713 8A                    txa                            ;Was low word 0 too?
1823 0714 F0 25                 beq   Done1
1824 0716 B0 38        IsDiff   bcs   Grow                     ;Br if new > old
1825 0718
1826 0718              ; Here we shrink the block
1827 0718
1828 0718 A5 0B                 lda   size                     ;Shrink to nothing?
1829 071A 05 0D                 ora   size+2
1830 071C D0 10                 bne   Not0                     ;Br if not
1831 071E A5 07                 lda   attr                     ;Can't shrink to 0 if locked
1832 0720 89 03 C0              bit   #Attr_Locked+Attr_Fixed+Attr_Addr+Attr_Bank
1833 0723 D0 1E                 bne   BadChange                ;Br if can't nil it
1834 0725
1835 0725 20 4F 14              jsr   CheckRecent              ;Clear Last Allocated (if necessary).
1836 0728
1837 0728 20 DC 0D              jsr   RemoveHandle             ;Remove the handle from the used list
1838 072B 20 02 0F              jsr   InsertPurge
1839 072E A0 08 00 A5  Not0     seth_l size,hndl,Hndl_Size     ;Update the size
1840 073B 4C 0A 08     Done1    jmp   Done
1841 073E
1842 073E A9 02 02     IsPurged lda   #NilErr
1843 0741 80 08                 bra   Fail1
1844 0743 A9 04 02     BadChange lda   #LockErr
1845 0746 80 03                 bra   Fail1
1846 0748 A9 01 02     Fail     lda   #MFullErr
1847 074B 85 01        Fail1    sta   error
1848 074D 4C 0A 08              jmp   Done
1849 0750
1850 0750              ; Here we grow the block
1851 0750
1852 0750                       ENTRY Grow
1853 0750              Grow                                    ; 
1854 0750 A5 03                 lda   addr                     ;Move present address into addr1
1855 0752 85 1B                 sta   addr1
1856 0754 85 2D                 sta   parms                    ;and into parms in case we need it
1857 0756 A5 05                 lda   addr+2                   ;later
1858 0758 85 1D                 sta   addr1+2
1859 075A 85 2F                 sta   parms+2
1860 075C 05 03                 ora   addr                     ;Was it nil?
1861 075E F0 4A                 beq   WasNil                   ;Br if it was
1862 0760
1863 0760              ; First see if we can just extend it from where it is
1864 0760
1865 0760 A0 00 00 B7           geth_l hndl2,addr2,hndl_addr   ;Get beginning of next block
1866 076D
1867 076D              * Temporarily force Fixed so to force Bottom up check so block won't move
1868 076D A5 07                 lda   attr
1869 076F 48                    pha   
1870 0770 09 00 40              ora   #Attr_Fixed
1871 0773 85 07                 sta   attr
1872 0775 22 94 16 E1           jsl   CheckFit                 ;See if it fits
1873 0779 68                    pla   
1874 077A 85 07                 sta   attr                     ;Restore actual block type
1875 077C 90 26                 bcc   NoFit                    ;Br if it didn't
1876 077E A0 08 00 A5           seth_l size,hndl,Hndl_Size     ;And the size
1877 078B A0 00 00 A5           seth_l addr1,hndl,Hndl_Addr    ;Update the address
1878 0798 C5 05                 cmp   addr+2                   ;Has the handle moved?
1879 079A D0 52                 bne   ItMoved                  ;Br if it did
1880 079C A5 1B                 lda   addr1                    ;Check low word
1881 079E C5 03                 cmp   addr
1882 07A0 F0 99                 beq   Done1                    ;Do nothing if it didn't move
1883 07A2 80 4A                 bra   ItMoved
1884 07A4
1885 07A4              ; We have to search for a new block
1886 07A4 24 07        NoFit    bit   attr                     ;Can't move it if Locked
1887 07A6 30 9B                 bmi   BadChange                ;Br if Locked
1888 07A8 70 99                 bvs   BadChange                ;Br if Fixed
1889 07AA                       ENTRY WasNil
1890 07AA              WasNil                                  ; 
1891 07AA A0 04 00              ldy   #Hndl_Attr               ;Make unpurgable
1892 07AD A5 07                 lda   attr
1893 07AF 29 FF FC              and   #$FCFF                   ;Purge level 0
1894 07B2 97 17                 sta   [hndl],y
1895 07B4 22 90 16 E1           jsl   Search                   ;Go try to find one
1896 07B8              ; added 21 Dec 88
1897 07B8 A7 17                 lda   [hndl]                   ; deref handle again
1898 07BA 85 2D                 sta   parms                    ; (it might have moved)
1899 07BC A0 02 00              ldy   #2
1900 07BF B7 17                 lda   [hndl],y
1901 07C1 85 2F                 sta   parms+2
1902 07C3              ; end addition
1903 07C3 A0 04 00              ldy   #Hndl_Attr               ;Restore purge status
1904 07C6 A5 07                 lda   attr                     ;Don't change C
1905 07C8 97 17                 sta   [hndl],y
1906 07CA B0 03                 bcs   @Continue
1907 07CC 82 79 FF              brl   Fail                     ;Couldn't find one. C from Search
1908 07CF              @Continue  
1909 07CF A5 11 48 A5           push_l hndl1                   ;Save previous
1910 07D5 20 DC 0D              jsr   RemoveHandle             ;Remove handle from where it is
1911 07D8 68 85 0F 68           pop_l hndl1                    ;Recover where we want it to go
1912 07DE A0 10 00 B7           geth_l hndl1,hndl2,Hndl_Next   ;Get where it goes before
1913 07EB 20 84 0D              jsr   InsertHandle             ;Put it in the list
1914 07EE
1915 07EE              ; Move data that used to be in handle into new place
1916 07EE A5 1B 85 07  ItMoved  move_l addr1,Dest              ;Where data goes
1917 07F6 A5 2D 85 03           move_l parms,Source            ;Where it used to be
1918 07FE A5 31 85 0B           move_l parms+4,Count           ;Old size
1919 0806 22 A4 16 E1           jsl   MoveData                 ;Go Move it
1920 080A
1921 080A 5C 8C 16 E1  Done     jml   Cleanup
1922 080E
1923 080E                       ENDP 
1924 080E
1925 080E
1926 080E
1927 080E              ********************************************************************************
1928 080E              *
1929 080E              * FindHandle - Finds the handle of the block containing an address
1930 080E              *
1931 080E              * inputs:      Parms = address
1932 080E              *
1933 080E              * output:      handle of segment or nil if address is free
1934 080E              *
1935 080E              ********************************************************************************
1936 080E              FindHandle PROC 
1937 080E                       longa on
1938 080E                       longi on
1939 080E
1940 080E 22 88 16 E1           jsl   link
1941 0812 64 31                 stz   parms+4                  ;Nil the output
1942 0814 64 33                 stz   parms+6
1943 0816 20 23 0C              jsr   start0                   ;Start at beginning of memory
1944 0819 20 0A 0F     Loop     jsr   GetNext                  ;Go to next segment
1945 081C F0 16                 beq   AddrFound                ;Br if end of memory
1946 081E A5 2D C5 1B           cmp_l parms,addr1              ;If < addr1 then in hndl1
1947 0826 90 0C                 bcc   AddrFound                ;Br if found
1948 0828 A5 2D C5 1F           cmp_l parms,addr2              ;If < addr2 then in free space
1949 0830 90 0A                 bcc   AddrFree
1950 0832 80 E5                 bra   Loop
1951 0834 A5 0F 85 31  AddrFound move_l hndl1,parms+4          ;Move handle to func return
1952 083C 5C 8C 16 E1  AddrFree jml   CleanUp
1953 0840
1954 0840                       ENDP 
1955 0840
1956 0840
1957 0840
1958 0840              ********************************************************************************
1959 0840              *
1960 0840              * FreeMem - Calculates how much free memory is in the machine
1961 0840              *
1962 0840              * Inputs:   None
1963 0840              *
1964 0840              * Output:   Free memory
1965 0840              *
1966 0840              ********************************************************************************
1967 0840              FreeMem  PROC 
1968 0840                       longa on
1969 0840                       longi on
1970 0840
1971 0840 22 88 16 E1           jsl   Link
1972 0844 64 2D                 stz   parms                    ;Clear count to 0
1973 0846 64 2F                 stz   parms+2
1974 0848 20 23 0C              jsr   start0                   ;Set up a search starting from 0
1975 084B
1976 084B 20 0A 0F     CountLoop jsr   GetNext                 ;addr1, addr2 limits of free block
1977 084E F0 18                 beq   Done
1978 0850 38                    sec                            ;addr2 - addr1 = size of block
1979 0851 A5 1F                 lda   addr2
1980 0853 E5 1B                 sbc   addr1
1981 0855 AA                    tax   
1982 0856 A5 21                 lda   addr2+2
1983 0858 E5 1D                 sbc   addr1+2
1984 085A A8                    tay   
1985 085B 18                    clc                            ;Now add it to total
1986 085C 8A                    txa   
1987 085D 65 2D                 adc   parms
1988 085F 85 2D                 sta   parms
1989 0861 98                    tya   
1990 0862 65 2F                 adc   parms+2
1991 0864 85 2F                 sta   parms+2
1992 0866 80 E3                 bra   CountLoop                ;Go do the next block
1993 0868
1994 0868 5C 8C 16 E1  Done     jml   CleanUp
1995 086C
1996 086C                       ENDP 
1997 086C
1998 086C
1999 086C
2000 086C
2001 086C              ;
2002 086C              ;          Copyright Apple Computer, Inc. 1987
2003 086C              ;          All rights reserved
2004 086C              ;          Patch by Dan Oliver
2005 086C              ;
2006 086C              ; RAM patch code to Memory Manager.
2007 086C              ;
2008 086C              ;
2009 086C              ;
2010 086C              ;========================================================
2011 086C              ;          Return amount of allocatable memory.
2012 086C              ;========================================================
2013 086C              ;
2014 086C              ;   IN:    No inputs.
2015 086C              ;
2016 086C              ;  OUT:    LONG - amount of RAM in system that is not allocated.
2017 086C              ;                 The amount includes unallocated and purgable.
2018 086C              ;
2019 086C
2020 086C              ;
2021 086C              ; Change History
2022 086C              ;
2023 086C              ; 17 May 88         Steven Glass
2024 086C              ;
2025 086C              ; Cleared carry and zeroed a-reg on exit.
2026 086C              ;
2027 086C              ;
2028 086C
2029 086C              RealFreeMem PROC EXPORT
2030 086C                       longa on
2031 086C                       longi on
2032 086C
2033 086C              ;
2034 086C              ;
2035 086C              ; --- Offsets into stack and direct page ---------------------------
2036 086C              ;
2037 086C              handle   equ   1
2038 086C              saveDirect equ   handle+4
2039 086C              rtl1     equ   saveDirect+2
2040 086C              rtl2     equ   rtl1+3
2041 086C              totalFree equ   rtl2+3
2042 086C              ;
2043 086C              ;
2044 086C 0B                    phd                            ;Save original direct page.
2045 086D 48                    pha                            ;Space for handle.
2046 086E 48                    pha   
2047 086F 3B                    tsc                            ;Switch direct page into stack.
2048 0870 5B                    tcd   
2049 0871              ;
2050 0871 64 0D                 stz   <totalFree               ;Start total free memory counter.
2051 0873 64 0F                 stz   <totalFree+2
2052 0875              ;
2053 0875              ;
2054 0875              ; --- Compute size of allocated memory ------------------------------------
2055 0875              ;
2056 0875 AF 00 16 E1           lda   >MemList
2057 0879 AA                    tax   
2058 087A AF 02 16 E1           lda   >MemList+2
2059 087E 86 01        lop1     stx   <handle
2060 0880 85 03                 sta   <handle+2
2061 0882              ;
2062 0882 A0 04 00              ldy   #hndl_attr               ;Don't count purgable blocks.
2063 0885 B7 01                 lda   [<handle],y
2064 0887 29 00 03              and   #attr_purge
2065 088A F0 04                 beq   CountThis                ;Not purgeable so count this
2066 088C B7 01                 lda   [<handle],y              ;Is purgable but may be locked so
2067 088E 10 12                 bpl   next1                    ;cannot be freed,  If can be freed, then
2068 0890              ;                                       ;skip.
2069 0890              ;
2070 0890              CountThis                               ;
2071 0890 A0 08 00              ldy   #hndl_size               ;Add size of this allocated block
2072 0893 B7 01                 lda   [<handle],y              ;to the size accumulator.
2073 0895 18                    clc   
2074 0896 65 0D                 adc   <totalFree
2075 0898 85 0D                 sta   <totalFree
2076 089A C8                    iny   
2077 089B C8                    iny   
2078 089C B7 01                 lda   [<handle],y
2079 089E 65 0F                 adc   <totalFree+2
2080 08A0 85 0F                 sta   <totalFree+2
2081 08A2              ;
2082 08A2 A0 10 00     next1    ldy   #hndl_next
2083 08A5 B7 01                 lda   [<handle],y
2084 08A7 AA                    tax   
2085 08A8 C8                    iny   
2086 08A9 C8                    iny   
2087 08AA B7 01                 lda   [<handle],y
2088 08AC D0 D0                 bne   lop1
2089 08AE              ;
2090 08AE              ;
2091 08AE              ; --- From total allocated memory, subtract total memory ---------------
2092 08AE              ;
2093 08AE A9 00 00              lda   #0
2094 08B1 AA                    tax   
2095 08B2 38                    sec   
2096 08B3 E5 0D                 sbc   <totalFree
2097 08B5 85 0D                 sta   <totalFree
2098 08B7 8A                    txa   
2099 08B8 E5 0F                 sbc   <totalFree+2
2100 08BA 85 0F                 sta   <totalFree+2
2101 08BC              ;
2102 08BC 68                    pla                            ;Remove temp handle.
2103 08BD 68                    pla   
2104 08BE 2B                    pld                            ;Restore direct page.
2105 08BF
2106 08BF A9 00 00              lda   #0                       ; return no error!
2107 08C2 18                    clc   
2108 08C3
2109 08C3 6B                    rtl   
2110 08C4              ;
2111 08C4                       ENDP 
2112 08C4
2113 08C4
2114 08C4              ********************************************************************************
2115 08C4              *
2116 08C4              * MaxBlock - Finds the largest free block in the machine in the machine
2117 08C4              *
2118 08C4              * Inputs:   None
2119 08C4              *
2120 08C4              * Output:   Largest block size in parms
2121 08C4              *
2122 08C4              ********************************************************************************
2123 08C4              MaxBlock PROC 
2124 08C4                       longa on
2125 08C4                       longi on
2126 08C4
2127 08C4 22 88 16 E1           jsl   Link
2128 08C8 64 2D                 stz   parms                    ;Clear size to 0
2129 08CA 64 2F                 stz   parms+2
2130 08CC 20 23 0C              jsr   start0                   ;Set up a search starting from 0
2131 08CF
2132 08CF 20 0A 0F     CountLoop jsr   GetNext                 ;addr1, addr2 limits of free block
2133 08D2 F0 17                 beq   Done
2134 08D4 38                    sec                            ;addr2 - addr1 = size of block
2135 08D5 A5 1F                 lda   addr2
2136 08D7 E5 1B                 sbc   addr1
2137 08D9 AA                    tax   
2138 08DA A5 21                 lda   addr2+2
2139 08DC E5 1D                 sbc   addr1+2
2140 08DE A8                    tay   
2141 08DF E4 2D                 cpx   parms                    ;Now compare it to current largest
2142 08E1 E5 2F                 sbc   parms+2                  ;C = 1 if it is larger
2143 08E3 90 EA                 bcc   CountLoop
2144 08E5 86 2D                 stx   parms                    ;Save new largest
2145 08E7 84 2F                 sty   parms+2
2146 08E9 80 E4                 bra   CountLoop                ;Go check the next block
2147 08EB
2148 08EB 5C 8C 16 E1  Done     jml   CleanUp
2149 08EF
2150 08EF                       ENDP 
2151 08EF
2152 08EF
2153 08EF              ********************************************************************************
2154 08EF              *
2155 08EF              * TotalMem - Returns total memory in machine
2156 08EF              *
2157 08EF              * inputs: none
2158 08EF              *
2159 08EF              * output: Number of bytes in machine including $E0 and $E1
2160 08EF              *
2161 08EF              ********************************************************************************
2162 08EF              TotalMem PROC 
2163 08EF                       longa on
2164 08EF                       longi on
2165 08EF
2166 08EF 22 88 16 E1           jsl   Link
2167 08F3 64 2D                 stz   parms                    ;Low word always 0
2168 08F5 AD 24 16              lda   |NumBanks
2169 08F8 1A                    inc   A                        ;Add 2 for E0, E1
2170 08F9 1A                    inc   A
2171 08FA 85 2F                 sta   parms+2
2172 08FC 5C 8C 16 E1           jml   Cleanup
2173 0900
2174 0900                       ENDP 
2175 0900
2176 0900
2177 0900
2178 0900              ********************************************************************************
2179 0900              *
2180 0900              * CheckHandle - Used to verify that a handle is valid
2181 0900              *
2182 0900              * inputs:      ParmHndl = handle to verify
2183 0900              *
2184 0900              * outputs:     none
2185 0900              *
2186 0900              ********************************************************************************
2187 0900              CheckHandle PROC 
2188 0900                       longa on
2189 0900                       longi on
2190 0900
2191 0900 22 88 16 E1           jsl   Link
2192 0904 20 50 10              jsr   VerifyHandle             ;Sets error if invalid
2193 0907 5C 8C 16 E1           jml   CleanUp
2194 090B
2195 090B                       ENDP 
2196 090B
2197 090B
2198 090B
2199 090B              ********************************************************************************
2200 090B              *
2201 090B              * CompactMem - Forces memory compaction if possible
2202 090B              *
2203 090B              * inputs:      none
2204 090B              *
2205 090B              * If called from an interrupt, no compaction is done
2206 090B              *
2207 090B              * outputs:     none
2208 090B              *
2209 090B              ********************************************************************************
2210 090B              CompactMem PROC 
2211 090B                       longa on
2212 090B                       longi on
2213 090B
2214 090B 22 88 16 E1           jsl   Link
2215 090F AD CB 00              lda   |IrqActive               ;Are we in an interrupt?
2216 0912 29 FF 00              and   #$00FF
2217 0915 D0 06                 bne   NoCompact                ;Don't compact if we are
2218 0917 64 07                 stz   Attr                     ;0 so all mem compacts. Rev 2
2219 0919 22 AC 16 E1           jsl   Compact
2220 091D 5C 8C 16 E1  NoCompact jml   CleanUp
2221 0921
2222 0921                       ENDP 
2223 0921
2224 0921
2225 0921                       Title ' HLock and more'
2226 0921              ********************************************************************************
2227 0921              *
2228 0921              * HLock - Locks a handle
2229 0921              *
2230 0921              * inputs:      ParmHndl = Handle to lock
2231 0921              *
2232 0921              ********************************************************************************
2233 0921              HLock    PROC 
2234 0921                       longa on
2235 0921                       longi on
2236 0921
2237 0921 22 88 16 E1           jsl   Link
2238 0925 20 50 10              jsr   VerifyHandle
2239 0928 A0 04 00              ldy   #hndl_attr               ;Get attributes byte for handle
2240 092B B7 17                 lda   [Hndl],y
2241 092D 09 00 80              ora   #attr_locked             ;Lock it
2242 0930 97 17                 sta   [Hndl],y
2243 0932 5C 8C 16 E1           jml   Cleanup
2244 0936
2245 0936                       ENDP 
2246 0936
2247 0936
2248 0936
2249 0936              ********************************************************************************
2250 0936              *
2251 0936              * HLockAll - Locks all  handles of an owner
2252 0936              *
2253 0936              * inputs:      Parms = Owner
2254 0936              *
2255 0936              ********************************************************************************
2256 0936              HLockAll PROC 
2257 0936                       longa on
2258 0936                       longi on
2259 0936
2260 0936 22 88 16 E1           jsl   Link
2261 093A 20 56 09              jsr   MakeIDMask               ;Set up the mask for searching
2262 093D B0 13                 bcs   Done                     ;Br if bad owner
2263 093F 20 62 0D     Loop     jsr   SearchID                 ;Find a matching handle
2264 0942 90 0E                 bcc   Done                     ;Br if no more
2265 0944 48                    pha                            ;Save address of next one
2266 0945 A0 04 00              ldy   #hndl_attr               ;Get attributes byte for handle
2267 0948 B7 17                 lda   [hndl],y
2268 094A 09 00 80              ora   #attr_locked             ;Lock it
2269 094D 97 17                 sta   [hndl],y
2270 094F 68                    pla   
2271 0950 80 ED                 bra   Loop                     ;Go to next one
2272 0952
2273 0952 5C 8C 16 E1  Done     jml   Cleanup
2274 0956
2275 0956                       ENDP 
2276 0956
2277 0956
2278 0956              ********************************************************************************
2279 0956              *
2280 0956              * MakeIDMask - Sets things up for xxxAll commands
2281 0956              *              Parms -> owner
2282 0956              *              Mask  -> parms
2283 0956              *              A,X = MemList
2284 0956              *              C = 1 if invalid ID
2285 0956              *
2286 0956              *
2287 0956              *
2288 0956              ********************************************************************************
2289 0956              MakeIDMask PROC 
2290 0956                       longa on
2291 0956                       longi on
2292 0956
2293 0956 A5 2D                 lda   parms
2294 0958 89 00 F0              bit   #$F000                   ;Invalid mask
2295 095B F0 20                 beq   BadID
2296 095D 85 09                 sta   owner                    ;Get inputted owner
2297 095F 09 00 F0              ora   #$F000                   ;Build the mask
2298 0962
2299 0962              JoinHere  
2300 0962 89 00 0F              bit   #$0F00                   ;All aux IDs?
2301 0965 F0 03                 beq   AnyAux                   ;Br if any
2302 0967 09 00 0F              ora   #$0F00
2303 096A 89 FF 00     AnyAux   bit   #$00FF                   ;Any ID?
2304 096D F0 03                 beq   AnyID
2305 096F 09 FF 00              ora   #$00FF
2306 0972 85 2D        AnyID    sta   parms
2307 0974 AD 02 16              lda   |MemList+2               ;Get start of used segments
2308 0977 AA                    tax   
2309 0978 AD 00 16              lda   |MemList
2310 097B 18                    clc   
2311 097C 60                    rts   
2312 097D
2313 097D A9 07 02     BadID    lda   #IDErr                   ;Set error
2314 0980 85 01                 sta   Error
2315 0982 38                    sec   
2316 0983 60                    rts   
2317 0984
2318 0984
2319 0984              ;-----------------------------------------------------------
2320 0984              ;
2321 0984              ; Alternate entry point that does not check for a non-zero
2322 0984              ; major ID.  This is used by Purgeall so can purge all
2323 0984              ; handles at once.
2324 0984              ;
2325 0984                       ENTRY MakeIDMask2
2326 0984 A5 2D        MakeIDMask2 lda   parms
2327 0986 85 09                 sta   owner
2328 0988 80 D8                 bra   JoinHere
2329 098A
2330 098A
2331 098A                       ENDP 
2332 098A
2333 098A
2334 098A              ********************************************************************************
2335 098A              *
2336 098A              * HUnlock - Unlocks a handle
2337 098A              *
2338 098A              * inputs:      ParmHndl = Handle to unlock
2339 098A              *
2340 098A              ********************************************************************************
2341 098A              HUnlock  PROC 
2342 098A                       longa on
2343 098A                       longi on
2344 098A
2345 098A 22 88 16 E1           jsl   Link
2346 098E 20 50 10              jsr   VerifyHandle             ;Valid handle?
2347 0991 A0 04 00              ldy   #hndl_attr               ;Get attributes byte for handle
2348 0994 B7 17                 lda   [Hndl],y
2349 0996 29 FF 7F              and   #$7FFF                   ;attr_locked.EOR.$FFFF ;Unlock it
2350 0999 97 17                 sta   [Hndl],y
2351 099B 5C 8C 16 E1           jml   Cleanup
2352 099F
2353 099F                       ENDP 
2354 099F
2355 099F
2356 099F              ********************************************************************************
2357 099F              *
2358 099F              * HUnlockAll - Unlocks all  handles of an owner
2359 099F              *
2360 099F              * inputs:      Parms = Owner
2361 099F              *
2362 099F              ********************************************************************************
2363 099F              HUnlockAll PROC 
2364 099F                       longa on
2365 099F                       longi on
2366 099F
2367 099F 22 88 16 E1           jsl   Link
2368 09A3 20 56 09              jsr   MakeIDMask               ;Set up the mask for searching
2369 09A6 B0 13                 bcs   Done                     ;Br if bad id
2370 09A8 20 62 0D     Loop     jsr   SearchID                 ;Find a matching handle
2371 09AB 90 0E                 bcc   Done                     ;Br if no more
2372 09AD 48                    pha                            ;Save address of next one
2373 09AE A0 04 00              ldy   #hndl_attr               ;Get attributes byte for handle
2374 09B1 B7 17                 lda   [hndl],y
2375 09B3 29 FF 7F              and   #$7FFF                   ;Unlock it
2376 09B6 97 17                 sta   [hndl],y
2377 09B8 68                    pla   
2378 09B9 80 ED                 bra   Loop                     ;Go to next one
2379 09BB
2380 09BB 5C 8C 16 E1  Done     jml   Cleanup
2381 09BF
2382 09BF                       ENDP 
2383 09BF
2384 09BF
2385 09BF
2386 09BF              ********************************************************************************
2387 09BF              *
2388 09BF              * SetPurge - Sets the purge level of a block
2389 09BF              *
2390 09BF              * inputs:      ParmHndl = Handle to lock
2391 09BF              *              Parms+4  = New purge Level
2392 09BF              *
2393 09BF              ********************************************************************************
2394 09BF              SetPurge PROC 
2395 09BF                       longa on
2396 09BF                       longi on
2397 09BF
2398 09BF 22 88 16 E1           jsl   Link
2399 09C3 20 50 10              jsr   VerifyHandle
2400 09C6 A5 31                 lda   parms+4                  ;Get new purge level
2401 09C8 29 03 00              and   #3                       ;Only want 2 bits
2402 09CB EB                    xba                            ;Move em to where they go
2403 09CC 85 31                 sta   parms+4
2404 09CE A0 04 00              ldy   #hndl_attr               ;Get attributes byte for handle
2405 09D1 B7 17                 lda   [Hndl],y
2406 09D3 29 FF FC              and   #$FCFF                   ;Mask out purge bits
2407 09D6 05 31                 ora   parms+4                  ;Or in new level
2408 09D8 97 17                 sta   [Hndl],y
2409 09DA 5C 8C 16 E1           jml   Cleanup
2410 09DE
2411 09DE                       ENDP 
2412 09DE
2413 09DE
2414 09DE
2415 09DE              ********************************************************************************
2416 09DE              *
2417 09DE              * SetPurgeAll - Sets the purge level of all of an owners blocks
2418 09DE              *
2419 09DE              * inputs:      Parms = Owner
2420 09DE              *              Parms+2 = New purge level
2421 09DE              *
2422 09DE              ********************************************************************************
2423 09DE              SetPurgeAll PROC 
2424 09DE                       longa on
2425 09DE                       longi on
2426 09DE
2427 09DE 22 88 16 E1           jsl   Link
2428 09E2 A5 2F                 lda   parms+2                  ;Get new purge level
2429 09E4 29 03 00              and   #3                       ;Only want 2 bits
2430 09E7 EB                    xba                            ;Move em to where they go
2431 09E8 85 2F                 sta   parms+2
2432 09EA 20 56 09              jsr   MakeIDMask               ;Set up the mask for searching
2433 09ED B0 15                 bcs   Done                     ;Br if bad owner
2434 09EF 20 62 0D     Loop     jsr   SearchID                 ;Find a matching handle
2435 09F2 90 10                 bcc   Done                     ;Br if no more
2436 09F4 48                    pha                            ;Save address of next one
2437 09F5 A0 04 00              ldy   #hndl_attr               ;Get attributes byte for handle
2438 09F8 B7 17                 lda   [hndl],y
2439 09FA 29 FF FC              and   #$FCFF                   ;Mask off purge bits
2440 09FD 05 2F                 ora   parms+2                  ;Put in new ones
2441 09FF 97 17                 sta   [hndl],y
2442 0A01 68                    pla   
2443 0A02 80 EB                 bra   Loop                     ;Go to next one
2444 0A04
2445 0A04 5C 8C 16 E1  Done     jml   Cleanup
2446 0A08
2447 0A08                       ENDP 
2448 0A08
2449 0A08
2450 0A08              ********************************************************************************
2451 0A08              *
2452 0A08              * PtrToHand - Moves a block of data from an address to a handle
2453 0A08              *
2454 0A08              * Inputs:      parms = Number of bytes to move
2455 0A08              *              parms+4 = Destination handle
2456 0A08              *              parms+8 = Source address
2457 0A08              *
2458 0A08              ********************************************************************************
2459 0A08              PtrToHand PROC 
2460 0A08                       longa on
2461 0A08                       longi on
2462 0A08
2463 0A08 22 88 16 E1           jsl   link
2464 0A0C A5 31                 lda   parms+4                  ;Check the handle
2465 0A0E 85 17                 sta   hndl
2466 0A10 A5 33                 lda   parms+6
2467 0A12 85 19                 sta   hndl+2
2468 0A14 20 58 10              jsr   VerifyH2
2469 0A17
2470 0A17 A5 2D 85 0B           move_l Parms,Count             ;Get the parameters
2471 0A1F A7 31                 lda   [parms+4]                ;Get dest address
2472 0A21 85 07                 sta   Dest
2473 0A23 A0 02 00              ldy   #hndl_addr+2
2474 0A26 B7 31                 lda   [parms+4],y
2475 0A28 85 09                 sta   Dest+2
2476 0A2A 05 07                 ora   Dest                     ;If Nil then error
2477 0A2C F0 10                 beq   IsNil
2478 0A2E
2479 0A2E A5 35 85 03           move_l Parms+8,Source
2480 0A36 22 A4 16 E1           jsl   MoveData                 ;Go do it
2481 0A3A 5C 8C 16 E1  Done     jml   CleanUp
2482 0A3E
2483 0A3E A9 02 02     IsNil    lda   #NilErr                  ;Can't copy to nil handle
2484 0A41 85 01                 sta   error
2485 0A43 80 F5                 bra   Done
2486 0A45                       ENDP 
2487 0A45
2488 0A45
2489 0A45
2490 0A45              ********************************************************************************
2491 0A45              *
2492 0A45              * HandToPtr - Moves a block of data from a handle to an address
2493 0A45              *
2494 0A45              * Inputs:      parms = Number of bytes to move
2495 0A45              *              parms+4 = Destination address
2496 0A45              *              parms+8 = Source handle
2497 0A45              *
2498 0A45              ********************************************************************************
2499 0A45              HandToPtr PROC 
2500 0A45                       longa on
2501 0A45                       longi on
2502 0A45
2503 0A45 22 88 16 E1           jsl   link
2504 0A49 A5 35                 lda   parms+8                  ;Check the handle
2505 0A4B 85 17                 sta   hndl
2506 0A4D A5 37                 lda   parms+10
2507 0A4F 85 19                 sta   hndl+2
2508 0A51 20 58 10              jsr   VerifyH2
2509 0A54
2510 0A54 A5 2D 85 0B           move_l Parms,Count             ;Get the parameters
2511 0A5C A5 31 85 07           move_l Parms+4,Dest
2512 0A64
2513 0A64 A7 35                 lda   [parms+8]                ;Get source address
2514 0A66 85 03                 sta   Source
2515 0A68 A0 02 00              ldy   #hndl_addr+2
2516 0A6B B7 35                 lda   [parms+8],y
2517 0A6D 85 05                 sta   Source+2
2518 0A6F 05 03                 ora   Source                   ;If Nil then error
2519 0A71 F0 08                 beq   IsNil
2520 0A73
2521 0A73 22 A4 16 E1           jsl   MoveData                 ;Go do it
2522 0A77 5C 8C 16 E1  Done     jml   CleanUp
2523 0A7B
2524 0A7B A9 02 02     IsNil    lda   #NilErr                  ;Can't copy to nil handle
2525 0A7E 85 01                 sta   error
2526 0A80 80 F5                 bra   Done
2527 0A82                       ENDP 
2528 0A82
2529 0A82
2530 0A82
2531 0A82
2532 0A82              ********************************************************************************
2533 0A82              *
2534 0A82              * HandToHand - Moves a block of data from a handle to a handle
2535 0A82              *
2536 0A82              * Inputs:      parms = Number of bytes to move
2537 0A82              *              parms+4 = Destination handle
2538 0A82              *              parms+8 = Source handle
2539 0A82              *
2540 0A82              ********************************************************************************
2541 0A82              HandToHand PROC 
2542 0A82                       longa on
2543 0A82                       longi on
2544 0A82
2545 0A82 22 88 16 E1           jsl   link
2546 0A86
2547 0A86 A5 31                 lda   parms+4                  ;Check the destination handle
2548 0A88 85 17                 sta   hndl
2549 0A8A A5 33                 lda   parms+6
2550 0A8C 85 19                 sta   hndl+2
2551 0A8E 20 58 10              jsr   VerifyH2
2552 0A91
2553 0A91 A5 35                 lda   parms+8                  ;Check the source handle
2554 0A93 85 17                 sta   hndl
2555 0A95 A5 37                 lda   parms+10
2556 0A97 85 19                 sta   hndl+2
2557 0A99 20 58 10              jsr   VerifyH2
2558 0A9C
2559 0A9C
2560 0A9C A5 2D 85 0B           move_l Parms,Count             ;Get the parameters
2561 0AA4 A7 31                 lda   [parms+4]                ;Get dest address
2562 0AA6 85 07                 sta   Dest
2563 0AA8 A0 02 00              ldy   #hndl_addr+2
2564 0AAB B7 31                 lda   [parms+4],y
2565 0AAD 85 09                 sta   Dest+2
2566 0AAF 05 07                 ora   Dest                     ;If Nil then error
2567 0AB1 F0 14                 beq   IsNil
2568 0AB3
2569 0AB3 A7 35                 lda   [parms+8]                ;Get source address
2570 0AB5 85 03                 sta   Source
2571 0AB7 B7 35                 lda   [parms+8],y              ;Y = 2 from earlier
2572 0AB9 85 05                 sta   Source+2
2573 0ABB 05 03                 ora   Source                   ;If Nil then error
2574 0ABD F0 08                 beq   IsNil
2575 0ABF
2576 0ABF 22 A4 16 E1           jsl   MoveData                 ;Go do it
2577 0AC3 5C 8C 16 E1  Done     jml   CleanUp
2578 0AC7
2579 0AC7 A9 02 02     IsNil    lda   #NilErr                  ;Can't copy to nil handle
2580 0ACA 85 01                 sta   error
2581 0ACC 80 F5                 bra   Done
2582 0ACE
2583 0ACE                       ENDP 
2584 0ACE
2585 0ACE
2586 0ACE
2587 0ACE
2588 0ACE              ********************************************************************************
2589 0ACE              *
2590 0ACE              * BlockMove - Moves a block of data
2591 0ACE              *
2592 0ACE              * Inputs:      parms = Number of bytes to move
2593 0ACE              *              parms+4 = Destination address
2594 0ACE              *              parms+8 = Source address
2595 0ACE              *
2596 0ACE              ********************************************************************************
2597 0ACE              BlockMove PROC 
2598 0ACE                       longa on
2599 0ACE                       longi on
2600 0ACE
2601 0ACE 22 88 16 E1           jsl   link
2602 0AD2 A5 2D 85 0B           move_l Parms,Count             ;Get the parameters
2603 0ADA A5 31 85 07           move_l Parms+4,Dest
2604 0AE2 A5 35 85 03           move_l Parms+8,Source
2605 0AEA 22 A4 16 E1           jsl   MoveData                 ;Go do it
2606 0AEE 5C 8C 16 E1           jml   CleanUp
2607 0AF2
2608 0AF2                       ENDP 
2609 0AF2
2610 0AF2
2611 0AF2                       title ' Allocation routines'
2612 0AF2              ********************************************************************************
2613 0AF2              *
2614 0AF2              * Search - Searches for a segment that fits the current parameters
2615 0AF2              *          note: segment is found but handle is not inserted
2616 0AF2              *          SearchUp & SearchDown are used for low to high and high to low
2617 0AF2              *          allocation
2618 0AF2              *
2619 0AF2              * inputs:      segment attributes
2620 0AF2              *
2621 0AF2              * outputs:     C=1 if segment found C=0 if no fit
2622 0AF2              *
2623 0AF2              * calls to search go through $E1
2624 0AF2              *
2625 0AF2              * Change History
2626 0AF2              *
2627 0AF2              * 30 Aug 88         Steven Glass
2628 0AF2              *
2629 0AF2              * Now trys calls SearchUpFast and SearchDownFast.  These routines
2630 0AF2              * can find a space for a handle faster than the SearchDown and SearchUp
2631 0AF2              * (but can lead to more fragmentation).
2632 0AF2              *
2633 0AF2              ********************************************************************************
2634 0AF2              XSearch  PROC 
2635 0AF2                       longa on
2636 0AF2                       longi on
2637 0AF2
2638 0AF2 EE 30 16              inc   |NewHandleCount
2639 0AF5 D0 03                 bne   @NoCarry
2640 0AF7 EE 32 16              inc   |NewHandleCount+2
2641 0AFA              @NoCarry  
2642 0AFA
2643 0AFA
2644 0AFA
2645 0AFA A5 07                 lda   attr                     ;Check the attributes
2646 0AFC 89 02 00              bit   #attr_addr               ;User's address?
2647 0AFF F0 05                 beq   NotAddr                  ;Br if not
2648 0B01 09 01 40              ora   #attr_fixed+attr_bank    ;Force these
2649 0B04 85 07                 sta   attr
2650 0B06
2651 0B06 89 00 40     NotAddr  bit   #attr_fixed              ;Movable block?
2652 0B09 D0 03                 bne   @KeepLooking
2653 0B0B 4C E6 0B              jmp   SearchDownFast           ;If not fixed, do top down
2654 0B0E 89 00 10     @KeepLooking bit   #attr_handle         ;Allocating a handle
2655 0B11 F0 14                 beq   SearchUp                 ;If so fall into searchhandle
2656 0B13
2657 0B13                       ENDP 
2658 0B13
2659 0B13              ********************************************************************************
2660 0B13              *
2661 0B13              * SearchHandle This is used to search from low to high memory for a handle
2662 0B13              *              The search order is:
2663 0B13              *                  Bank $E0 to $FF (slow memory)
2664 0B13              *                  Bank $01 to $DF (in SearchUp)
2665 0B13              *
2666 0B13              * outputs:     C=1 if segment found C=0 if no fit
2667 0B13              *
2668 0B13              ********************************************************************************
2669 0B13              SearchHandle PROC EXPORT
2670 0B13                       longa on
2671 0B13                       longi on
2672 0B13
2673 0B13 A2 14 00              ldx   #MemE0-Memlist
2674 0B16 20 26 0C              jsr   StartX                   ;X says where to start from
2675 0B19
2676 0B19 20 5B 0F     LoopE0   jsr   GetNextFree              ;Go to next free segment
2677 0B1C F0 07                 beq   Failed                   ;Br if nil
2678 0B1E 22 94 16 E1           jsl   CheckFit                 ;Will it fit?
2679 0B22 90 F5                 bcc   LoopE0
2680 0B24 6B                    rtl   
2681 0B25
2682 0B25 A5 07        Failed   lda   attr                     ;Fall into SearchUp
2683 0B27
2684 0B27                       ENDP 
2685 0B27
2686 0B27
2687 0B27              ********************************************************************************
2688 0B27              *
2689 0B27              * SearchUp     This is used to search from low to high memory
2690 0B27              *              The search order is:
2691 0B27              *                  Bank $01 to $E0
2692 0B27              *                  Bank $E0 to $FF (slow memory)
2693 0B27              *                  Bank 0
2694 0B27              *
2695 0B27              * inputs:      attributes in A & attr
2696 0B27              *
2697 0B27              * outputs:     C=1 if segment found C=0 if no fit
2698 0B27              *
2699 0B27              * Change History
2700 0B27              *
2701 0B27              * 30 Aug 88         Steven Glass
2702 0B27              *
2703 0B27              * When a handle is found, we remember it in LastLowhHandle.
2704 0B27              *
2705 0B27              ********************************************************************************
2706 0B27              SearchUp PROC EXPORT
2707 0B27                       longa on
2708 0B27                       longi on
2709 0B27
2710 0B27 A2 0C 00              ldx   #Mem01-Memlist           ;Assume starting from bank1
2711 0B2A 89 01 00              bit   #attr_bank               ;Fixed bank?
2712 0B2D F0 0C                 beq   BankOk                   ;Br if not
2713 0B2F A5 05                 lda   addr+2                   ;Which bank?
2714 0B31 F0 2D                 beq   Search0                  ;Br if bank 0
2715 0B33 C9 E0 00              cmp   #$E0                     ;Bank E0 or E1?
2716 0B36 90 03                 bcc   BankOk                   ;Br if 1 to DF
2717 0B38 A2 14 00              ldx   #MemE0-Memlist
2718 0B3B
2719 0B3B              *
2720 0B3B              * Search $01 to $FF or $E0 to $FF if fixed in $E0 or $E1
2721 0B3B              *
2722 0B3B 20 26 0C     BankOk   jsr   StartX                   ;X says where to start from
2723 0B3E
2724 0B3E 20 5B 0F     Loop01   jsr   GetNextFree              ;Go to next free segment
2725 0B41 F0 1D                 beq   Search0                  ;Br if nil
2726 0B43 22 94 16 E1           jsl   CheckFit                 ;Will it fit?
2727 0B47 90 F5                 bcc   Loop01
2728 0B49
2729 0B49 A5 07                 lda   attr                     ;don't remember this one if its fixed bank or fixed addr
2730 0B4B 89 01 00              bit   #attr_bank
2731 0B4E D0 0F                 bne   ForgetThisOne
2732 0B50
2733 0B50 89 02 00              bit   #Attr_Addr
2734 0B53 D0 0A                 bne   ForgetThisOne
2735 0B55
2736 0B55 A5 17                 lda   hndl                     ; put handle into place
2737 0B57 8D 28 16              sta   |LastLowHandle
2738 0B5A A5 19                 lda   hndl+2
2739 0B5C 8D 2A 16              sta   |LastLowHandle+2
2740 0B5F
2741 0B5F              ForgetThisOne  
2742 0B5F 6B                    rtl   
2743 0B60
2744 0B60              *
2745 0B60              * Search0 - Searches bank 0
2746 0B60              *
2747 0B60                       ENTRY Search0
2748 0B60              Search0                                 ; 
2749 0B60 20 23 0C              jsr   Start0                   ;Set up to start search
2750 0B63 20 5B 0F     Loop00   jsr   GetNextFree              ;Go to next free segment
2751 0B66 A5 1D                 lda   addr1+2                  ;Past bank0?
2752 0B68 D0 07                 bne   GiveUp                   ;Br if true
2753 0B6A 22 94 16 E1           jsl   CheckFit                 ;Will it fit?
2754 0B6E 90 F3                 bcc   Loop00
2755 0B70 6B                    rtl   
2756 0B71
2757 0B71 22 A8 16 E1  GiveUp   jsl   SearchFail               ;C = 0 for failed
2758 0B75 90 03                 bcc   GiveUp2
2759 0B77 4C F2 0A              jmp   XSearch
2760 0B7A 6B           GiveUp2  rtl   
2761 0B7B
2762 0B7B                       ENDP 
2763 0B7B
2764 0B7B
2765 0B7B
2766 0B7B
2767 0B7B
2768 0B7B              ********************************************************************************
2769 0B7B              *
2770 0B7B              * SearchDown   This is used to search from high to low memory
2771 0B7B              *              The search order is:
2772 0B7B              *                  Bank $DF to $01
2773 0B7B              *                  Bank $FF to $E0 (slow memory)
2774 0B7B              *                  Bank 0
2775 0B7B              *
2776 0B7B              * inputs:      attributes in A & attr
2777 0B7B              *
2778 0B7B              * outputs:     C=1 if segment found C=0 if no fit
2779 0B7B              *
2780 0B7B              *
2781 0B7B              * Change History
2782 0B7B              *
2783 0B7B              * 30 Aug 88         Steven Glass
2784 0B7B              *
2785 0B7B              * When a handle is found, we remember it in LastHighHandle.
2786 0B7B              *
2787 0B7B              ********************************************************************************
2788 0B7B              SearchDown PROC EXPORT
2789 0B7B                       longa on
2790 0B7B                       longi on
2791 0B7B
2792 0B7B 89 01 00              bit   #attr_bank               ;Fixed bank?
2793 0B7E F0 09                 beq   BankOk                   ;Br if not
2794 0B80 A5 05                 lda   addr+2                   ;Which bank?
2795 0B82 F0 46                 beq   Search00                 ;Br if bank 0
2796 0B84 C9 E0 00              cmp   #$E0                     ;Bank E0 or E1?
2797 0B87 B0 2A                 bcs   SearchFF                 ;Br if so
2798 0B89
2799 0B89              *
2800 0B89              * Search $DF to $01
2801 0B89              *
2802 0B89 A2 14 00     BankOk   ldx   #MemE0-Memlist           ;Start from bank $DF
2803 0B8C 20 31 0C              jsr   StartXTop                ;X says where to start from
2804 0B8F
2805 0B8F 20 9E 0F     LoopDF   jsr   GetPrevFree              ;Go to next lower free segment
2806 0B92 A5 1D                 lda   addr1+2                  ;If bank 0 DF - 1 done
2807 0B94 F0 1D                 beq   SearchFF                 ;Br if nil
2808 0B96 22 94 16 E1           jsl   CheckFit                 ;Will it fit?
2809 0B9A 90 F3                 bcc   LoopDF
2810 0B9C
2811 0B9C A5 07                 lda   attr                     ;don't remember this one if its fixed bank or fixed addr
2812 0B9E 89 01 00              bit   #attr_bank
2813 0BA1 D0 0F                 bne   ForgetThisOne
2814 0BA3
2815 0BA3 89 02 00              bit   #Attr_Addr
2816 0BA6 D0 0A                 bne   ForgetThisOne
2817 0BA8
2818 0BA8 A5 17                 lda   hndl                     ; put handle into place
2819 0BAA 8D 2C 16              sta   |LastHighHandle
2820 0BAD A5 19                 lda   hndl+2
2821 0BAF 8D 2E 16              sta   |LastHighHandle+2
2822 0BB2
2823 0BB2              ForgetThisOne  
2824 0BB2 6B                    rtl   
2825 0BB3
2826 0BB3              *
2827 0BB3              * Search $FF to $E0 (Really $E1 and $E0)
2828 0BB3              *
2829 0BB3 A2 1C 00     SearchFF ldx   #MemFF-Memlist           ;Start from bank $FF
2830 0BB6 20 31 0C              jsr   StartXTop                ;X says where to start from
2831 0BB9
2832 0BB9 20 9E 0F     LoopFF   jsr   GetPrevFree              ;Go to next lower free segment
2833 0BBC A5 1D                 lda   addr1+2                  ;Done if past $E0
2834 0BBE C9 E0 00              cmp   #$00E0
2835 0BC1 90 07                 blt   Search00
2836 0BC3 22 94 16 E1           jsl   CheckFit                 ;Will it fit?
2837 0BC7 90 F0                 bcc   LoopFF
2838 0BC9 6B                    rtl   
2839 0BCA
2840 0BCA
2841 0BCA              *
2842 0BCA              * Search00 - Searches bank 0
2843 0BCA              *
2844 0BCA                       ENTRY Search00
2845 0BCA              Search00                                ; 
2846 0BCA A2 0C 00              ldx   #Mem01-Memlist
2847 0BCD 20 31 0C              jsr   StartXTop                ;Set up to start search
2848 0BD0
2849 0BD0 20 9E 0F     Loop00   jsr   GetPrevFree              ;Go to next free segment
2850 0BD3 F0 07                 beq   GiveUp                   ;Br if nil
2851 0BD5 22 94 16 E1           jsl   CheckFit                 ;Will it fit?
2852 0BD9 90 F5                 bcc   Loop00
2853 0BDB 6B                    rtl   
2854 0BDC
2855 0BDC 22 A8 16 E1  GiveUp   jsl   SearchFail               ;C = 0 for failed
2856 0BE0 90 03                 bcc   GiveUp2
2857 0BE2 4C F2 0A              jmp   XSearch
2858 0BE5 6B           GiveUp2  rtl   
2859 0BE6
2860 0BE6                       ENDP 
2861 0BE6
2862 0BE6
2863 0BE6
2864 0BE6              ********************************************************************************
2865 0BE6              *
2866 0BE6              * SearchDownFast
2867 0BE6              *              This is used to search from high to low memory
2868 0BE6              *              The search order is:
2869 0BE6              *                  Starting with last handle found, 
2870 0BE6              *                  Bank $DF to $01
2871 0BE6              *                  Bank $FF to $E0 (slow memory)
2872 0BE6              *                  Bank 0
2873 0BE6              *
2874 0BE6              * inputs:      attributes in A & attr
2875 0BE6              *
2876 0BE6              * outputs:     C=1 if segment found C=0 if no fit
2877 0BE6              *
2878 0BE6              * Change History
2879 0BE6              *
2880 0BE6              * 30 Aug 88         Steven Glass
2881 0BE6              *
2882 0BE6              * Added this routine to speed up the search for space for a new
2883 0BE6              * handle.  This routine starts from the last allocated handle
2884 0BE6              * rather than from the beginning or the end of the list.
2885 0BE6              *
2886 0BE6              * This code was created by starting with SearchUp and removing
2887 0BE6              * all the code that was used if the first try failed.  This
2888 0BE6              * routine only handles fixed blocks that are not in a particular
2889 0BE6              * bank.
2890 0BE6              *
2891 0BE6              * If we fail at finding what we want, we return control to the 
2892 0BE6              * original SearchUp code.  This means that we won't return
2893 0BE6              * memory full if there is an available gap after the
2894 0BE6              * last allocated handle.
2895 0BE6              *
2896 0BE6              * When a handle is found, we remember it in LastHighHandle.
2897 0BE6              *
2898 0BE6              ********************************************************************************
2899 0BE6              SearchDownFast PROC EXPORT
2900 0BE6                       longa on
2901 0BE6                       longi on
2902 0BE6
2903 0BE6 89 01 00              bit   #attr_bank               ;Fixed bank?
2904 0BE9 D0 33                 bne   TryOldWay
2905 0BEB
2906 0BEB AD 2E 16              lda   |LastHighHandle+2
2907 0BEE F0 2E                 beq   TryOldWay
2908 0BF0 85 11                 sta   hndl1+2
2909 0BF2 AD 2C 16              lda   |LastHighHandle
2910 0BF5 85 0F                 sta   hndl1
2911 0BF7
2912 0BF7 20 9E 0F     LoopDF   jsr   GetPrevFree              ;Go to next lower free segment
2913 0BFA A5 1D                 lda   addr1+2                  ;If bank 0 DF - 1 done
2914 0BFC F0 20                 beq   TryOldWay                ;Br if nil
2915 0BFE 22 94 16 E1           jsl   CheckFit                 ;Will it fit?
2916 0C02 90 F3                 bcc   LoopDF
2917 0C04
2918 0C04 A5 07                 lda   attr                     ;if the handle was at a fixed location, don't
2919 0C06 89 02 00              bit   #Attr_Addr               ;remember it.
2920 0C09 D0 0A                 bne   ForgetThisOne
2921 0C0B
2922 0C0B A5 17                 lda   hndl                     ; put handle into place
2923 0C0D 8D 2C 16              sta   |LastHighHandle
2924 0C10 A5 19                 lda   hndl+2
2925 0C12 8D 2E 16              sta   |LastHighHandle+2
2926 0C15
2927 0C15              ForgetThisOne  
2928 0C15 EE 34 16              inc   |ShortCutCount
2929 0C18 D0 03                 bne   @NoCarry
2930 0C1A EE 36 16              inc   |ShortCutCount+2
2931 0C1D              @NoCarry  
2932 0C1D
2933 0C1D 6B                    rtl   
2934 0C1E
2935 0C1E A5 07        TryOldWay lda   attr
2936 0C20 4C 7B 0B              jmp   SearchDown
2937 0C23
2938 0C23
2939 0C23                       ENDP 
2940 0C23
2941 0C23
2942 0C23
2943 0C23
2944 0C23              ********************************************************************************
2945 0C23              *
2946 0C23              * Start0 - Sets everything up to start a search from bank0
2947 0C23              *
2948 0C23              * StartX - Uses X as an index from MemList for where to start from
2949 0C23              *
2950 0C23              * Output - Z = 1 if empty list
2951 0C23              *
2952 0C23              ********************************************************************************
2953 0C23              Start0   PROC EXPORT
2954 0C23                       longa on
2955 0C23                       longi on
2956 0C23
2957 0C23 A2 00 00              ldx   #0                       ;Use MemList
2958 0C26
2959 0C26                       ENTRY StartX
2960 0C26              StartX                                  ;       
2961 0C26
2962 0C26 BD 00 16              lda   |MemList,x               ;Get where to start from
2963 0C29 85 13                 sta   hndl2
2964 0C2B BD 02 16              lda   |MemList+2,x
2965 0C2E 85 15                 sta   hndl2+2                  ;nil if = 0
2966 0C30 60                    rts   
2967 0C31
2968 0C31                       ENDP 
2969 0C31
2970 0C31
2971 0C31
2972 0C31              ********************************************************************************
2973 0C31              *
2974 0C31              * StartXtop-  Uses X as an index from MemList for where to start from
2975 0C31              *             Sets up for top down search
2976 0C31              *
2977 0C31              * Output - Z = 1 if empty list
2978 0C31              *
2979 0C31              ********************************************************************************
2980 0C31              StartXTop PROC 
2981 0C31                       longa on
2982 0C31                       longi on
2983 0C31
2984 0C31 BD 00 16              lda   |MemList,x               ;Get where to start from
2985 0C34 85 0F                 sta   hndl1
2986 0C36 BD 02 16              lda   |MemList+2,x
2987 0C39 85 11                 sta   hndl1+2                  ;nil if = 0
2988 0C3B 60                    rts   
2989 0C3C
2990 0C3C                       ENDP 
2991 0C3C
2992 0C3C              ********************************************************************************
2993 0C3C              *
2994 0C3C              * BestTop - Gets the best top for a top down search
2995 0C3C              *              If Fixed Bank 0, then X = Mem01 - MemList
2996 0C3C              *              If Fixed Bank 1, then X = Mem02 - MemList
2997 0C3C              *              Else X = MemFF - MemList
2998 0C3C              *
2999 0C3C              * OutPuts:     X
3000 0C3C              *
3001 0C3C              ********************************************************************************
3002 0C3C              BestTop  PROC 
3003 0C3C                       longa on
3004 0C3C                       longi on
3005 0C3C
3006 0C3C A2 1C 00              ldx   #MemFF-MemList           ;Assume not fixed
3007 0C3F A5 07                 lda   attr                     ;Get Attributes
3008 0C41 89 01 00              bit   #Attr_Bank               ;Check for fixed bank
3009 0C44 F0 0A                 beq   NotFixed                 ;Br if not
3010 0C46 A5 05                 lda   addr+2                   ;Get bank
3011 0C48 F0 07                 beq   IsBank0                  ;Bank 0?
3012 0C4A 4A                    lsr   A
3013 0C4B D0 03                 bne   NotFixed                 ;Br if not bank 1
3014 0C4D A2 10 00              ldx   #Mem02-MemList
3015 0C50 60           NotFixed rts   
3016 0C51
3017 0C51 A2 0C 00     IsBank0  ldx   #Mem01-MemList
3018 0C54 60                    rts   
3019 0C55
3020 0C55
3021 0C55                       ENDP 
3022 0C55
3023 0C55
3024 0C55              ********************************************************************************
3025 0C55              *
3026 0C55              * CHECKFIT - This routine is used to test if a segment will fit between
3027 0C55              *            two addresses
3028 0C55              *
3029 0C55              * The following attributes are checked: fixed address, fixed bank,
3030 0C55              * page aligned, special memory, and bank crossing
3031 0C55              *
3032 0C55              * If the fixed bit is clear, then segment is allocated from the top
3033 0C55              *
3034 0C55              *
3035 0C55              * Inputs  addr1: beginning address
3036 0C55              *         addr2: ending address
3037 0C55              *         size : number of bytes in segment
3038 0C55              *         attr : attributes of segment
3039 0C55              *
3040 0C55              * Outputs C = 0 if doesn't fit
3041 0C55              *           = 1 if segment fits
3042 0C55              *         addr1: beginning address to allocate (may be different from input)
3043 0C55              *         addr2  destroyed
3044 0C55              *         size, attr unchanged
3045 0C55              *
3046 0C55              * Calls go through $E1
3047 0C55              *
3048 0C55              * Modified by Konstantin Othmer on Nov. 11, 88
3049 0C55              *
3050 0C55              *     Added check at beginning for attributes.  If there are none (the most common
3051 0C55              *       case) we branch directly to check part.
3052 0C55              *
3053 0C55              ********************************************************************************
3054 0C55              XCheckFit PROC 
3055 0C55                       longa on
3056 0C55                       longi on
3057 0C55
3058 0C55              ; If addr1 = addr2 then don't bother
3059 0C55              ;	lda	addr1
3060 0C55              ;	cmp	addr2
3061 0C55              ;	bne	AddrOK
3062 0C55              ;	lda	addr+2
3063 0C55              ;	cmp	addr2+2
3064 0C55              ;	bne	AddrOK
3065 0C55              ;NoFit	clc
3066 0C55              ;	rtl
3067 0C55
3068 0C55
3069 0C55 A5 07        AddrOK   lda   attr                     ;Get search attributes
3070 0C57 29 FF 7C              and   #$7CFF                   ;strip off purge and locked
3071 0C5A D0 03                 bne   Cont1                    ;top down, no attributes
3072 0C5C 82 DF 00              brl   Check2
3073 0C5F C9 00 40     Cont1    cmp   #$4000
3074 0C62 D0 03                 bne   Cont2                    ;Bottom up no attributes
3075 0C64 82 9D 00              brl   Check
3076 0C67 A5 07        Cont2    lda   attr
3077 0C69              ;
3078 0C69              ; Check if fixed bank
3079 0C69              ;
3080 0C69 4A                    lsr   A
3081 0C6A 90 14                 bcc   AddChk                   ;Br if don't care
3082 0C6C A8                    tay   
3083 0C6D A5 21 C5 05           cmp_w addr2+2,addr+2           ;If addr2 bank < addr bank then no fit
3084 0C71 90 39                 bcc   NoFit2
3085 0C73 A5 05 C5 1D           cmp_w addr+2,addr1+2           ;If addr bank < addr1 bank then no fit
3086 0C77 90 33                 bcc   NoFit2
3087 0C79 F0 04                 beq   SameBank                 ;Br if bank was ok
3088 0C7B 85 1D                 sta   addr1+2                  ;Set addr1 to beginning of bank
3089 0C7D 64 1B                 stz   addr1
3090 0C7F 98           SameBank tya   
3091 0C80
3092 0C80              ; Check if rest of address fixed too
3093 0C80 4A           AddChk   lsr   A
3094 0C81 90 14                 bcc   PageChk                  ;If this true, bank was too
3095 0C83 A8                    tay   
3096 0C84 A5 1F C5 03           cmp_l addr2,addr               ;If addr2 < addr then no fit
3097 0C8C 90 74                 bcc   NoFit
3098 0C8E A5 03 C5 1B           cmp_w addr,addr1               ;If addr < addr1 then no fit
3099 0C92 90 6E                 bcc   NoFit                    ;We know that bank is ok
3100 0C94 85 1B                 sta   addr1                    ;Set addr1 = addr
3101 0C96 98                    tya   
3102 0C97
3103 0C97              ; Check if page alignment needed. 4th byte of addr1 ignored
3104 0C97 4A           PageChk  lsr   A                        ;C = 1 if aligned
3105 0C98 24 07                 bit   attr                     ;If top down search
3106 0C9A 50 13                 bvc   SpecChk                  ; then page check done later
3107 0C9C 90 11                 bcc   SpecChk                  ;Br if don't care
3108 0C9E A8                    tay                            ;Save attributes
3109 0C9F A9 FF 00              lda   #$FF
3110 0CA2 14 1B                 trb   addr1                    ;Force Alignment
3111 0CA4 F0 08                 beq   AlignOk                  ;Br if was aligned
3112 0CA6 E6 1C                 inc   addr1+1                  ;Carry into bytes 2 & 3
3113 0CA8 A5 20 C5 1C           cmp_w addr2+1,addr1+1          ;If addr2 < addr1 then no fit
3114 0CAC 90 54        NoFit2   bcc   NoFit
3115 0CAE 98           AlignOk  tya                            ;Get attr back
3116 0CAF
3117 0CAF              ; Now Check for special memory ok
3118 0CAF              ; Note: if one address if in special memory, the other will be in the same bank
3119 0CAF 4A           SpecChk  lsr   A                        ;C = 1 if can't use special
3120 0CB0 90 1F                 bcc   BankChk                  ;Br if don't care
3121 0CB2 A4 21                 ldy   addr2+2                  ;If addr2 in special then give up
3122 0CB4 C0 02 00              cpy   #2                       ;Banks 0 & 1 special
3123 0CB7 90 49                 bcc   NoFit
3124 0CB9 A2 FF 5F              ldx   #$5FFF                   ;Bank E0 up to $6000 special
3125 0CBC C0 E0 00              cpy   #$E0                     ;If 1 < bank < E0 then ok
3126 0CBF 90 10                 blt   BankChk
3127 0CC1 F0 03                 beq   IsE0                     ;Br if bank E0
3128 0CC3 A2 FF 9F              ldx   #$9FFF                   ;Bank E1 up to $A000 special
3129 0CC6 E4 1B        IsE0     cpx   addr1                    ;Is addr1 not special?
3130 0CC8 90 07                 bcc   BankChk                  ;We're not in special if it isn't
3131 0CCA E4 1F                 cpx   addr2                    ;Is addr2 not special?
3132 0CCC B0 34                 bcs   NoFit                    ;Give up if it is special
3133 0CCE E8                    inx                            ;Make addr1 first non special byte
3134 0CCF 86 1B                 stx   addr1
3135 0CD1
3136 0CD1              ; Now check if bank crossing allowed.
3137 0CD1              ; If not, separate segment into smaller segments
3138 0CD1 4A           BankChk  lsr   A                        ;C = 1 if can't cross bank
3139 0CD2 24 07                 bit   attr
3140 0CD4 50 3D                 bvc   BankChk2                 ;Br to top down routines
3141 0CD6 90 2C                 bcc   Check                    ;Br if don't care
3142 0CD8 A5 21 C5 1D  BankLoop cmp_w addr2+2,addr1+2          ;Same bank?
3143 0CDC F0 26                 beq   Check
3144 0CDE 48                    pha                            ;A = addr2+2 from macro
3145 0CDF A5 1F 48              push_w addr2                   ;Save addr2
3146 0CE2 64 1F                 stz   addr2                    ;Make addr2 bottom of next bank
3147 0CE4 A5 1D                 lda   addr1+2
3148 0CE6 1A                    inc   A
3149 0CE7 85 21                 sta   addr2+2
3150 0CE9 22 04 0D FC           jsl   Check
3151 0CED B0 10                 bcs   Found                    ;Br if it fit
3152 0CEF A5 1F 85 1B           move_l addr2,addr1             ;Move addr2 to addr1
3153 0CF7 68 85 1F 68           pop_l addr2                    ;Restore addr2
3154 0CFD 80 D9                 bra   BankLoop                 ;Try again from here
3155 0CFF
3156 0CFF 68           Found    pla                            ;Get rid of saved addr2
3157 0D00 68                    pla   
3158 0D01 6B                    rtl   
3159 0D02
3160 0D02 18           NoFit    clc   
3161 0D03 6B                    rtl   
3162 0D04
3163 0D04              ; Now see if addr2 - addr1 >= size.
3164 0D04 38           Check    sec   
3165 0D05 A5 1F                 lda   addr2                    ;Y,A = addr2 - addr1
3166 0D07 E5 1B                 sbc   addr1
3167 0D09 A8                    tay   
3168 0D0A A5 21                 lda   addr2+2
3169 0D0C E5 1D                 sbc   addr1+2
3170 0D0E C4 0B                 cpy   size
3171 0D10 E5 0D                 sbc   size+2                   ;C = 0 if no fit
3172 0D12 6B                    rtl   
3173 0D13
3174 0D13              * These routines are for allocating from the top
3175 0D13 90 29        BankChk2 bcc   Check2                   ;Br if bank cross OK
3176 0D15 A5 1D C5 21           cmp_w addr1+2,addr2+2          ;Does the free space cross a bank?
3177 0D19 F0 23                 beq   Check2                   ;Br if in same bank
3178 0D1B 48                    pha                            ;Save addr1. A = addr1+2 from cmp_w
3179 0D1C A5 1B 48              push_w addr1
3180 0D1F 64 1B                 stz   addr1                    ;Set addr1 to beginning of bank
3181 0D21 A5 21                 lda   addr2+2                  ; containing addr2
3182 0D23 85 1D        BankLoop2 sta   addr1+2                 ;Save starting address for this try
3183 0D25 22 3E 0D FC           jsl   Check2                   ;Does it fit?
3184 0D29 B0 D4                 bcs   Found                    ;Cleanup stack and return if so.
3185 0D2B A5 1B                 lda   addr1                    ;Make addr2 end of next lower bank
3186 0D2D 85 1F                 sta   addr2
3187 0D2F A5 1D                 lda   addr1+2
3188 0D31 85 21                 sta   addr2+2
3189 0D33 3A                    dec   A                        ;Move A down to next bank
3190 0D34 C3 03                 cmp   3,s                      ;Are we in the original addr1 bank?
3191 0D36 D0 EB                 bne   BankLoop2                ;If so, this is last check.
3192 0D38 68 85 1B 68           pop_l addr1                    ;Restore original addr1
3193 0D3E
3194 0D3E              * If addr2-size >= addr1 then the segment fits and the starting address
3195 0D3E              * is addr2-size.  Page alignment is also done here
3196 0D3E 38           Check2   sec                            ;Calc addr2-size
3197 0D3F A5 1F                 lda   addr2
3198 0D41 E5 0B                 sbc   size
3199 0D43 AA                    tax                            ;X = low word
3200 0D44 A5 07                 lda   attr                     ;Force page alignment
3201 0D46 29 04 00              and   #Attr_Page               ;Don't alter C!
3202 0D49 F0 05                 beq   PageOK
3203 0D4B 8A                    txa   
3204 0D4C 29 00 FF              and   #$FF00                   ;Force to lower page
3205 0D4F AA                    tax   
3206 0D50 A5 21        PageOK   lda   addr2+2
3207 0D52 E5 0D                 sbc   size+2
3208 0D54 90 0B                 bcc   Done                     ;No good if size > addr2
3209 0D56 A8                    tay                            ;Y = high word
3210 0D57 E4 1B                 cpx   addr1                    ;Is result < addr1?
3211 0D59 E5 1D                 sbc   addr1+2
3212 0D5B 90 04                 bcc   Done                     ;Br with C=0 if failed
3213 0D5D 86 1B                 stx   addr1                    ;Hooray! save starting address in addr1
3214 0D5F 84 1D                 sty   addr1+2                  ;and return with C = 0
3215 0D61 6B           Done     rtl   
3216 0D62
3217 0D62                       ENDP 
3218 0D62
3219 0D62
3220 0D62
3221 0D62
3222 0D62              ********************************************************************************
3223 0D62              *
3224 0D62              * SearchID - Searches for a handle owned by owner
3225 0D62              *
3226 0D62              * Inputs:      A,X = First handle of list to check
3227 0D62              *
3228 0D62              * Outputs:     C = 0 if none found and end of list
3229 0D62              *              Hndl = Handle found
3230 0D62              *              A,X = next handle in list
3231 0D62              *
3232 0D62              ********************************************************************************
3233 0D62              SearchID PROC 
3234 0D62                       longa on
3235 0D62                       longi on
3236 0D62
3237 0D62 18                    clc                            ;Assume nil
3238 0D63 85 17        Loop     sta   hndl                     ;Store the handle
3239 0D65 86 19                 stx   hndl+2
3240 0D67 05 19                 ora   hndl+2                   ;Was it nil?
3241 0D69 F0 18                 beq   IsNil
3242 0D6B A0 06 00              ldy   #Hndl_Owner              ;Get the owner
3243 0D6E B7 17                 lda   [hndl],y
3244 0D70 25 2D                 and   parms                    ;And it with mask
3245 0D72 C5 09                 cmp   owner                    ;Is it who we want?
3246 0D74 F0 01                 beq   Found                    ;C=1 if found
3247 0D76 18                    clc                            ;Mark not found
3248 0D77 A0 12 00     Found    ldy   #Hndl_Next+2             ;Get the next one
3249 0D7A B7 17                 lda   [hndl],y
3250 0D7C AA                    tax                            ;X = high
3251 0D7D 88                    dey   
3252 0D7E 88                    dey   
3253 0D7F B7 17                 lda   [hndl],y                 ;A = low
3254 0D81 90 E0                 bcc    Loop                    ;Go to next if not found
3255 0D83 60           IsNil    rts                            ;C = 1 if found
3256 0D84
3257 0D84                       ENDP 
3258 0D84
3259 0D84
3260 0D84                       title ' Handle Manipulation Stuff'
3261 0D84              ********************************************************************************
3262 0D84              *
3263 0D84              * InsertHandle - Inserts a handle into the used memory list
3264 0D84              *
3265 0D84              * MoveAttr - moves the attributes into a handle
3266 0D84              *
3267 0D84              ********************************************************************************
3268 0D84              InsertHandle PROC 
3269 0D84                       longa on
3270 0D84                       longi on
3271 0D84
3272 0D84 A0 10 00 A5           seth_l hndl,hndl1,hndl_next    ;This is the next from hndl1
3273 0D91 A0 0C 00 A5           seth_l hndl,hndl2,hndl_prev    ;This is the previous from hndl2
3274 0D9E A5 1B 85 03           move_l addr1,addr              ;Move the starting address
3275 0DA6
3276 0DA6                       ENTRY MoveAttr
3277 0DA6              MoveAttr                                ;       
3278 0DA6
3279 0DA6 A0 12 00              ldy   #HSize-2                 ;Move the data into the handle
3280 0DA9 BB           moveloop tyx   
3281 0DAA B5 03                 lda   addr,x
3282 0DAC 97 17                 sta   [hndl],y
3283 0DAE 88                    dey   
3284 0DAF 88                    dey   
3285 0DB0 10 F7                 bpl   moveloop
3286 0DB2 60                    rts   
3287 0DB3
3288 0DB3                       ENDP 
3289 0DB3
3290 0DB3
3291 0DB3
3292 0DB3              ********************************************************************************
3293 0DB3              *
3294 0DB3              * GetAttr - Gets the attributes of a handle
3295 0DB3              *
3296 0DB3              * Inputs:      hndl:    handle to get info from
3297 0DB3              *
3298 0DB3              * Outputs:     zp:      handle data
3299 0DB3              *
3300 0DB3              ********************************************************************************
3301 0DB3              GetAttr  PROC 
3302 0DB3                       longa on
3303 0DB3                       longi on
3304 0DB3
3305 0DB3 A0 12 00              ldy   #HSize-2                 ;Get the data from the handle
3306 0DB6 BB           moveloop tyx   
3307 0DB7 B7 17                 lda   [hndl],y
3308 0DB9 95 03                 sta   addr,x
3309 0DBB 88                    dey   
3310 0DBC 88                    dey   
3311 0DBD 10 F7                 bpl   moveloop
3312 0DBF 60                    rts   
3313 0DC0                       ENDP 
3314 0DC0
3315 0DC0
3316 0DC0              ********************************************************************************
3317 0DC0              *
3318 0DC0              * ReAlloc - reallocates a handle
3319 0DC0              *
3320 0DC0              * Inputs:      hndl = handle to reallocate
3321 0DC0              *
3322 0DC0              * Outputs:     C = 1 if failed
3323 0DC0              *              zp has handle attributes
3324 0DC0              *
3325 0DC0              * Calls go through $E1 vector
3326 0DC0              *
3327 0DC0              ********************************************************************************
3328 0DC0              XRealloc PROC 
3329 0DC0                       longa on
3330 0DC0                       longi on
3331 0DC0
3332 0DC0 20 B3 0D              jsr   GetAttr                  ;Get the attributes
3333 0DC3 A5 03                 lda   addr
3334 0DC5 05 05                 ora   addr+2                   ;Is it really nil?
3335 0DC7 D0 11                 bne   NotNil                   ;Can't realloc if not nil
3336 0DC9 20 DC 0D              jsr   RemoveHandle
3337 0DCC 22 90 16 E1           jsl   Search
3338 0DD0 90 05                 bcc   Full
3339 0DD2 20 84 0D              jsr   InsertHandle             ;Put it in used list
3340 0DD5 18                    clc   
3341 0DD6 6B                    rtl   
3342 0DD7
3343 0DD7 20 02 0F     Full     jsr   InsertPurge              ;Put it back in purge list
3344 0DDA 38           NotNil   sec   
3345 0DDB 6B                    rtl   
3346 0DDC
3347 0DDC                       ENDP 
3348 0DDC
3349 0DDC
3350 0DDC
3351 0DDC              ********************************************************************************
3352 0DDC              *
3353 0DDC              * RemoveHandle - Removes a handle from a list
3354 0DDC              *                If hndl.next <> nil then hndl.next.prev = hndl.prev
3355 0DDC              *                If hndl.prev <> nil then hndl.prev.next = hndl.next
3356 0DDC              * Inputs:      hndl = handle to be removed
3357 0DDC              *              hndl1, hndl2 used
3358 0DDC              *
3359 0DDC              ********************************************************************************
3360 0DDC              RemoveHandle PROC 
3361 0DDC                       longa on
3362 0DDC                       longi on
3363 0DDC
3364 0DDC A0 0C 00 B7           geth_l hndl,hndl1,hndl_prev    ;Get previous handle
3365 0DE9 A0 10 00 B7           geth_l hndl,hndl2,hndl_next    ;and the next too
3366 0DF6 A5 13                 lda   hndl2                    ;Is next nil?
3367 0DF8 05 15                 ora   hndl2+2
3368 0DFA F0 0D                 beq   IsNil                    ;Br if it is
3369 0DFC A0 0C 00 A5           seth_l hndl1,hndl2,hndl_prev   ;Set previous of next handle
3370 0E09 A5 0F        IsNil    lda   hndl1                    ;Is previous nil
3371 0E0B 05 11                 ora   hndl1+2
3372 0E0D F0 0E                 beq   Head                     ;If so, head of a list
3373 0E0F A0 10 00 A5           seth_l hndl2,hndl1,hndl_next
3374 0E1C 60                    rts   
3375 0E1D
3376 0E1D A2 08 00     Head     ldx   #FreeList-MemList        ;Check if head of free or purge
3377 0E20 A5 17                 lda   hndl
3378 0E22 CD 08 16              cmp   |FreeList
3379 0E25 D0 07                 bne   NotFree
3380 0E27 A5 19                 lda   hndl+2
3381 0E29 CD 0A 16              cmp   |FreeList+2
3382 0E2C F0 11                 beq   IsFree
3383 0E2E A5 17        NotFree  lda   hndl                     ;Head of purged list
3384 0E30 CD 04 16              cmp   |PurgeList
3385 0E33 D0 14                 bne   NotPurge
3386 0E35 A5 19                 lda   hndl+2
3387 0E37 CD 06 16              cmp   |PurgeList+2
3388 0E3A D0 0D                 bne   NotPurge
3389 0E3C A2 04 00              ldx   #PurgeList-MemList
3390 0E3F A5 13        IsFree   lda   hndl2                    ;Make hndl2 head of list
3391 0E41 9D 00 16              sta   |MemList,x
3392 0E44 A5 15                 lda   hndl2+2
3393 0E46 9D 02 16              sta   |MemList+2,x
3394 0E49 60           NotPurge rts   
3395 0E4A
3396 0E4A                       ENDP 
3397 0E4A
3398 0E4A              ********************************************************************************
3399 0E4A              *
3400 0E4A              * GetFree - Gets the next free handle from the free list
3401 0E4A              *
3402 0E4A              *           Outputs: hndl = free handle
3403 0E4A              *  Z = 1 if no free handles
3404 0E4A              *
3405 0E4A              * Goes through $E1 vector
3406 0E4A              *
3407 0E4A              ********************************************************************************
3408 0E4A              XGetFree PROC 
3409 0E4A                       longa on
3410 0E4A                       longi on
3411 0E4A
3412 0E4A AD 08 16              lda   |FreeList                ;Get pointer to free handles
3413 0E4D 85 17                 sta   hndl
3414 0E4F AD 0A 16              lda   |FreeList+2
3415 0E52 85 19                 sta   hndl+2
3416 0E54 05 17                 ora   hndl                     ;Nil pointer?
3417 0E56 D0 0E                 bne   HndlOk
3418 0E58
3419 0E58              ; Try to allocate more handles
3420 0E58 A9 32 00              lda   #50                      ;Make 50 handles
3421 0E5B 22 A0 16 E1           jsl   CreateHandles            ;Go make them
3422 0E5F 90 29                 bcc   Done                     ;Br if error
3423 0E61 20 E2 0E              jsr   InsertFrBlock            ;Put them in free list
3424 0E64 80 E4                 bra   XGetFree                 ;Go try again
3425 0E66
3426 0E66 A0 10 00     HndlOK   ldy   #hndl_next               ;Get the next handle
3427 0E69 B7 17                 lda   [hndl],y
3428 0E6B 85 0F                 sta   hndl1                    ;Put it in hndl1 and freelist
3429 0E6D 8D 08 16              sta   |FreeList
3430 0E70 C8                    iny   
3431 0E71 C8                    iny   
3432 0E72 B7 17                 lda   [hndl],y
3433 0E74 8D 0A 16              sta   |FreeList+2
3434 0E77 85 11                 sta   hndl1+2
3435 0E79 05 0F                 ora   hndl1                    ;Was it nil?
3436 0E7B F0 0C                 beq   nomore
3437 0E7D A9 00 00              lda   #nil                     ;Make its previous nil
3438 0E80 A0 0C 00              ldy   #hndl_prev
3439 0E83 97 0F                 sta   [hndl1],y
3440 0E85 C8                    iny   
3441 0E86 C8                    iny   
3442 0E87 97 0F                 sta   [hndl1],y
3443 0E89 38           nomore   sec                            ;No error
3444 0E8A 6B           done     rtl   
3445 0E8B
3446 0E8B                       ENDP 
3447 0E8B
3448 0E8B
3449 0E8B              ********************************************************************************
3450 0E8B              *
3451 0E8B              * InsertFree - Inserts a handle into the free list
3452 0E8B              *
3453 0E8B              *              hndl.next = (FreeList)
3454 0E8B              *              hndl.prev = nil
3455 0E8B              *              rest of handle zeroed
3456 0E8B              *              FreeList = (hndl)
3457 0E8B              *
3458 0E8B              * Inputs:      hndl = handle to be inserted
3459 0E8B              *              Y = Size of block for DoInsert
3460 0E8B              *
3461 0E8B              ********************************************************************************
3462 0E8B              InsertFree PROC 
3463 0E8B                       longa on
3464 0E8B                       longi on
3465 0E8B
3466 0E8B A0 14 00              ldy   #HSize                   ;Do one handle
3467 0E8E A2 08 00              ldx   #FreeList-MemList        ;Point to free list
3468 0E91
3469 0E91                       ENTRY DoInsert
3470 0E91              DoInsert                                ;       
3471 0E91 A5 19                 lda   hndl+2                   ;Don't do it if bad handle
3472 0E93 F0 4C                 beq   Done
3473 0E95 5A                    phy                            ;Save Size for later
3474 0E96 88                    dey                            ;Link rest of list to this one
3475 0E97 88                    dey                            ;Point to hndl.next
3476 0E98 BD 02 16              lda   |MemList+2,x
3477 0E9B 97 17                 sta   [hndl],y
3478 0E9D 85 15                 sta   hndl2+2                  ;Save it for later
3479 0E9F 88                    dey   
3480 0EA0 88                    dey   
3481 0EA1 BD 00 16              lda   |MemList,x
3482 0EA4 97 17                 sta   [hndl],y
3483 0EA6 85 13                 sta   hndl2
3484 0EA8 A5 17                 lda   hndl                     ;Make this handle the first one
3485 0EAA 9D 00 16              sta   |MemList,x
3486 0EAD A5 19                 lda   hndl+2
3487 0EAF 9D 02 16              sta   |MemList+2,x
3488 0EB2 A9 00 00              lda   #nil                     ;Zero out other stuff
3489 0EB5 A0 0E 00              ldy   #hndl_prev+2             ;Now set the previous
3490 0EB8 97 17                 sta   [hndl],y                 ;Previous = nil
3491 0EBA 88                    dey   
3492 0EBB 88                    dey   
3493 0EBC 97 17                 sta   [hndl],y
3494 0EBE A0 00 00              ldy   #Hndl_Addr               ;Address = nil
3495 0EC1 97 17                 sta   [hndl],y
3496 0EC3 C8                    iny   
3497 0EC4 C8                    iny   
3498 0EC5 97 17                 sta   [hndl],y
3499 0EC7              ; Set hndl2.prev to hndl+blocksize-HSize
3500 0EC7 68                    pla                            ;Recover block size
3501 0EC8 A4 15                 ldy   hndl2+2                  ;Is hndl2 nil?
3502 0ECA F0 15                 beq   Done                     ;If so, there is no next
3503 0ECC A0 0C 00              ldy   #hndl_prev
3504 0ECF 38                    sec   
3505 0ED0 E9 14 00              sbc   #HSize
3506 0ED3 18                    clc   
3507 0ED4 65 17                 adc   hndl
3508 0ED6 97 13                 sta   [hndl2],y
3509 0ED8 C8                    iny   
3510 0ED9 C8                    iny   
3511 0EDA A5 19                 lda   hndl+2
3512 0EDC 69 00 00              adc   #0
3513 0EDF 97 13                 sta   [hndl2],y
3514 0EE1
3515 0EE1
3516 0EE1 60           Done     rts   
3517 0EE2
3518 0EE2                       ENDP 
3519 0EE2
3520 0EE2
3521 0EE2              ********************************************************************************
3522 0EE2              *
3523 0EE2              * InsertFrBlock  Inserts a free block of handles
3524 0EE2              *
3525 0EE2              ********************************************************************************
3526 0EE2              InsertFrBlock PROC 
3527 0EE2                       longa on
3528 0EE2                       longi on
3529 0EE2
3530 0EE2 A2 08 00              ldx   #FreeList-MemList        ;Point to free list
3531 0EE5
3532 0EE5                       ENTRY DoBlockInsert
3533 0EE5              DoBlockInsert                           ;
3534 0EE5
3535 0EE5 98                    tya                            ;Get rid of first handle
3536 0EE6 38                    sec   
3537 0EE7 E9 14 00              sbc   #HSize
3538 0EEA A8                    tay   
3539 0EEB A5 17                 lda   hndl                     ;Move hndl up by one
3540 0EED 18                    clc   
3541 0EEE 69 14 00              adc   #HSize
3542 0EF1 85 17                 sta   hndl
3543 0EF3 A5 19                 lda   hndl+2
3544 0EF5 69 00 00              adc   #0
3545 0EF8 85 19                 sta   hndl+2
3546 0EFA 4C 91 0E              jmp   DoInsert
3547 0EFD
3548 0EFD                       ENDP 
3549 0EFD
3550 0EFD
3551 0EFD              ********************************************************************************
3552 0EFD              *
3553 0EFD              * InsertPgBlock - Inserts a block of empty handles
3554 0EFD              *
3555 0EFD              * Inputs:      hndl = Block of handles (first one is skipped)
3556 0EFD              *              Y = size of block in bytes
3557 0EFD              *
3558 0EFD              * Outputs:     hndl points to first empty handle
3559 0EFD              *
3560 0EFD              ********************************************************************************
3561 0EFD              InsertPgBlock PROC 
3562 0EFD                       longa on
3563 0EFD                       longi on
3564 0EFD
3565 0EFD A2 04 00              ldx   #PurgeList-MemList       ;Point to free list
3566 0F00 80 E3                 bra   DoBlockInsert
3567 0F02
3568 0F02                       ENDP 
3569 0F02
3570 0F02
3571 0F02
3572 0F02              ********************************************************************************
3573 0F02              *
3574 0F02              * InsertPurge - Inserts a handle into PurgeList
3575 0F02              *
3576 0F02              ********************************************************************************
3577 0F02              InsertPurge PROC 
3578 0F02                       longa on
3579 0F02                       longi on
3580 0F02
3581 0F02 A0 14 00              ldy   #HSize                   ;Do one block
3582 0F05 A2 04 00              ldx   #PurgeList-MemList
3583 0F08 80 87                 bra   DoInsert
3584 0F0A
3585 0F0A                       ENDP 
3586 0F0A
3587 0F0A
3588 0F0A
3589 0F0A              ********************************************************************************
3590 0F0A              *
3591 0F0A              * GetNext - Goes to the next segment in the list
3592 0F0A              *              hndl2 -> hndl1
3593 0F0A              *              hndl1.next -> hndl2
3594 0F0A              *              hndl1.addr+hndl1.size-> addr1
3595 0F0A              *              hndl2.addr -> addr2
3596 0F0A              *              if hndl2 = nil then Z = 1 and addr2 unchanged
3597 0F0A              *
3598 0F0A              * GetPrev - Goes to the previous segment in the list
3599 0F0A              *              hndl1 -> hndl2
3600 0F0A              *              hndl2.prev -> hndl1
3601 0F0A              *              hndl1.addr+hndl1.size-> addr1
3602 0F0A              *              hndl2.addr -> addr2
3603 0F0A              *              if hndl2 = nil then Z = 1 and addr2 unchanged
3604 0F0A              *
3605 0F0A              ********************************************************************************
3606 0F0A              GetNext  PROC EXPORT
3607 0F0A                       longa on
3608 0F0A                       longi off
3609 0F0A
3610 0F0A E2 10                 sep   #$10                     ;8 bit index
3611 0F0C A5 13 85 0F           move_l hndl2,hndl1             ;hndl1 = hndl2
3612 0F14
3613 0F14 A0 10                 ldy   #hndl_next               ;hndl2 = hndl1.next
3614 0F16 B7 0F                 lda   [hndl1],y
3615 0F18 85 13                 sta   hndl2
3616 0F1A A0 12                 ldy   #hndl_next+2
3617 0F1C B7 0F                 lda   [hndl1],y
3618 0F1E 85 15                 sta   hndl2+2
3619 0F20 F0 36                 beq   Done                     ;Br if hndl2 nil
3620 0F22 80 18                 bra   NotNil
3621 0F24
3622 0F24                       ENTRY GetPrev
3623 0F24              GetPrev                                 ;       
3624 0F24
3625 0F24 E2 10                 sep   #$10                     ;8 bit index
3626 0F26 A5 0F 85 13           move_l hndl1,hndl2             ;hndl2 = hndl1
3627 0F2E
3628 0F2E A0 0C                 ldy   #hndl_prev               ;hndl1 = hndl2.prev
3629 0F30 B7 13                 lda   [hndl2],y
3630 0F32 85 0F                 sta   hndl1
3631 0F34 A0 0E                 ldy   #hndl_prev+2
3632 0F36 B7 13                 lda   [hndl2],y
3633 0F38 85 11                 sta   hndl1+2
3634 0F3A F0 1C                 beq   Done                     ;Br if hndl1 nil
3635 0F3C
3636 0F3C A0 08        NotNil   ldy   #hndl_size               ;addr1 = addr+size
3637 0F3E 18                    clc   
3638 0F3F B7 0F                 lda   [hndl1],y
3639 0F41 67 0F                 adc   [hndl1]                  ;add addr
3640 0F43 85 1B                 sta   addr1
3641 0F45 A0 0A                 ldy   #hndl_size+2
3642 0F47 B7 0F                 lda   [hndl1],y
3643 0F49 A0 02                 ldy   #hndl_addr+2
3644 0F4B 77 0F                 adc   [hndl1],y
3645 0F4D 85 1D                 sta   addr1+2
3646 0F4F
3647 0F4F B7 13                 lda   [hndl2],y                ;addr2 = hndl2.addr
3648 0F51 85 21                 sta   addr2+2                  ;Y = hndl_addr+2 from earlier
3649 0F53 A7 13                 lda   [hndl2]
3650 0F55 85 1F                 sta   addr2
3651 0F57 C8                    iny                            ;Make Z <> 1
3652 0F58 C2 10        Done     rep   #$10                     ;Back to 16 bit X
3653 0F5A 60                    rts   
3654 0F5B
3655 0F5B                       ENDP 
3656 0F5B
3657 0F5B              ********************************************************************************
3658 0F5B              *
3659 0F5B              * GetNextFree - Goes to the next free segment in the list
3660 0F5B              *              hndl2 -> hndl1
3661 0F5B              *              hndl1.next -> hndl2
3662 0F5B              *              hndl1.addr+hndl1.size-> addr1
3663 0F5B              *              hndl2.addr -> addr2
3664 0F5B              *              if hndl2 = nil then Z = 1 and addr2 unchanged
3665 0F5B              *
3666 0F5B              * GetPrev - Goes to the previous free segment in the list
3667 0F5B              *              hndl1 -> hndl2
3668 0F5B              *              hndl2.prev -> hndl1
3669 0F5B              *              hndl1.addr+hndl1.size-> addr1
3670 0F5B              *              hndl2.addr -> addr2
3671 0F5B              *              if hndl2 = nil then Z = 1 and addr2 unchanged
3672 0F5B              *
3673 0F5B              * Returns with equal flag set if next handle is nil.
3674 0F5B              *
3675 0F5B              *  Added by Konstantin Othmer Nov. 11, 88
3676 0F5B              *
3677 0F5B              ********************************************************************************
3678 0F5B              GetNextFree PROC 
3679 0F5B                       longa on
3680 0F5B                       longi off
3681 0F5B
3682 0F5B E2 10                 sep   #$10                     ;8 bit index
3683 0F5D A5 13 85 0F           move_l hndl2,hndl1             ;hndl1 = hndl2
3684 0F65
3685 0F65 A0 10                 ldy   #hndl_next               ;hndl2 = hndl1.next
3686 0F67 B7 0F                 lda   [hndl1],y
3687 0F69 85 13                 sta   hndl2
3688 0F6B A0 12                 ldy   #hndl_next+2
3689 0F6D B7 0F                 lda   [hndl1],y
3690 0F6F 85 15                 sta   hndl2+2
3691 0F71 F0 28                 beq   Done                     ;Br if hndl2 nil
3692 0F73
3693 0F73 A0 08        NotNil   ldy   #hndl_size               ;addr1 = addr+size
3694 0F75 18                    clc   
3695 0F76 B7 0F                 lda   [hndl1],y
3696 0F78 67 0F                 adc   [hndl1]                  ;add addr
3697 0F7A 85 1B                 sta   addr1
3698 0F7C A0 0A                 ldy   #hndl_size+2
3699 0F7E B7 0F                 lda   [hndl1],y
3700 0F80 A0 02                 ldy   #hndl_addr+2
3701 0F82 77 0F                 adc   [hndl1],y
3702 0F84 85 1D                 sta   addr1+2
3703 0F86
3704 0F86 B7 13                 lda   [hndl2],y                ;addr2 = hndl2.addr
3705 0F88 85 21                 sta   addr2+2                  ;Y = hndl_addr+2 from earlier
3706 0F8A A7 13                 lda   [hndl2]
3707 0F8C 85 1F                 sta   addr2
3708 0F8E
3709 0F8E              ; If addr1 = addr2 then skip get the next one
3710 0F8E
3711 0F8E C5 1B                 cmp   addr1
3712 0F90 D0 08                 bne   AddrOK
3713 0F92 A5 1D                 lda   addr1+2
3714 0F94 C5 21                 cmp   addr2+2
3715 0F96 D0 02                 bne   AddrOK
3716 0F98 80 C1        NoFit    bra   GetNextFree
3717 0F9A
3718 0F9A C8           AddrOK   iny                            ;Make Z <> 1
3719 0F9B C2 10        Done     rep   #$10                     ;Back to 16 bit X
3720 0F9D 60                    rts   
3721 0F9E
3722 0F9E                       ENTRY GetPrevFree
3723 0F9E              GetPrevFree                             ;       
3724 0F9E
3725 0F9E E2 10                 sep   #$10                     ;8 bit index
3726 0FA0 A5 0F 85 13           move_l hndl1,hndl2             ;hndl2 = hndl1
3727 0FA8
3728 0FA8 A0 0C                 ldy   #hndl_prev               ;hndl1 = hndl2.prev
3729 0FAA B7 13                 lda   [hndl2],y
3730 0FAC 85 0F                 sta   hndl1
3731 0FAE A0 0E                 ldy   #hndl_prev+2
3732 0FB0 B7 13                 lda   [hndl2],y
3733 0FB2 85 11                 sta   hndl1+2
3734 0FB4 F0 E5                 beq   Done                     ;Br if hndl1 nil
3735 0FB6
3736 0FB6 A0 08                 ldy   #hndl_size               ;addr1 = addr+size
3737 0FB8 18                    clc   
3738 0FB9 B7 0F                 lda   [hndl1],y
3739 0FBB 67 0F                 adc   [hndl1]                  ;add addr
3740 0FBD 85 1B                 sta   addr1
3741 0FBF A0 0A                 ldy   #hndl_size+2
3742 0FC1 B7 0F                 lda   [hndl1],y
3743 0FC3 A0 02                 ldy   #hndl_addr+2
3744 0FC5 77 0F                 adc   [hndl1],y
3745 0FC7 85 1D                 sta   addr1+2
3746 0FC9
3747 0FC9 B7 13                 lda   [hndl2],y                ;addr2 = hndl2.addr
3748 0FCB 85 21                 sta   addr2+2                  ;Y = hndl_addr+2 from earlier
3749 0FCD A7 13                 lda   [hndl2]
3750 0FCF 85 1F                 sta   addr2
3751 0FD1              ;
3752 0FD1              ; If addr1 = addr2 then skip get the next one
3753 0FD1              ;
3754 0FD1 C5 1B                 cmp   addr1
3755 0FD3 D0 C5                 bne   AddrOK
3756 0FD5 A5 1D                 lda   addr1+2
3757 0FD7 C5 21                 cmp   addr2+2
3758 0FD9 D0 BF                 bne   AddrOK
3759 0FDB 80 C1                 bra   GetPrevFree
3760 0FDD
3761 0FDD                       ENDP 
3762 0FDD
3763 0FDD
3764 0FDD
3765 0FDD                       title ' Handle Creation'
3766 0FDD              ********************************************************************************
3767 0FDD              *
3768 0FDD              * CreateHandles - Makes a bunch of handles
3769 0FDD              *
3770 0FDD              * Inputs:      A = # handles to make max of 3275 ( one banks worth )
3771 0FDD              *
3772 0FDD              * Outputs:     C = 0 if unable to allocate handles
3773 0FDD              *              Y = Size of block in bytes
3774 0FDD              *
3775 0FDD              * Note: addr through addr2 are destroyed
3776 0FDD              *
3777 0FDD              * Calls go through $E1 vector
3778 0FDD              *
3779 0FDD              * Revision 2 change: Block is allocated with the id $00FF
3780 0FDD              *  Handles in free list have ID $FFFF
3781 0FDD              *
3782 0FDD              ********************************************************************************
3783 0FDD              XCreateHandles PROC 
3784 0FDD
3785 0FDD                       longa on
3786 0FDD                       longi on
3787 0FDD
3788 0FDD              ; First create a block to hold the handles
3789 0FDD 1A                    inc   A                        ;Add 1 for segment holding rest
3790 0FDE 0A                    asl   A                        ;Mult A by 20. 4 * A + 16 * A
3791 0FDF 0A                    asl   A
3792 0FE0 85 0B                 sta   size                     ;Temp
3793 0FE2 0A                    asl   A
3794 0FE3 0A                    asl   A
3795 0FE4 65 0B                 adc   size
3796 0FE6 85 0B                 sta   size                     ;This is the size to allocate
3797 0FE8 64 0D                 stz   size+2
3798 0FEA A9 08 D0              lda   #Attr_Locked+Attr_Fixed+Attr_Handle+Attr_NoSpec
3799 0FED 85 07                 sta   attr
3800 0FEF 22 90 16 E1           jsl   Search                   ;Go find one
3801 0FF3 90 5A                 bcc   Full                     ;Oh no!
3802 0FF5 A5 1B 85 17           move_l addr1,hndl              ;The first one is used to hold them all
3803 0FFD 20 84 0D              jsr   InsertHandle             ;Put it in used list
3804 1000 A9 FF 00              lda   #$00FF                   ;Make owner id $00FF
3805 1003 A0 06 00              ldy   #Hndl_Owner
3806 1006 97 17                 sta   [hndl],y
3807 1008
3808 1008
3809 1008              ; Now clear the handle info.  Hndl = beginning address of segment
3810 1008 A5 0B 85 1B           move_w size,addr1              ;and the size (high word 0)
3811 100C 64 03                 stz   addr                     ;Zero them out for free handles
3812 100E 64 05                 stz   addr+2
3813 1010 64 07                 stz   attr
3814 1012 64 0B                 stz   size
3815 1014 64 0D                 stz   size+2
3816 1016              ;
3817 1016              ;---------------------------------------------------
3818 1016              ; Last minute phone patch from Rich at 2 Mar 87
3819 1016              ; These lines are now in NewHandle
3820 1016              ;---------------------------------------------------
3821 1016              ;              lda     #$FFFF
3822 1016              ;              sta     owner
3823 1016              ;---------------------------------------------------
3824 1016              ; End of Last minute phone patch from Rich
3825 1016              ;---------------------------------------------------
3826 1016              ;
3827 1016              ; Now link them all together
3828 1016 A0 14 00              ldy   #HSize                   ;Start at the first one
3829 1019                       ENTRY DoHandle
3830 1019              DoHandle                                ; 
3831 1019
3832 1019              ; Calc previous handle
3833 1019 98                    tya                            ;Previous = hndl+Y-20
3834 101A 38                    sec   
3835 101B E9 14 00              sbc   #HSize                   ;No borrow possible
3836 101E 18                    clc   
3837 101F 65 17                 adc   hndl
3838 1021 85 0F                 sta   hndl1
3839 1023 A5 19                 lda   hndl+2
3840 1025 69 00 00              adc   #0
3841 1028 85 11                 sta   hndl1+2
3842 102A
3843 102A              ; Calc next handle
3844 102A 98                    tya                            ;Next = hndl+Y+20
3845 102B 18                    clc   
3846 102C 69 14 00              adc   #HSize                   ;Carry don't care
3847 102F 18                    clc   
3848 1030 65 17                 adc   hndl
3849 1032 85 13                 sta   hndl2
3850 1034 A5 19                 lda   hndl+2
3851 1036 69 00 00              adc   #0
3852 1039 85 15                 sta   hndl2+2
3853 103B
3854 103B              ; Move all of the bytes into the handle
3855 103B
3856 103B A2 00 00              ldx   #0
3857 103E B5 03        DoByte   lda   addr,x
3858 1040 97 17                 sta   [hndl],y
3859 1042 C8                    iny   
3860 1043 C8                    iny   
3861 1044 E8                    inx   
3862 1045 E8                    inx   
3863 1046 E0 14 00              cpx   #HSize                   ;Done all of handle?
3864 1049 90 F3                 blt   DoByte
3865 104B C4 1B                 cpy   addr1                    ;If Y = size then done
3866 104D 90 CA                 blt   DoHandle                 ;Exit with C = 1
3867 104F
3868 104F 6B           Full     rtl   
3869 1050
3870 1050                       ENDP 
3871 1050
3872 1050
3873 1050
3874 1050
3875 1050              ********************************************************************************
3876 1050              *
3877 1050              * VerifyHandle - Veriifies that an inputted handle is a real handle
3878 1050              *              to be valid:
3879 1050              *              Hndl <> nil
3880 1050              *              Hndl.prev.next = hndl or nil
3881 1050              *              if hndl.prev.next = nil then hndl must be head of a list
3882 1050              *
3883 1050              * inputs:      ParmHndl = handle to check
3884 1050              *
3885 1050              * outputs:     Hndl = handle
3886 1050              *              if invalid, return address popped and jumps to CleanUp
3887 1050              *
3888 1050              * VerifyH2 entry point from move routines Checks Z flag
3889 1050              *
3890 1050              ********************************************************************************
3891 1050              VerifyHandle PROC Export 
3892 1050                       longa on
3893 1050                       longi on
3894 1050
3895 1050 A5 2D                 lda   ParmHndl                 ;Get the inputted handle
3896 1052 85 17                 sta   Hndl
3897 1054 A5 2F                 lda   ParmHndl+2
3898 1056 85 19                 sta   Hndl+2
3899 1058
3900 1058                       ENTRY VerifyH2
3901 1058              VerifyH2                                ;       
3902 1058 F0 3C                 beq   BadHandle                ;If 0 then no good
3903 105A A0 0C 00              ldy   #Hndl_Prev               ;Get the previous
3904 105D B7 17                 lda   [hndl],y
3905 105F 85 0F                 sta   hndl1
3906 1061 C8                    iny   
3907 1062 C8                    iny   
3908 1063 B7 17                 lda   [hndl],y
3909 1065 85 11                 sta   hndl1+2
3910 1067 05 0F                 ora   hndl1                    ;Is there no previous?
3911 1069 F0 12                 beq   NoPrev
3912 106B A0 10 00              ldy   #Hndl_Next               ;Get the next of the previous
3913 106E B7 0F                 lda   [Hndl1],y
3914 1070 C5 17                 cmp   Hndl                     ;Is it = hndl?
3915 1072 D0 22                 bne   BadHandle
3916 1074 C8                    iny   
3917 1075 C8                    iny   
3918 1076 B7 0F                 lda   [Hndl1],y
3919 1078 C5 19                 cmp   Hndl+2
3920 107A D0 1A                 bne   BadHandle
3921 107C 60           HandleOK rts                            ;It was OK
3922 107D
3923 107D A2 08 00     NoPrev   ldx   #FreeList-MemList        ;Head of a list?
3924 1080 A5 17        HeadLoop lda   hndl
3925 1082 DF 00 16 E1           cmp   MemList,x
3926 1086 D0 08                 bne   NotHead
3927 1088 A5 19                 lda   hndl+2
3928 108A DF 02 16 E1           cmp   MemList+2,x
3929 108E F0 EC                 beq   HandleOK                 ;We Found it
3930 1090 CA           NotHead  dex   
3931 1091 CA                    dex   
3932 1092 CA                    dex   
3933 1093 CA                    dex   
3934 1094 10 EA                 bpl   HeadLoop                 ;Go try next list
3935 1096
3936 1096 A9 06 02     BadHandle lda   #HandleErr              ;Give back error
3937 1099 85 01                 sta   Error
3938 109B 68                    pla                            ;Pop return address
3939 109C 5C 8C 16 E1           jmp   CleanUp
3940 10A0
3941 10A0                       ENDP 
3942 10A0
3943 10A0
3944 10A0                       title ' BlockMove Routines'
3945 10A0              ********************************************************************************
3946 10A0              *
3947 10A0              * MoveData - Moves a block of data with multiple MVN or MVP operations
3948 10A0              *
3949 10A0              * Inputs:      Source: Source address
3950 10A0              *              Dest:   Destination address
3951 10A0              *              Count:  # Bytes to move
3952 10A0              *
3953 10A0              * Note No address checking is done to make sure move doesn't crash machine
3954 10A0              * The code for the move is pushed on the stack
3955 10A0              *
3956 10A0              * Rev 2 change: High byte of 4 byte address masked off
3957 10A0              *
3958 10A0              *
3959 10A0              * Call goes through $E1 vector
3960 10A0              *
3961 10A0              ********************************************************************************
3962 10A0              XMoveData PROC 
3963 10A0                       longa on
3964 10A0                       longi on
3965 10A0
3966 10A0              * Dec Count by 1 and return if no bytes to move
3967 10A0 A5 0B                 lda   Count
3968 10A2 D0 05                 bne   NoBor                    ;If 0 borrow from high byte
3969 10A4 C6 0D                 dec   Count+2                  ;Dec high word
3970 10A6 10 01                 bpl   NoBor                    ;0 bytes to move?
3971 10A8 6B                    rtl                            ;Br if so
3972 10A9 C6 0B        NoBor    dec   Count
3973 10AB
3974 10AB              * Check if source >= Destination
3975 10AB A6 03                 ldx   Source                   ;Low word of source
3976 10AD E4 07                 cpx   Dest                     ;Do the compare
3977 10AF A5 05                 lda   Source+2                 ;Now the high word
3978 10B1 E5 09                 sbc   Dest+2                   ;C = 1 if Source >= Dest
3979 10B3
3980 10B3 B0 6A                 bcs   MoveDown
3981 10B5
3982 10B5
3983 10B5
3984 10B5              ********************************************************************************
3985 10B5              *
3986 10B5              * MoveUP
3987 10B5              * This is used if Source <  Destination
3988 10B5              * inputs: X = >Source C = 0
3989 10B5              *
3990 10B5              ********************************************************************************
3991 10B5                       ENTRY MoveUp
3992 10B5              MoveUp                                  ; 
3993 10B5
3994 10B5              * Adjust Source = Source + Count and Dest = Dest + Count
3995 10B5              * Put move code in mem: MVP dst src RTL
3996 10B5 8A                    txa   
3997 10B6 65 0B                 adc   Count                    ;C = 0 from entry
3998 10B8 AA                    tax   
3999 10B9 A5 05                 lda   Source+2                 ;Get Source bank
4000 10BB 65 0D                 adc   Count+2                  ;A = 00bank
4001 10BD 29 FF 00              and   #$00FF                   ;Ignore high byte
4002 10C0 09 00 6B              ora   #$6B00                   ;RTL Opcode C = 0
4003 10C3 48                    pha                            ;Put it on the stack
4004 10C4 A5 0B                 lda   Count                    ;Calc Dest + Count
4005 10C6 85 13                 sta   TempCount                ;We'll need this later
4006 10C8 65 07                 adc   Dest
4007 10CA A8                    tay   
4008 10CB A5 0D                 lda   Count+2
4009 10CD 65 09                 adc   Dest+2                   ;A = 00bank
4010 10CF EB                    xba                            ;A = bank00
4011 10D0 09 44 00              ora   #$44                     ;MVP opcode
4012 10D3 48                    pha   
4013 10D4 80 14                 bra   muFirst
4014 10D6
4015 10D6 85 0D        MuMore   sta   Count+2                  ;More bytes to move
4016 10D8 A3 02                 lda   2,s                      ;A = srcdst banks
4017 10DA E0 FF FF              cpx   #$FFFF                   ;Was there a bank cross?
4018 10DD D0 03                 bne   muXNot0                  ;C = 1 if =
4019 10DF E9 00 01              sbc   #$0100                   ;Dec 1 from source bank better not wrap!
4020 10E2 C0 FF FF     muXNot0  cpy   #$FFFF                   ;Did destination cross bank?
4021 10E5 D0 01                 bne   muYIs0
4022 10E7 3A                    dec   A
4023 10E8 83 02        muYIs0   sta   2,s
4024 10EA
4025 10EA                       ENTRY muFirst
4026 10EA              muFirst                                 ; 
4027 10EA
4028 10EA E4 13                 cpx   TempCount                ;Will Source cross bank?
4029 10EC B0 02                 bcs   muXOk                    ;Br if no cross
4030 10EE 86 13                 stx   TempCount                ;Only move X bytes
4031 10F0 C4 13        muXOk    cpy   TempCount                ;Will destination cross bank?
4032 10F2 B0 02                 bcs   muYOk
4033 10F4 84 13                 sty   TempCount
4034 10F6 A9 11 FC     muYOk    lda   #(muReturn-1)>>8
4035 10F9 48                    pha                            ;Push return address
4036 10FA A9 00 06              lda   #(MuReturn-1)<<8         ;Low byte of ret addr and bank 0
4037 10FD 48                    pha   
4038 10FE 3B                    tsc   
4039 10FF 18                    clc                            ;Addr of code
4040 1100 69 04 00              adc   #4
4041 1103 48                    pha   
4042 1104 A5 13                 lda   TempCount                ;Get # bytes to move
4043 1106 6B                    rtl                            ;Takes us to the move code
4044 1107
4045 1107 A5 0B        muReturn lda   Count                    ;Count = Count - Bytes moved
4046 1109 18                    clc                            ;Actual bytes moved 1 more than count
4047 110A E5 13                 sbc   TempCount
4048 110C 85 0B                 sta   Count
4049 110E 85 13                 sta   TempCount
4050 1110 A5 0D                 lda   Count+2                  ;Now do high word
4051 1112 E9 00 00              sbc   #0
4052 1115 10 BF                 bpl   muMore                   ;Br if more to do
4053 1117 68                    pla                            ;Pull move code off of stack
4054 1118 68                    pla   
4055 1119 F4 E1 E1              pea   $E1E1                    ;Fix data bank
4056 111C AB                    plb   
4057 111D AB                    plb   
4058 111E 6B                    rtl   
4059 111F
4060 111F
4061 111F              ********************************************************************************
4062 111F              *
4063 111F              * MoveDown
4064 111F              * This is used if Source >= Destination
4065 111F              * inputs: X = >Source
4066 111F              *
4067 111F              ********************************************************************************
4068 111F                       ENTRY MoveDown
4069 111F              MoveDown                                ; 
4070 111F
4071 111F A4 07                 ldy   Dest
4072 1121              * First put move code in mem: MVN dst src RTL
4073 1121
4074 1121 A5 05                 lda   Source+2                 ;Get source bank
4075 1123 29 FF 00              and   #$00FF                   ;Ignore high byte
4076 1126 09 00 6B              ora   #$6B00                   ;RTL Opcode
4077 1129 48                    pha   
4078 112A A5 09                 lda   Dest+2                   ;Destination Bank
4079 112C EB                    xba   
4080 112D 09 54 00              ora   #$54                     ;MVN opcode
4081 1130 48                    pha   
4082 1131 A5 0B                 lda   Count                    ;Init TempCount
4083 1133 85 13                 sta   TempCount
4084 1135 80 14                 bra   mdFirst
4085 1137
4086 1137 85 0D        MdMore   sta   Count+2                  ;More bytes to move
4087 1139 A3 02                 lda   2,s                      ;A = SrcDest banks
4088 113B E0 01 00              cpx   #1                       ;Bank Cross?  if X=0
4089 113E B0 03                 bcs   mdXNot0
4090 1140 69 00 01              adc   #$0100                   ;Add 1 to source bank
4091 1143 C0 00 00     mdXNot0  cpy   #0                       ;Did destination cross bank?
4092 1146 D0 01                 bne   mdYIs0
4093 1148 1A                    inc   A
4094 1149 83 02        mdYIs0   sta   2,s
4095 114B
4096 114B                       ENTRY mdFirst
4097 114B              mdFirst                                 ; 
4098 114B 8A                    txa                            ;If Count > -X then bank cross
4099 114C 49 FF FF              eor   #$FFFF
4100 114F C5 13                 cmp   TempCount
4101 1151 B0 02                 bcs   MdXOk
4102 1153 85 13                 sta   TempCount                ;Only move -X bytes
4103 1155 98           mdXOk    tya                            ;Will destination cross bank?
4104 1156 49 FF FF              eor   #$FFFF
4105 1159 C5 13                 cmp   TempCount
4106 115B B0 02                 bcs   mdYOk
4107 115D 85 13                 sta   TempCount                ;Only move -Y bytes
4108 115F A9 11 FC     mdYOk    lda   #(mdReturn-1)>>8
4109 1162 48                    pha                            ;Push return address
4110 1163 A9 00 6F              lda   #(MdReturn-1)<<8         ;Low byte of ret addr and bank 0
4111 1166 48                    pha   
4112 1167 3B                    tsc   
4113 1168 18                    clc                            ;Addr of code
4114 1169 69 04 00              adc   #4
4115 116C 48                    pha   
4116 116D A5 13                 lda   TempCount                ;Get # bytes to move
4117 116F 6B                    rtl                            ;Takes us to the move code
4118 1170
4119 1170 A5 0B        mdReturn lda   Count                    ;Count = Count - Bytes moved
4120 1172 18                    clc                            ;Actual bytes moved 1 more than count
4121 1173 E5 13                 sbc   TempCount
4122 1175 85 0B                 sta   Count
4123 1177 85 13                 sta   TempCount
4124 1179 A5 0D                 lda   Count+2                  ;Now do high word
4125 117B E9 00 00              sbc   #0
4126 117E 10 B7                 bpl   mdMore                   ;Br if more to do
4127 1180 68                    pla                            ;Pop move code off of stack
4128 1181 68                    pla   
4129 1182 F4 E1 E1              pea   $E1E1
4130 1185 AB                    plb   
4131 1186 AB                    plb   
4132 1187 6B                    rtl   
4133 1188
4134 1188                       ENDP 
4135 1188
4136 1188
4137 1188                       Title ' Compaction Routines'
4138 1188              ********************************************************************************
4139 1188              *
4140 1188              * SearchFail - Called when unable to find a segment
4141 1188              *              This routine decides what sort of compaction, etc. to do
4142 1188              *              If in an interrupt, no compaction or purging is done.
4143 1188              *
4144 1188              *  So what does it do?
4145 1188              *
4146 1188              *  First, we looke at the IRQActive flag.  If we are inside an interrupt,
4147 1188              *  we must not move or dispose of anything.  We can only fail.
4148 1188              *
4149 1188              *  If we can try and make room we look at the retry count:
4150 1188              *
4151 1188              *     1:  Let User try
4152 1188              *     2:  Compact
4153 1188              *     3:  Purge Level 3's
4154 1188              *     4:  Purge Level 2's
4155 1188              *     5:  Purge Level 1's
4156 1188              *     6:  Let user try one last time.
4157 1188              *
4158 1188              *
4159 1188              *
4160 1188              * Output:      C = 1 if ok to retry
4161 1188              *
4162 1188              * Change History
4163 1188              *
4164 1188              * 1 Dec 88          Steven Glass
4165 1188              *
4166 1188              * Added call to clear recent in Level1 checking.  This prevents
4167 1188              * handles that are purged from being left in the recent list.
4168 1188              *
4169 1188              *
4170 1188              ********************************************************************************
4171 1188              XSearchFail PROC EXPORT
4172 1188                       longa on
4173 1188                       longi on
4174 1188
4175 1188                       import ClearRecent 
4176 1188              ;-----------------------------------------------------------
4177 1188              ;
4178 1188              ; First, see if we can even try to do anything.
4179 1188              ;
4180 1188 18                    clc   
4181 1189 AD CB 00              lda   |IrqActive               ;In an interrupt?
4182 118C 29 FF 00              and   #$00FF
4183 118F D0 48                 bne   GiveUp
4184 1191
4185 1191 E6 23                 inc   Retry                    ; bump the retry count and see how many times
4186 1193 A5 23                 lda   Retry                    ; we've been here
4187 1195 C9 07 00              cmp   #7
4188 1198 B0 3F                 bcs   GiveUp
4189 119A
4190 119A 0A                    asl   A
4191 119B AA                    tax   
4192 119C 7C 9F 11              jmp   (FailTable,x)
4193 119F
4194 119F
4195 119F 00 00        FailTable DC W:0
4196 11A1 AD 11                 DC W:FirstTry
4197 11A3 BB 11                 DC W:SecondTry
4198 11A5 C1 11                 DC W:ThirdTry
4199 11A7 C1 11                 DC W:FourthTry
4200 11A9 C1 11                 DC W:FifthTry
4201 11AB C7 11                 DC W:SixthTry
4202 11AD
4203 11AD              ;-----------------------------------------------------------
4204 11AD              ;
4205 11AD              ; Let the user try first.
4206 11AD              ;
4207 11AD              FirstTry  
4208 11AD 20 90 14              jsr   ClearRecent
4209 11B0 22 B4 16 E1           jsl   UserPurge
4210 11B4 90 01                 bcc   UserCouldNotHelp
4211 11B6 6B                    rtl   
4212 11B7
4213 11B7
4214 11B7              UserCouldNotHelp  
4215 11B7 E6 23                 inc   Retry                    ;Bump the retry count
4216 11B9 A5 23                 lda   Retry                    ; and fall into second try
4217 11BB
4218 11BB
4219 11BB              ;-----------------------------------------------------------
4220 11BB              ;
4221 11BB              ; This is the second time in, so we just compact and 
4222 11BB              ; try again.
4223 11BB              ;
4224 11BB              SecondTry  
4225 11BB 22 AC 16 E1           jsl   Compact
4226 11BF 38                    sec   
4227 11C0 6B                    rtl   
4228 11C1
4229 11C1
4230 11C1              ;-----------------------------------------------------------
4231 11C1              ;
4232 11C1              ; Third, fourth and fifth try:  We purge the level 3's, 
4233 11C1              ; 2's and 1's.
4234 11C1              ;
4235 11C1              ThirdTry  
4236 11C1              FourthTry  
4237 11C1              FifthTry  
4238 11C1 22 B0 16 E1           jsl   Purge                    ;Try purging
4239 11C5 B0 F4                 bcs   SecondTry                ;It may have worked, compact the result
4240 11C7
4241 11C7              ; Fall into Sixth Try
4242 11C7
4243 11C7
4244 11C7              ;-----------------------------------------------------------
4245 11C7              ;
4246 11C7              ; Egads, this is our last chance.  Call the user and 
4247 11C7              ; beg him to do something.
4248 11C7              ;
4249 11C7              SixthTry  
4250 11C7 22 B4 16 E1           jsl   UserPurge
4251 11CB 90 0C                 bcc   GiveUp
4252 11CD
4253 11CD              ;-----------------------------------------------------------
4254 11CD              ;
4255 11CD              ; Wow, the user thinks he can help us out.  So we go through and 
4256 11CD              ; purge everything that can be purged.  Compact memory one last time
4257 11CD              ; and try again.
4258 11CD              ;
4259 11CD F4 00 00              PushWord #0 
4260 11D0 A2 02 13 22           _PurgeAll 
4261 11D7
4262 11D7 80 E2                 bra   SecondTry
4263 11D9
4264 11D9              ; User could not do anything.  We must give up.  Return with the carry clear.
4265 11D9
4266 11D9 6B           GiveUp   rtl   
4267 11DA
4268 11DA                       ENDP 
4269 11DA
4270 11DA
4271 11DA
4272 11DA
4273 11DA
4274 11DA                       eject 
4275 11DA              ********************************************************************************
4276 11DA              *
4277 11DA              * Compact -    This routine attempts to move all memory blocks upwards
4278 11DA              *              Blocks that are fixed or locked are not moved
4279 11DA              *
4280 11DA              * Revision 2:  If compaction for fixed block in banks 0 or 1,
4281 11DA              *               only compact 0 and 1
4282 11DA              *
4283 11DA              ********************************************************************************
4284 11DA              XCompact PROC 
4285 11DA                       longa on
4286 11DA                       longi on
4287 11DA
4288 11DA 20 3C 0C              jsr   BestTop                  ;Get top to start from. Rev 2
4289 11DD
4290 11DD              * First move zero page down for a new temporary ZP.  Don't change X
4291 11DD 0B                    phd                            ;Save current ZP
4292 11DE 3B                    tsc   
4293 11DF 38                    sec   
4294 11E0 E9 24 00              sbc   #ZPSize
4295 11E3 1B                    tcs   
4296 11E4 5B                    tcd   
4297 11E5
4298 11E5              * Starting from the top of memory, go through all of the segments
4299 11E5 20 31 0C              jsr   StartXTop                ;X from best top
4300 11E8
4301 11E8              * to move to the next block, set the following
4302 11E8              * Hndl1      -> Hndl2
4303 11E8              * Hndl2.Prev -> Hndl1 if nil then done
4304 11E8              * Hndl1.Size -> Size
4305 11E8              * Hndl1.Owner-> Owner actually not needed but moved in loop
4306 11E8              * Hndl1.Attr -> Attr
4307 11E8              * Hndl1.Addr -> Addr, Addr1
4308 11E8              * Hndl2.Addr -> Addr2
4309 11E8
4310 11E8                       ENTRY NextBlock
4311 11E8              NextBlock                               ; 
4312 11E8 A5 0F 85 13           move_l Hndl1,Hndl2             ;Hndl1 -> Hndl2
4313 11F0 A0 0E 00              ldy   #hndl_prev+2             ;Hndl2.Prev -> Hndl1
4314 11F3 B7 13                 lda   [Hndl2],y
4315 11F5 85 11                 sta   Hndl1+2
4316 11F7 88                    dey   
4317 11F8 88                    dey   
4318 11F9 B7 13                 lda   [Hndl2],y
4319 11FB 85 0F                 sta   Hndl1
4320 11FD 05 11                 ora   Hndl1+2                  ;If Nil then done
4321 11FF F0 47                 beq   Done
4322 1201
4323 1201 88                    dey                            ;Move rest of Hndl1 data
4324 1202 88                    dey   
4325 1203 B7 0F        MvLoop1  lda   [Hndl1],y
4326 1205 BB                    tyx   
4327 1206 95 03                 sta   Addr,x
4328 1208 88                    dey   
4329 1209 88                    dey   
4330 120A C0 04 00              cpy   #hndl_attr               ;Move down through attr
4331 120D B0 F4                 bge   MvLoop1                  ;Exit loop with attr in A
4332 120F
4333 120F 89 00 C0              bit   #attr_locked+attr_fixed
4334 1212 D0 D4                 bne   NextBlock                ;Skip the block if it can't move
4335 1214
4336 1214 BB           MvLoop2  tyx   
4337 1215 B7 0F                 lda   [Hndl1],y                ;Now Move the addresses
4338 1217 95 03                 sta   addr,x
4339 1219 95 1B                 sta   addr1,x
4340 121B B7 13                 lda   [Hndl2],y
4341 121D 95 1F                 sta   addr2,x
4342 121F 88                    dey   
4343 1220 88                    dey   
4344 1221 10 F1                 bpl   MvLoop2
4345 1223
4346 1223              * Now check if the block can move
4347 1223 22 94 16 E1           jsl   CheckFit
4348 1227 A5 1B                 lda   addr1                    ;If addr <> addr1 then move it
4349 1229 C5 03                 cmp   addr
4350 122B D0 06                 bne   ItMoved
4351 122D A5 1D                 lda   addr1+2
4352 122F C5 05                 cmp   addr+2
4353 1231 F0 B5                 beq   NextBlock                ;No move, Go do the next Block
4354 1233
4355 1233              * Slide the block up Source = Addr, Count = Size (equivalent equates)
4356 1233              ItMoved                                 ; 
4357 1233 A5 1B                 lda   addr1                    ;Store new address in handle
4358 1235 87 0F                 sta   [Hndl1]
4359 1237 85 07                 sta   Dest                     ;Also set destination
4360 1239 A0 02 00              ldy   #hndl_addr+2
4361 123C A5 1D                 lda   addr1+2
4362 123E 97 0F                 sta   [Hndl1],y
4363 1240 85 09                 sta   Dest+2
4364 1242 22 A4 16 E1           jsl   MoveData                 ;Do the move. Hndl1 unchanged!!!!
4365 1246 80 A0                 bra   NextBlock
4366 1248
4367 1248              Done                                    ; 
4368 1248 3B                    tsc                            ;Pull the stack back up
4369 1249 18                    clc   
4370 124A 69 24 00              adc   #ZPSize
4371 124D 1B                    tcs   
4372 124E 2B                    pld                            ;And fix zero page
4373 124F 6B                    rtl   
4374 1250
4375 1250                       ENDP 
4376 1250
4377 1250
4378 1250              ********************************************************************************
4379 1250              *
4380 1250              * UserPurge - allows user to mark blocks purgeable
4381 1250              *
4382 1250              * This routine calls each of the installed OOM routines with telling them
4383 1250              * how much memory is needed.
4384 1250              *
4385 1250              * If enough total memory is freed, this routine returns carry set, 
4386 1250              * otherwise it returns carry clear.
4387 1250              *
4388 1250              * Inputs:
4389 1250              *          Size Of block needed
4390 1250              *
4391 1250              * Outputs:     
4392 1250              *          C = 1 if OK to repurge and compact
4393 1250              *          C = 0 if its not worth trying again
4394 1250              *
4395 1250              *
4396 1250              * Change History
4397 1250              *
4398 1250              * 10 Sep 88         Steven Glass
4399 1250              *
4400 1250              * This routine had always existed, but had never done anything until today.
4401 1250              *
4402 1250              * 02 Oct 88         Steven Glass
4403 1250              *
4404 1250              * This routine is now called before and after compact and purging.  The
4405 1250              * retry value is used to determine which it is.  When we are called first
4406 1250              * we only call user routines that have bit 0 set in the TaskFlags.
4407 1250              *
4408 1250              * When we are called second, we only call user routines that have bit 1
4409 1250              * set in the task flags.
4410 1250              *
4411 1250              * 16 Oct 88         Steven Glass
4412 1250              *
4413 1250              * We now call all routines all the time but we pass a retry count.  0 if
4414 1250              * this is before the memory manager has done anything.  1 if its later.
4415 1250              *
4416 1250              ********************************************************************************
4417 1250              XUserPurge PROC EXPORT
4418 1250                       longa on
4419 1250                       longi on
4420 1250
4421 1250                       DSect 0 
4422 1250              TaskLink LONG 
4423 1250              TaskFlags WORD 
4424 1250              TaskSignature WORD 
4425 1250              TaskEntry LONG 
4426 1250
4427 1250                       DefineStack 
4428 1250              OrigDirect word 
4429 1250              RetryValue word 
4430 1250              SizeNeeded LONG 
4431 1250              CurPtr   LONG 
4432 1250              AmountFreed LONG 
4433 1250
4434 1250 AD 3A 16              lda   |FirstOOMPtr+2           ; is there any?
4435 1253 AA                    tax                            ; copy in x for below
4436 1254 0D 38 16              ora   |FirstOOMPtr
4437 1257 D0 02                 bne   GoAndTry
4438 1259
4439 1259 18                    clc   
4440 125A 6B                    rtl   
4441 125B
4442 125B              GoAndTry  
4443 125B 48                    pha                            ; push space for the space freed
4444 125C 48                    pha   
4445 125D DA                    phx                            ; push the pointer to the first header
4446 125E AD 38 16              lda   |FirstOOMPtr
4447 1261 48                    pha   
4448 1262 D4 0D                 pei   Size+2                   ; push the size needed
4449 1264 D4 0B                 pei   Size
4450 1266 D4 23                 pei   Retry
4451 1268 0B                    phd                            ; push d-page
4452 1269 3B                    tsc                            ; turn stack to d-page
4453 126A 5B                    tcd   
4454 126B
4455 126B
4456 126B 64 0D                 stz   AmountFreed              ; zero the amount we freed
4457 126D 64 0F                 stz   AmountFreed+2
4458 126F
4459 126F              ;-----------------------------------------------------------
4460 126F              ;
4461 126F              ; Reset Retry value to 1 or 2 depending or its original
4462 126F              ; value.  This way we can use the RetryValue as a mask
4463 126F              ; to decide which routines to run.
4464 126F              ;
4465 126F A2 00 00              ldx   #$0000
4466 1272 A5 03                 lda   RetryValue
4467 1274 C9 01 00              cmp   #1
4468 1277 F0 03                 beq   @1
4469 1279 A2 01 00              ldx   #1
4470 127C 86 03        @1       stx   RetryValue
4471 127E
4472 127E              NextOne   
4473 127E
4474 127E 48                    pha   
4475 127F 48                    pha   
4476 1280 D4 07                 pei   SizeNeeded+2
4477 1282 D4 05                 pei   SizeNeeded
4478 1284 D4 03                 pei   RetryValue
4479 1286 22 C0 12 FC           jsl   CallThisOne
4480 128A
4481 128A 68                    pla   
4482 128B 18                    clc   
4483 128C 65 0D                 adc   AmountFreed
4484 128E 85 0D                 sta   AmountFreed
4485 1290 68                    pla   
4486 1291 65 0F                 adc   AmountFreed+2
4487 1293 85 0F                 sta   AmountFreed+2
4488 1295
4489 1295              ;-----------------------------------------------------------
4490 1295              ;
4491 1295              ; Point to next one.
4492 1295              ;
4493 1295              SkipThisOne  
4494 1295 A7 09                 lda   [CurPtr]
4495 1297 AA                    tax   
4496 1298 A0 02 00              ldy   #2
4497 129B B7 09                 lda   [CurPtr],y
4498 129D 85 0B                 sta   CurPtr+2
4499 129F 86 09                 stx   CurPtr
4500 12A1 05 09                 ora   CurPtr
4501 12A3 D0 D9                 bne   NextOne
4502 12A5
4503 12A5
4504 12A5              ;-----------------------------------------------------------
4505 12A5              ;
4506 12A5              ; Was enough freed?
4507 12A5              ;
4508 12A5              ;
4509 12A5              ; 3/31/89           Mensch
4510 12A5              ; Correct the following compare...
4511 12A5              ; was:
4512 12A5              ;	lda	SizeNeeded
4513 12A5              ;	sec
4514 12A5              ;	sbc	AmountFreed
4515 12A5              ;	lda	SizeNeeded+2
4516 12A5              ;	sbc	AmountFreed+2
4517 12A5              ;	bcc	Enough
4518 12A5              ;	beq	Enough
4519 12A5              ;
4520 12A5              ; Compare sizeNeeded to amount freed as follows...
4521 12A5              ;  If SizeNeeded+2 < AmountFreed+2 then enough;
4522 12A5              ;  If SizeNeeded+2 = AmountFreed+2 then 
4523 12A5              ;    If AmountFreed >= SizeNeeded then enough
4524 12A5              ;      else @TooSmall;
4525 12A5              ;    else @TooSmall;
4526 12A5              ;
4527 12A5 A5 07                 lda   SizeNeeded+2             ; first test to see if we freed way to much
4528 12A7 C5 0F                 cmp   AmountFreed+2            ; by comparing the high words...
4529 12A9 90 0B                 blt   Enough                   ; if its less than amount freed, we have more than enough memory
4530 12AB D0 06                 bne   @TooSmall                ; if on the other hand, size needed is not
4531 12AD              ; SizeNeeded+2 = AmountNeeded+2 here
4532 12AD A5 0D                 lda   AmountFreed
4533 12AF C5 05                 cmp   SizeNeeded
4534 12B1 B0 03                 bge   Enough                   ; if Amount>=SizeNeeded then we got enough
4535 12B3
4536 12B3              @TooSmall  
4537 12B3 18                    clc   
4538 12B4 80 01                 bra   FixStack
4539 12B6
4540 12B6
4541 12B6              Enough    
4542 12B6 38                    sec   
4543 12B7              ;-----------------------------------------------------------
4544 12B7              ;
4545 12B7              ; Fix the stack and get out.
4546 12B7              ;
4547 12B7 2B           FixStack pld                            ; pull d-page
4548 12B8 68                    pla                            ; pull retry value
4549 12B9 68                    pla                            ; pull Size
4550 12BA 68                    pla   
4551 12BB 68                    pla                            ; pull OOM Pointer
4552 12BC 68                    pla   
4553 12BD 68                    pla                            ; pull Amount freed
4554 12BE 68                    pla   
4555 12BF 6B                    rtl                            ; all done
4556 12C0
4557 12C0
4558 12C0
4559 12C0              ;-----------------------------------------------------------
4560 12C0              ;
4561 12C0              ; Little routine to check the signature and 
4562 12C0              ; call the routine.
4563 12C0              ;
4564 12C0 A0 06 00     CallThisOne ldy   #TaskSignature
4565 12C3 B7 09                 lda   [CurPtr],y
4566 12C5 C9 5A A5              cmp   #QueueSignature
4567 12C8 D0 0D                 bne   Die
4568 12CA
4569 12CA A5 09                 lda   CurPtr
4570 12CC 18                    clc   
4571 12CD 69 08 00              adc   #TaskEntry
4572 12D0 D4 0A                 pei   CurPtr+1
4573 12D2 8B                    phb   
4574 12D3 3A                    dec   a
4575 12D4 83 01                 sta   1,s
4576 12D6
4577 12D6 6B                    rtl   
4578 12D7
4579 12D7 F4 09 02     Die      PushWord #OOMQueueDamaged 
4580 12DA F4 00 00 F4           PushLong #0 
4581 12E0 A2 03 15 22           _SysFailMgr 
4582 12E7
4583 12E7
4584 12E7                       ENDP 
4585 12E7
4586 12E7
4587 12E7              ****************************************************************
4588 12E7              *
4589 12E7              AddToOOMQueue PROC EXPORT
4590 12E7              *
4591 12E7              * Adds the specified routine to the list of routines that are
4592 12E7              * run when the memory manager runs out of memory.
4593 12E7              *
4594 12E7              * Possible Errors:
4595 12E7              *
4596 12E7              * InvalidHeader
4597 12E7              *
4598 12E7              *
4599 12E7              * Inputs:
4600 12E7              *                   PointerToHeader
4601 12E7              *
4602 12E7              * Outputs:
4603 12E7              *                   none
4604 12E7              *
4605 12E7              * External Refs:
4606 12E7              *                   none
4607 12E7              *
4608 12E7              * Entry Points:
4609 12E7              *                   none
4610 12E7              *
4611 12E7                       longa on                       ; mode
4612 12E7                       longi on
4613 12E7              *
4614 12E7              ****************************************************************
4615 12E7
4616 12E7 22 88 16 E1           jsl   link
4617 12EB D4 2F                 pei   Parms+2
4618 12ED D4 2D                 pei   Parms
4619 12EF F4 E1 00              pea   FirstOOMPtr>>16
4620 12F2 F4 38 16              pea   |FirstOOMPtr
4621 12F5 A2 03 2E 22           _AddToQueue 
4622 12FC 85 01                 sta   error                    ; pass on error code if any to the cleanup routines 
4623 12FE
4624 12FE 5C 8C 16 E1           jml   CleanUp
4625 1302
4626 1302                       ENDP 
4627 1302
4628 1302
4629 1302              ****************************************************************
4630 1302              *
4631 1302              DeleteFromOOMQueue PROC EXPORT
4632 1302              *
4633 1302              * Removes the specified routine to the list of routines that are
4634 1302              * run when the memory manager runs out of memory.
4635 1302              *
4636 1302              * Possible Errors:
4637 1302              *
4638 1302              * InvalidHeader
4639 1302              * NotInQueue
4640 1302              *
4641 1302              * Inputs:
4642 1302              *                   PointerToHeader
4643 1302              *
4644 1302              * Outputs:
4645 1302              *                   none
4646 1302              *
4647 1302              * External Refs:
4648 1302              *                   none
4649 1302              *
4650 1302              * Entry Points:
4651 1302              *                   none
4652 1302              *
4653 1302                       longa on                       ; mode
4654 1302                       longi on
4655 1302              *
4656 1302              ****************************************************************
4657 1302
4658 1302
4659 1302 22 88 16 E1           jsl   link
4660 1306
4661 1306 D4 2F                 pei   Parms+2
4662 1308 D4 2D                 pei   Parms
4663 130A F4 E1 00              pea   FirstOOMPtr>>16
4664 130D F4 38 16              pea   |FirstOOMPtr
4665 1310 A2 03 2F 22           _DeleteFromQueue 
4666 1317 85 01                 sta   error                    ; pass on error code if any to the cleanup routines 
4667 1319
4668 1319 5C 8C 16 E1           jml   CleanUp
4669 131D
4670 131D
4671 131D                       ENDP 
4672 131D
4673 131D                       title ' Purge Routines'
4674 131D              ********************************************************************************
4675 131D              *
4676 131D              * XPurge - purges blocks from memory until size bytes have been freed
4677 131D              *
4678 131D              *           Yea from the table of my memory
4679 131D              *           I'll sweep away all trivial fond records
4680 131D              *           Shakespeare, Hamlet, I. v. 96
4681 131D              *
4682 131D              * Inputs:      Size = block we are trying to allocate
4683 131D              *              Retry =  retry count
4684 131D              *           2 = purge level 3 (zombies)
4685 131D              *           3 = purge level 2
4686 131D              *           4 = purge level 1
4687 131D              *          >4 = nothing left to purge
4688 131D              *
4689 131D              * Outputs:     C = 1 if OK to retry
4690 131D              *              Retry = next retry count - 1 (its inced before we're called)
4691 131D              *
4692 131D              * ZP used:     hndl1, hndl2, addr1, addr2 rest unchanged
4693 131D              *
4694 131D              * Revision 2:  Now in the rom
4695 131D              *              If Purging for fixed address in banks 0 or 1
4696 131D              *               routine only purges out of 0 and 1
4697 131D              *
4698 131D              *
4699 131D              * Change History
4700 131D              *
4701 131D              * 16 Oct 88         Steven Glass
4702 131D              *
4703 131D              * Changed in line constants to equates for LastRetry and ZombieRetry.
4704 131D              * These had to change when I changed the SearchFail routine to call the
4705 131D              * user before doing other things.  This meant that retry was much high
4706 131D              * when this routine was called.
4707 131D              *
4708 131D              ********************************************************************************
4709 131D              XPurge   PROC EXPORT
4710 131D                       longa on
4711 131D                       longi on
4712 131D
4713 131D              * Local equates
4714 131D              PHndl    equ   addr1                    ;Handle being checked to purge
4715 131D              PSize    equ   addr2                    ;# bytes to purge
4716 131D
4717 131D
4718 131D              LastRetry equ 6 
4719 131D              ZombieRetry equ 3 
4720 131D
4721 131D              * If retry > LastRetry then we can't purge any more
4722 131D A5 23                 lda   Retry
4723 131F C9 06 00              cmp   #LastRetry               ;A has retry count
4724 1322 90 02                 bcc   RetryOK
4725 1324 18                    clc   
4726 1325 6B                    rtl   
4727 1326
4728 1326 A6 0B        RetryOK  ldx   size                     ;Get the size to purge
4729 1328 86 1F                 stx   PSize
4730 132A A6 0D                 ldx   size+2
4731 132C 86 21                 stx   PSize+2
4732 132E              *
4733 132E              * To start, hndl2 = top block which isn't purgeable
4734 132E              *           phndl = next down which might be
4735 132E              *
4736 132E                       ENTRY StartTop
4737 132E              StartTop                                ; 
4738 132E C2 10                 rep   #$10                     ;StartTop needs 16 bit X
4739 1330 20 3C 0C              jsr   BestTop                  ;Find the best top to start from
4740 1333 E2 10                 sep   #$10                     ;ldy # faster than dey dey
4741 1335                       longi off
4742 1335 BD 00 16              lda   |MemList,x               ;Only need the low 8 bits from besttop
4743 1338 85 1B                 sta   phndl
4744 133A BD 02 16              lda   |MemList+2,x
4745 133D 85 1D                 sta   phndl+2
4746 133F A0 0E                 ldy   #hndl_prev+2             ;Get next down
4747 1341 B7 1B                 lda   [phndl],y
4748 1343 85 11                 sta   hndl1+2
4749 1345 A0 0C                 ldy   #hndl_prev
4750 1347 B7 1B                 lda   [phndl],y
4751 1349 85 0F                 sta   hndl1
4752 134B
4753 134B
4754 134B 20 A3 13     PurgeLoop jsr   NextPurge               ;Get next purgable block
4755 134E 90 48                 bcc   EndOfList
4756 1350
4757 1350 20 F1 13              jsr   NukeIt                   ;Purge the block
4758 1353 A5 23                 lda   retry                    ;Killing zombies
4759 1355 C9 03 00              cmp   #ZombieRetry
4760 1358 F0 0E                 beq   KillZombies              ;If killing zombies, then get the rest
4761 135A A5 13                 lda   hndl2                    ;hndl2 -> phndl to make NextPurge work
4762 135C 85 1B                 sta   phndl
4763 135E A5 15                 lda   hndl2+2
4764 1360 85 1D                 sta   phndl+2
4765 1362 A5 21                 lda   psize+2                  ;Need to purge any more?
4766 1364 10 E5                 bpl   PurgeLoop
4767 1366 80 2A                 bra   Done
4768 1368
4769 1368              *
4770 1368              * Here we purge the rest of the zombies of the same owner
4771 1368              *
4772 1368 A0 06        KillZombies ldy   #hndl_owner           ;Get the owner
4773 136A B7 1B                 lda   [phndl],y
4774 136C 29 FF F0              and   #$F0FF                   ;Mask off aux id
4775 136F 48                    pha   
4776 1370                       ENTRY ZombieLoop
4777 1370              ZombieLoop                              ; 
4778 1370 A5 13                 lda   hndl2                    ;hndl2 -> phndl to make NextPurge work
4779 1372 85 1B                 sta   phndl
4780 1374 A5 15                 lda   hndl2+2
4781 1376 85 1D                 sta   phndl+2
4782 1378 20 A3 13     ZombieSkip jsr   NextPurge
4783 137B 90 10                 bcc   LastZombie
4784 137D A0 06                 ldy   #hndl_owner              ;Get owner
4785 137F B7 1B                 lda   [phndl],y
4786 1381 29 FF F0              and   #$F0FF
4787 1384 C3 01                 cmp   1,s                      ;Is it the one we want?
4788 1386 D0 F0                 bne   ZombieSkip               ;Skip it if not
4789 1388 20 F1 13              jsr   NukeIt                   ;Purge it
4790 138B 80 E3                 bra   ZombieLoop
4791 138D
4792 138D 68           LastZombie pla                          ;All of owner purged. fix the stack
4793 138E A5 1F                 lda   psize                    ;Purged enough?
4794 1390 10 9C                 bpl   StartTop                 ;Start again if not
4795 1392
4796 1392
4797 1392              * Hooray, we urged enough
4798 1392
4799 1392              Done                                    ; 
4800 1392 C6 23                 dec   Retry                    ;It will be inced before we are called
4801 1394 C2 10                 rep   #$10
4802 1396 38                    sec   
4803 1397 6B                    rtl   
4804 1398
4805 1398                       ENTRY EndOfList
4806 1398              EndOfList                               ; 
4807 1398 E6 23                 inc   Retry                    ;Go to next level
4808 139A A5 23                 lda   Retry
4809 139C C9 06 00              cmp   #LastRetry
4810 139F 90 8D                 bcc   StartTop                 ;if <= LastRetry then start another pass
4811 13A1 80 EF                 bra   Done                     ;Other wise try what we have
4812 13A3
4813 13A3
4814 13A3              ********************************************************************************
4815 13A3              *
4816 13A3              * NextPurge - Finds next purgable block
4817 13A3              *
4818 13A3              * To get to the next:   phndl -> hndl2
4819 13A3              *                       hndl1 -> hndl
4820 13A3              *                       phndl.prev -> hndl1 if nil then done
4821 13A3              *
4822 13A3              * outputs: C = 0 then end of list
4823 13A3              *
4824 13A3              ********************************************************************************
4825 13A3                       ENTRY NextPurge
4826 13A3              NextPurge                               ; 
4827 13A3                       longa on
4828 13A3                       longi off
4829 13A3
4830 13A3 A6 23                 ldx   Retry                    ;Make mask for purging
4831 13A5 BF EA 13 FC           lda   >Purgemask-ZombieRetry-1,x
4832 13A9 29 00 FF              and   #$FF00
4833 13AC 48                    pha                            ;Save it on the stack
4834 13AD
4835 13AD                       ENTRY Loop
4836 13AD              Loop                                    ; 
4837 13AD A5 1B 85 13           move_l phndl,hndl2
4838 13B5 A5 0F 85 1B           move_l hndl1,phndl
4839 13BD A0 0E                 ldy   #hndl_prev+2
4840 13BF B7 1B                 lda   [phndl],y
4841 13C1 85 11                 sta   hndl1+2
4842 13C3 A0 0C                 ldy   #hndl_prev
4843 13C5 B7 1B                 lda   [phndl],y
4844 13C7 85 0F                 sta   hndl1
4845 13C9 05 11                 ora   hndl1+2                  ;= nil?
4846 13CB F0 1E                 beq   IsNil                    ;Br if so
4847 13CD
4848 13CD A5 07                 lda   attr                     ;If No spec allowed
4849 13CF 89 08 00              bit   #attr_nospec
4850 13D2 F0 07                 beq   CheckIt
4851 13D4 A0 02                 ldy   #hndl_addr+2             ;Then stop if in bank1
4852 13D6 B7 1B                 lda   [phndl],y
4853 13D8 4A                    lsr   A                        ;= 0 if bank 0 or 1
4854 13D9 F0 10                 beq   IsNil
4855 13DB
4856 13DB              * Now check if we can purge it
4857 13DB A0 04        CheckIt  ldy   #hndl_attr               ;Get the attributes
4858 13DD B7 1B                 lda   [phndl],y
4859 13DF 30 CC                 bmi   Loop                     ;Skip if locked
4860 13E1 29 00 03              and   #attr_purge              ;Purgable?
4861 13E4 C3 01                 cmp   1,s
4862 13E6 90 C5                 bcc   Loop                     ;Br if < level we are looking for
4863 13E8
4864 13E8 38                    sec                            ;Found one
4865 13E9 68                    pla   
4866 13EA 60                    rts   
4867 13EB
4868 13EB 18           IsNil    clc   
4869 13EC 68                    pla   
4870 13ED 60                    rts   
4871 13EE
4872 13EE                       ENTRY PurgeMask
4873 13EE 03 02 01     PurgeMask DC B:3,2,1
4874 13F1
4875 13F1
4876 13F1
4877 13F1
4878 13F1              ********************************************************************************
4879 13F1              *
4880 13F1              * NukeIt - Purges the block
4881 13F1              * Here we purge the block. Since it is purgable, hndl1 & hndl2 aren't nil
4882 13F1              * To purge hndl:     hndl2 -> hndl1.next
4883 13F1              *                       hndl1 -> hndl2.prev    This removes hndl from the list
4884 13F1              *                       PurgeList -> phndl.next
4885 13F1              *                       nil   -> phndl.prev
4886 13F1              *                       phndl -> PurgeList.prev
4887 13F1              *                       phndl -> PurgeList
4888 13F1              *                       nil   -> phndl.addr    This purges hndl
4889 13F1              *
4890 13F1              *                       psize - phndl.size -> psize
4891 13F1              *
4892 13F1              * notes: A pointer to the current head of purgelist is put on the stack
4893 13F1              *
4894 13F1              ********************************************************************************
4895 13F1                       ENTRY NukeIt
4896 13F1              NukeIt                                  ; 
4897 13F1                       longa on
4898 13F1                       longi off
4899 13F1
4900 13F1 8B                    phb   
4901 13F2 A0 10                 ldy   #hndl_next
4902 13F4 A5 13                 lda   hndl2
4903 13F6 97 0F                 sta   [hndl1],y
4904 13F8 AD 04 16              lda   |PurgeList
4905 13FB 48                    pha                            ;Save for stack based pointer
4906 13FC 97 1B                 sta   [phndl],y                ;Attach rest of purge list to phndl
4907 13FE A0 12                 ldy   #hndl_next+2             ;Remove it from used list
4908 1400 A5 15                 lda   hndl2+2                  ;hndl2 -> hndl1.next
4909 1402 97 0F                 sta   [hndl1],y
4910 1404 AD 06 16              lda   |PurgeList+2             ;Attach rest of purge list to phndl
4911 1407 97 1B                 sta   [phndl],y
4912 1409 A8                    tay                            ;Y = bank of head of purgelist
4913 140A 5A                    phy   
4914 140B
4915 140B A0 0E                 ldy   #hndl_prev+2             ;hndl1 -> hndl2.prev
4916 140D A5 11                 lda   hndl1+2
4917 140F 97 13                 sta   [hndl2],y
4918 1411 A0 0C                 ldy   #hndl_prev
4919 1413 A5 0F                 lda   hndl1
4920 1415 97 13                 sta   [hndl2],y
4921 1417
4922 1417 A9 00 00              lda   #0                       ;nil -> phndl.prev
4923 141A 97 1B                 sta   [phndl],y
4924 141C A0 0E                 ldy   #hndl_prev+2
4925 141E 97 1B                 sta   [phndl],y
4926 1420 A0 02                 ldy   #hndl_addr+2             ;nil -> hndl.addr
4927 1422 97 1B                 sta   [phndl],y
4928 1424 87 1B                 sta   [phndl]
4929 1426
4930 1426 A5 1D                 lda   phndl+2                  ;hndl -> PurgeList
4931 1428 8D 06 16              sta   |PurgeList+2
4932 142B A5 1B                 lda   phndl
4933 142D 8D 04 16              sta   |PurgeList
4934 1430
4935 1430 AB                    plb                            ;phndl -> OldPurgeList.prev
4936 1431 A0 0C                 ldy   #hndl_prev
4937 1433 93 01                 sta   (1,s),y
4938 1435 A5 1D                 lda   phndl+2
4939 1437 A0 0E                 ldy   #hndl_prev+2
4940 1439 93 01                 sta   (1,s),y
4941 143B 68                    pla                            ;Fix stack
4942 143C AB                    plb                            ;and bank
4943 143D
4944 143D              * Now subtract amount+1 purged from total needed
4945 143D A0 08                 ldy   #hndl_size
4946 143F A5 1F                 lda   psize
4947 1441 18                    clc                            ;Extra -1 so just the right size will
4948 1442 F7 1B                 sbc   [phndl],y                ;go minus instead of 0
4949 1444 85 1F                 sta   psize
4950 1446 A0 0A                 ldy   #hndl_size+2
4951 1448 A5 21                 lda   psize+2
4952 144A F7 1B                 sbc   [phndl],y
4953 144C 85 21                 sta   psize+2
4954 144E
4955 144E 60                    rts   
4956 144F
4957 144F
4958 144F
4959 144F                       ENDP 
4960 144F
4961 144F
4962 144F
4963 144F
4964 144F              ****************************************************************
4965 144F              *
4966 144F              CheckRecent PROC EXPORT
4967 144F              *
4968 144F              * Checks the handle in hndl and sees if it is one of the
4969 144F              * last allocated handles that we keep to speed up searching
4970 144F              *
4971 144F              * If it is we replace the lastfound handle with its prior or
4972 144F              * next handle.
4973 144F              *
4974 144F              *
4975 144F              * Inputs:
4976 144F              *                   hndl
4977 144F              *                   LastLowHandle
4978 144F              *                   LastHighHandle
4979 144F              *
4980 144F              * Outputs:
4981 144F              *                   LastLowHandle
4982 144F              *                   LastHighHandle
4983 144F              *
4984 144F              * External Refs:
4985 144F              *                   none
4986 144F              *
4987 144F              * Entry Points:
4988 144F              *                   none
4989 144F              *
4990 144F                       longa on                       ; mode
4991 144F                       longi on
4992 144F              *
4993 144F              * Change History
4994 144F              *
4995 144F              * 06 Nov 88         Steven Glass
4996 144F              *
4997 144F              * To try and improve our shortcut hit rate, i've changed
4998 144F              * what we do when the handle being removed is the recent
4999 144F              * handle.  I make the recent handle equal to the prior or
5000 144F              * next handle.
5001 144F              *
5002 144F              * 30 Nov 88         Steven Glass
5003 144F              *
5004 144F              * Must make sure that the handle we are looking for is 
5005 144F              * real.  Had problem when zero was passed to dispose and 
5006 144F              * the recent handle value was 0.
5007 144F              *
5008 144F              ****************************************************************
5009 144F A5 19                 lda   hndl+2
5010 1451 F0 3C                 beq   @Continue
5011 1453
5012 1453 CD 2A 16              cmp   |LastLowHandle+2
5013 1456 D0 19                 bne   @NotLow
5014 1458 A5 17                 lda   hndl
5015 145A CD 28 16              cmp   |LastLowHandle
5016 145D D0 12                 bne   @NotLow
5017 145F
5018 145F A0 0C 00              ldy   #Hndl_Prev               ; since this one is going away, get replace it with prior
5019 1462 B7 17                 lda   [hndl],y
5020 1464 8D 28 16              sta   |LastLowHandle
5021 1467 A0 0E 00              ldy   #Hndl_Prev+2
5022 146A B7 17                 lda   [hndl],y
5023 146C 8D 2A 16              sta   |LastLowHandle+2
5024 146F 80 1E                 bra   @Continue
5025 1471
5026 1471 A5 17        @NotLow  lda   hndl
5027 1473 CD 2C 16              cmp   |LastHighHandle
5028 1476 D0 17                 bne   @Continue
5029 1478 A5 19                 lda   hndl+2
5030 147A CD 2E 16              cmp   |LastHighHandle+2
5031 147D D0 10                 bne   @Continue
5032 147F
5033 147F A0 10 00              ldy   #Hndl_Next               ; since this one is going away, get replace it with next
5034 1482 B7 17                 lda   [hndl],y
5035 1484 8D 2C 16              sta   |LastHighHandle
5036 1487 A0 12 00              ldy   #Hndl_Next+2
5037 148A B7 17                 lda   [hndl],y
5038 148C 8D 2E 16              sta   |LastHighHandle+2
5039 148F
5040 148F              @Continue  
5041 148F              ;-----------------------------------------------------------
5042 148F
5043 148F
5044 148F 60                    rts   
5045 1490
5046 1490
5047 1490                       ENDP 
5048 1490
5049 1490              ****************************************************************
5050 1490              *
5051 1490              ClearRecent PROC 
5052 1490              *
5053 1490              * Zeros the values in LastLowHandle and LastHighHandle
5054 1490              *
5055 1490              * Inputs:
5056 1490              *                   none
5057 1490              *
5058 1490              * Outputs:
5059 1490              *                   none
5060 1490              *
5061 1490              * External Refs:
5062 1490              *                   none
5063 1490              *
5064 1490              * Entry Points:
5065 1490              *                   none
5066 1490              *
5067 1490                       longa on                       ; mode
5068 1490                       longi on
5069 1490              *
5070 1490              ****************************************************************
5071 1490
5072 1490 A9 00 00              lda   #0
5073 1493 8F 28 16 E1           sta   >LastLowHandle
5074 1497 8F 2A 16 E1           sta   >LastLowHandle+2
5075 149B 8F 2C 16 E1           sta   >LastHighHandle
5076 149F 8F 2E 16 E1           sta   >LastHighHandle+2
5077 14A3
5078 14A3
5079 14A3 60                    rts   
5080 14A4
5081 14A4
5082 14A4                       ENDP 
5083 14A4
5084 14A4
5085 14A4                       title ' RamDisk Command routines'
5086 14A4              ********************************************************************************
5087 14A4              *
5088 14A4              * GetDiskSize - Returns the current size of the RamDisk
5089 14A4              *
5090 14A4              ********************************************************************************
5091 14A4              GetDiskSize PROC 
5092 14A4                       longa on
5093 14A4                       longi on
5094 14A4
5095 14A4 AF 42 16 E1           lda   >CurDiskSize
5096 14A8 83 07                 sta   7,s
5097 14AA AF 44 16 E1           lda   >curDiskSize+2
5098 14AE 83 09                 sta   9,s
5099 14B0 4C E9 01              jmp   QuickExit
5100 14B3
5101 14B3                       ENDP 
5102 14B3
5103 14B3
5104 14B3
5105 14B3                       title 'Routines for making the disk'
5106 14B3                       eject 
5107 14B3              ********************************************************************************
5108 14B3              *
5109 14B3              * MakeDisk - Creates a single handle for the ramdisk memory
5110 14B3              *
5111 14B3              * Outputs:     C=1 if failed  C=0 if Succeeded
5112 14B3              *
5113 14B3              ********************************************************************************
5114 14B3              MakeDisk PROC 
5115 14B3                       longa on
5116 14B3                       longi on
5117 14B3
5118 14B3 9C 42 16              stz   |CurDiskSize             ;Zero things out
5119 14B6 9C 44 16              stz   |CurDiskSize+2
5120 14B9 9C 46 16              stz   |DiskHandles
5121 14BC 9C 48 16              stz   |DiskHandles+2
5122 14BF 9C 4A 16              stz   |FormatFlag              ;Mark Unformatted
5123 14C2              * First get the TotalMem size
5124 14C2 F4 00 00 F4           pushlong #0000 
5125 14C8 A2 02 1D 22           _TotalMem 
5126 14CF 68                    pla   
5127 14D0 68                    pla                            ;a = 64K banks of RAM
5128 14D1
5129 14D1              * Get maximum size.  If > available then use the max available
5130 14D1                       longa off
5131 14D1                       longi off
5132 14D1 E2 30                 sep   #$30
5133 14D3 3A                    dec   A                        ;-2 since 0 & 1 not used for ram disk
5134 14D4 3A                    dec   A
5135 14D5 0A                    asl   A                        ;A = # 32K chunks available
5136 14D6 CD F7 02              cmp   |MaxDiskParm             ;Is it less than requested?
5137 14D9 90 03                 blt   TooBig                   ;Br if requested size is too big
5138 14DB AD F7 02              lda   |MaxDiskParm             ;Use the requested size
5139 14DE AA           TooBig   tax                            ;This clears the high byte
5140 14DF C2 30                 rep   #$30
5141 14E1                       longa on
5142 14E1                       longi on
5143 14E1 8A                    txa                            ;a = # of 32K units in RamDisk
5144 14E2 F0 6F                 beq   NoDisk                   ;RD size is zero so exit
5145 14E4 48                    pha                            ;save for later
5146 14E5 F4 00 00 F4           pushlong #0000                 ;space for newhandle result
5147 14EB 4A                    lsr   A                        ;convert to units of 64K
5148 14EC 48                    pha                            ;push hi word of length
5149 14ED 8D 44 16              sta   |CurDiskSize+2
5150 14F0 A9 00 00              lda   #0000
5151 14F3 6A                    ror   A                        ;put 32K bit in msb
5152 14F4 48                    pha                            ;push lo word of length
5153 14F5 8D 42 16              sta   |CurDiskSize
5154 14F8              *  create the handle needed for the RAMdisk
5155 14F8 F4 01 00              pushword #RDiskID              ;Owner ID for the ramdisk
5156 14FB F4 0C 00              pushword #Attr_NoSpec+Attr_Page  ;attributes for RAMdisk memory
5157 14FE F4 00 00 F4           pushlong #0000                 ;any address please
5158 1504 A2 02 09 22           _NewHandle 
5159 150B 68                    pla   
5160 150C 85 17                 sta   hndl
5161 150E 68                    pla   
5162 150F 85 19                 sta   hndl+2
5163 1511 B0 39                 bcs   NoDisk2                  ;clear stack before BCS  01/19/89 JOA
5164 1513 8D 48 16              sta   |DiskHandles+2
5165 1516 A5 17                 lda   hndl
5166 1518 8D 46 16              sta   |DiskHandles             ;Save the handle of the block
5167 151B              * deref the handle in hndl into the pointer addr
5168 151B A0 00 00 B7           geth_l hndl,addr,hndl_addr
5169 1528              * Now set the block size
5170 1528 68                    pla                            ;get back # of 32K units
5171 1529 AA                    tax                            ;save for zap
5172 152A 0A                    asl   A
5173 152B 0A                    asl   A
5174 152C 0A                    asl   A
5175 152D 0A                    asl   A
5176 152E 0A                    asl   A
5177 152F 0A                    asl   A                        ;A = # 512 byte blocks
5178 1530 8D 40 16              sta   |BlockSize               ;BlockSize = maxblock # +1
5179 1533              * Now I have to zero out the entire block!
5180 1533 A9 00 00     zapnxt   lda   #0000
5181 1536 A8                    tay   
5182 1537 97 03        @zlp     sta   [addr],y
5183 1539 C8                    iny   
5184 153A C8                    iny   
5185 153B 10 FA                 bpl   @zlp
5186 153D 98                    tya   
5187 153E 18                    clc   
5188 153F 65 03                 adc   addr
5189 1541 85 03                 sta   addr
5190 1543 90 02                 bcc   @10
5191 1545 E6 05                 inc   addr+2
5192 1547 CA           @10      dex                            ;another 32K hunk to zap?
5193 1548 D0 E9                 bne   zapnxt
5194 154A
5195 154A 18           Done     clc   
5196 154B 60                    rts   
5197 154C
5198 154C 68           NoDisk2  pla                            ;Fix the stack
5199 154D 9C 42 16              stz   |CurDiskSize             ;and clear the RD size
5200 1550 9C 44 16              stz   |CurDiskSize+2           ; so nobody thinks anything here
5201 1553 38           NoDisk   sec   
5202 1554 60                    rts   
5203 1555
5204 1555                       ENDP 
5205 1555
5206 1555
5207 1555
5208 1555              ********************************************************************************
5209 1555              *
5210 1555              * GetDiskBlock - Gets a block of the ram disk
5211 1555              *
5212 1555              * Inputs:      PCBlockNum = Block number
5213 1555              *
5214 1555              * Outputs:     hndl = handle containing disk
5215 1555              *              addr = starting address of block in handle
5216 1555              *              C = 1 if unable to get block
5217 1555              *
5218 1555              * GetBlockA - Block number is in the A reg
5219 1555              ********************************************************************************
5220 1555              GetDiskBlock PROC 
5221 1555                       longa on
5222 1555                       longi on
5223 1555
5224 1555 AF 4A 00 00           lda   >PCBlockNum+2            ;High word must be 0
5225 1559 D0 2B                 bne   BadBlock
5226 155B AF 48 00 00           lda   >PCBlockNum
5227 155F
5228 155F                       ENTRY GetBlockA
5229 155F              GetBlockA                               ;       
5230 155F CD 40 16              cmp   |BlockSize
5231 1562 B0 22                 bge   BadBlock
5232 1564
5233 1564              * Get the 1 handle and add blocknum*512 to address
5234 1564
5235 1564 48           BlockOK  pha                            ;Save blocknumber for later
5236 1565 AD 46 16              lda   |DiskHandles             ;Get the handle we want
5237 1568 85 17                 sta   hndl
5238 156A AD 48 16              lda   |DiskHandles+2           ;Carry
5239 156D 85 19                 sta   hndl+2                   ;hndl is handle containing block
5240 156F F0 1A                 beq   NoBlock                  ;Br if no ramdisk!!!!!
5241 1571
5242 1571 A0 00 00 B7           geth_l hndl,addr,hndl_addr     ;Get the address
5243 157E              * now add blocknum*512 to the addr 
5244 157E 68                    pla                            ;Get the block number again
5245 157F 0A                    asl   A                        ;Leaves C = 0 and A = block# * 2
5246 1580 65 04                 adc   addr+1                   ;add at + 1 for block# * 256
5247 1582 85 04                 sta   addr+1                   ;Thus addr = addr+(Blknum*512)
5248 1584 18                    clc   
5249 1585 60                    rts   
5250 1586
5251 1586 A9 2D 00     BadBlock lda   #PCBadBlk
5252 1589 80 04                 bra   NoBlock2
5253 158B A9 27 00     NoBlock  lda   #PCIOErr                 ;ioerror
5254 158E 68                    pla                            ;Fix the stack
5255 158F 85 01        NoBlock2 sta   error
5256 1591 38                    sec   
5257 1592 60                    rts   
5258 1593
5259 1593                       ENDP 
5260 1593
5261 1593
5262 1593
5263 1593              ********************************************************************************
5264 1593              *
5265 1593              * RDFormat - Makes a catalog in the ramdisk if needed
5266 1593              *
5267 1593              * inputs: A = Protocol converter command
5268 1593              *
5269 1593              ********************************************************************************
5270 1593              RDFormat PROC 
5271 1593                       longa on
5272 1593                       longi on
5273 1593
5274 1593 C9 05 00              cmp   #$0005                   ;Don't format if PCinit
5275 1596 F0 6B                 beq   NoFormat
5276 1598 2C 4A 16              bit   |FormatFlag              ;Already formatted?
5277 159B 30 66                 bmi   NoFormat
5278 159D
5279 159D              * Get the block and put a catalog in it
5280 159D 48                    pha                            ;Save command #
5281 159E A9 00 00              lda   #$0000                   ;Index from block 0
5282 15A1 20 5F 15              jsr   GetBlockA
5283 15A4 B0 5C                 bcs   NoBlock                  ;Br if can't get block
5284 15A6
5285 15A6 AF 00 BF 00           lda   >ProFlag                 ;0 if pascal <>0 if ProDOS
5286 15AA A2 40 00              ldx   #PasCat-ProCat           ;Assume Pascal
5287 15AD A0 0E 04              ldy   #$040E                   ;Y = where size goes
5288 15B0 29 FF 00              and   #$00FF
5289 15B3 F0 26                 beq   IsPascal
5290 15B5
5291 15B5              * It's a prodos catalog
5292 15B5              * First make the bit map
5293 15B5 AD 40 16              lda   |BlockSize
5294 15B8 4A                    lsr   A                        ;Get # words in bitmap
5295 15B9 4A                    lsr   A
5296 15BA 4A                    lsr   A
5297 15BB 4A                    lsr   A
5298 15BC A8                    tay                            ;Y = # words
5299 15BD EB                    xba                            ;Get # blocks in bitmap
5300 15BE 0A                    asl   A
5301 15BF 29 0F 00              and   #$000F
5302 15C2 AA                    tax   
5303 15C3 BF 34 16 FC           lda   >BitMap,x                ;First word has directory busy
5304 15C7 BB                    tyx   
5305 15C8 A0 00 0C              ldy   #$0C00                   ;Block 6 = bitmap
5306 15CB 97 03        BitLoop  sta   [addr],y
5307 15CD C8                    iny   
5308 15CE C8                    iny   
5309 15CF A9 FF FF              lda   #$FFFF                   ;Rest are FFs
5310 15D2 CA                    dex   
5311 15D3 D0 F6                 bne   BitLoop
5312 15D5
5313 15D5 A2 00 00              ldx   #0                       ;X = index into catalog table
5314 15D8 A0 29 04              ldy   #$0429                   ;Store number of blocks
5315 15DB
5316 15DB
5317 15DB AD 40 16     IsPascal lda   |BlockSize               ;Move the block size
5318 15DE 97 03                 sta   [addr],y
5319 15E0
5320 15E0              *
5321 15E0              * This part moves the catalog
5322 15E0              *
5323 15E0 BF 04 16 FC  CatLoop  lda   >ProCat,x
5324 15E4 E8                    inx   
5325 15E5 E8                    inx   
5326 15E6 C9 FE FE              cmp   #Flag                    ;Address flag?
5327 15E9 D0 0B                 bne   NoFlag
5328 15EB BF 04 16 FC           lda   >ProCat,x                ;Get new address
5329 15EF F0 0B                 beq   NoMore                   ;Br if end of table
5330 15F1 E8                    inx   
5331 15F2 E8                    inx   
5332 15F3 A8                    tay   
5333 15F4 80 EA                 bra   CatLoop
5334 15F6 97 03        NoFlag   sta   [addr],y
5335 15F8 C8                    iny   
5336 15F9 C8                    iny   
5337 15FA 80 E4                 bra   CatLoop
5338 15FC
5339 15FC A9 FF FF     NoMore   lda   #True
5340 15FF 8D 4A 16              sta   |FormatFlag              ;Mark Formatted
5341 1602
5342 1602 68           NoBlock  pla                            ;Get command # back
5343 1603 60           NoFormat rts   
5344 1604
5345 1604
5346 1604              * Catalog image
5347 1604              Flag     equ   $FEFE                    ;Flag to mark address change
5348 1604
5349 1604              * This is the prodos catalog image Must be an even number of bytes
5350 1604              ProCat                                  ; 
5351 1604 FE FE                 DC W:Flag                      ;Block 2
5352 1606 02 04 03 00           DC B:$02,$04,$03,$00
5353 160A F4                    DC B:$F4
5354 160B 52 41 4D 35           DC B:'RAM5'
5355 160F 00                    DC B:$00
5356 1610 FE FE                 DC W:Flag
5357 1612 22 04 C3 27           DC B:$22,$04,$C3,$27,$0D,$00,$00,$06
5358 161A FE FE                 DC W:Flag                      ;Block 3
5359 161C 00 06 02 00           DC B:$00,$06,$02,$00,$04,$00
5360 1622 FE FE                 DC W:Flag                      ;Block 4
5361 1624 00 08 03 00           DC B:$00,$08,$03,$00,$05,$00
5362 162A FE FE                 DC W:Flag
5363 162C 00 0A 04 00           DC B:$00,$0A,$04,$00
5364 1630 FE FE 00 00           DC W:Flag, 0
5365 1634
5366 1634              * Table of first word bitmaps
5367 1634              BitMap                                  ; 
5368 1634 01 FF                 DC B:$01,$FF                   ;Up to 2M
5369 1636 00 FF                 DC B:$00,$FF                   ;4M
5370 1638 00 7F                 DC B:$00,$7F                   ;6M
5371 163A 00 3F                 DC B:$00,$3F                   ;8M
5372 163C 00 1F                 DC B:$00,$1F                   ;10M
5373 163E 00 0F                 DC B:$00,$0F                   ;12M
5374 1640 00 07                 DC B:$00,$07                   ;14M
5375 1642 00 03                 DC B:$00,$03                   ;16M
5376 1644
5377 1644              PasCat                                  ; 
5378 1644 FE FE                 DC W:Flag                      ;Block 2 byte 2
5379 1646 02 04                 DC B:$02,$04
5380 1648 06 00 00 00           DC B:$06,$00,$00,$00,$04
5381 164D 52 41 4D 35           DC B:'RAM5'
5382 1651 00                    DC B:$00
5383 1652 FE FE 00 00           DC W:Flag, 0
5384 1656
5385 1656
5386 1656
5387 1656                       ENDP 
5388 1656
5389 1656
5390 1656
5391 1656                       title ' RamDisk Protocol Converter Command' 
5392 1656              ********************************************************************************
5393 1656              *
5394 1656              * ExecPCCmd - Executes a protocol converter command
5395 1656              *
5396 1656              * Extend calls are mapped into normal calls for dispatch
5397 1656              * The command table is in real page 0
5398 1656              *
5399 1656              * Rev 2 change: returns 1 byte error code.  Word move was trashing byte count
5400 1656              *
5401 1656              *
5402 1656              ********************************************************************************
5403 1656              ExecPCCmd PROC 
5404 1656                       longa on
5405 1656                       longi on
5406 1656
5407 1656 22 89 01 FC           jsl   RDLink
5408 165A AF 45 00 00           lda   >PCCommand               ;Get the command
5409 165E 29 FF 00              and   #$00FF                   ;Only low word valid
5410 1661 C9 0A 00              cmp   #0010                    ;0 - 9 are normal calls
5411 1664 90 0D                 bcc   CmdOK
5412 1666 29 BF 00              and   #%10111111               ;40 - 49 -> 0 - 9
5413 1669 C9 0A 00              cmp   #0010
5414 166C 90 05                 bcc   CmdOk
5415 166E 20 9C 16              jsr   NotImp
5416 1671 80 08                 bra   Cmdbadxit
5417 1673 20 93 15     CmdOK    jsr   RDFormat                 ;Format the ramdisk if needed
5418 1676 0A                    asl   A                        ;*2 for table look up
5419 1677 AA                    tax   
5420 1678 FC 88 16              jsr   (PCDispatch,x)           ;Go do the command
5421 167B
5422 167B E2 20        Cmdbadxit sep   #$20                    ;8 bit error code Rev 2 change
5423 167D A5 01                 lda   error                    ;Get Error code
5424 167F 8F 50 00 00           sta   >PCStatByte              ;To return the error
5425 1683 C2 20                 rep   #$20                     ;back to 16 bits
5426 1685 4C C4 01              jmp   XCleanUp                 ;All done
5427 1688
5428 1688                       ENTRY PCDispatch
5429 1688              PCDispatch                              ; 
5430 1688 A2 16                 DC W:PCStatus                  ;0, $40 Status command
5431 168A 0C 17                 DC W:PCReadBlk                 ;1, $41 Read Block
5432 168C 30 17                 DC W:PCWriteBlk                ;2, $42 Write Block
5433 168E A1 16                 DC W:Null                      ;3, $43 Format
5434 1690 4F 17                 DC W:PCControl                 ;4, $44 Control
5435 1692 5E 17                 DC W:PCInit                    ;5, $45 Init
5436 1694 9C 16                 DC W:NotImp                    ;6, $46 Open
5437 1696 9C 16                 DC W:NotImp                    ;7, $47 Close
5438 1698 9C 16                 DC W:NotImp                    ;8, $48 Read
5439 169A 9C 16                 DC W:NotImp                    ;9, $49 Write
5440 169C
5441 169C A9 01 00     NotImp   lda   #PCBadCmd                ;Bad command
5442 169F 85 01                 sta   error
5443 16A1 60           Null     rts   
5444 16A2
5445 16A2                       ENDP 
5446 16A2
5447 16A2
5448 16A2              ********************************************************************************
5449 16A2              *
5450 16A2              * PCStatus - protocol converter status call
5451 16A2              *
5452 16A2              * Only calls 0 & 3 are valid
5453 16A2              *
5454 16A2              ********************************************************************************
5455 16A2              PCStatus PROC 
5456 16A2                       longa on
5457 16A2                       longi on
5458 16A2
5459 16A2 AF 48 00 00           lda   >PCStatCode              ;Get status code
5460 16A6 29 FF 00              and   #$00FF                   ;Only want low byte
5461 16A9 F0 0B                 beq   StatusOK                 ;Br if status 0
5462 16AB C9 03 00              cmp   #$0003                   ;DIB call?
5463 16AE F0 06                 beq   StatusOK
5464 16B0 A9 21 00              lda   #PCBadCtl                ;Return Bad Status Error
5465 16B3 85 01                 sta   Error
5466 16B5 60                    rts   
5467 16B6
5468 16B6
5469 16B6
5470 16B6
5471 16B6                       ENTRY StatusOK
5472 16B6              StatusOK                                ; 
5473 16B6 48                    pha                            ;Save Code for later
5474 16B7 AF 42 00 00           lda   >PCBuffer                ;Get the buffer
5475 16BB 85 07                 sta   dest
5476 16BD AF 44 00 00           lda   >PCBuffer+2
5477 16C1 29 FF 00              and   #$00FF
5478 16C4 85 09                 sta   dest+2
5479 16C6
5480 16C6 A0 02 00              ldy   #2                       ;If normal command 0 out 3rd and 4th
5481 16C9 AF 45 00 00           lda   >PCCommand               ;Was it an extended command?
5482 16CD 29 40 00              and   #$0040
5483 16D0 F0 01                 beq   NormCmd
5484 16D2 C8                    iny                            ;Else do the 4th and 5th
5485 16D3 A9 00 00     NormCmd  lda   #0
5486 16D6 97 07                 sta   [dest],y
5487 16D8 C8                    iny   
5488 16D9 C8                    iny                            ;Y = Bytes transferred (4 or 5)
5489 16DA AF 40 16 E1           lda   >BlockSize               ;Get #Blocks
5490 16DE AA                    tax                            ;Save for later
5491 16DF F0 03                 beq   Is0                      ;OffLine if Size 0
5492 16E1 A9 F8 00              lda   #$00F8                   ;Mark OnLine
5493 16E4 09 E8 00     Is0      ora   #$00E8                   ;If A was 0 then offline
5494 16E7 87 07                 sta   [dest]                   ;Give user the status
5495 16E9 8A                    txa   
5496 16EA BB                    tyx                            ;Now X has bytes transferred
5497 16EB A0 01 00              ldy   #1
5498 16EE 97 07                 sta   [dest],y
5499 16F0 9B                    txy                            ;Y has transferred again
5500 16F1 68                    pla                            ;Do we want the DIB too?
5501 16F2 F0 12                 beq   StatDone                 ;All done if call 0
5502 16F4
5503 16F4              * Now transferr the DIB too
5504 16F4 E2 30                 sep   #$30                     ;Easier Since it an odd length table
5505 16F6                       longa off
5506 16F6                       longi off
5507 16F6 A2 00                 ldx   #0                       ;Index into DIB
5508 16F8 BF 75 17 FC  DIBLoop  lda   >DIB,x
5509 16FC 97 07                 sta   [dest],y
5510 16FE C8                    iny   
5511 16FF E8                    inx   
5512 1700 E0 15                 cpx   #DIBLen
5513 1702 90 F4                 blt   DibLoop
5514 1704 C2 30                 rep   #$30
5515 1706                       longa on
5516 1706                       longi on
5517 1706
5518 1706 98           StatDone tya                            ;Get # bytes transferred
5519 1707 8F 51 00 00           sta   >PCXferCount
5520 170B 60                    rts   
5521 170C
5522 170C                       ENDP 
5523 170C
5524 170C
5525 170C
5526 170C              ********************************************************************************
5527 170C              *
5528 170C              * PCReadBlk - Read a block from the ram disk
5529 170C              *
5530 170C              * PCMove - entry point from PCWriteBlk to move 512 bytes of data
5531 170C              *
5532 170C              ********************************************************************************
5533 170C              PCReadBlk PROC 
5534 170C                       longa on
5535 170C                       longi on
5536 170C
5537 170C 20 55 15              jsr   GetDiskBlock             ;Get the block
5538 170F B0 1E                 bcs   BadBlock                 ;Br if bad
5539 1711
5540 1711              ; Set up parameters to read block Source already set up in Addr
5541 1711 AF 42 00 00           lda   >PCBuffer                ;Get destination
5542 1715 85 07                 sta   dest
5543 1717 AF 44 00 00           lda   >PCBuffer+2
5544 171B 29 FF 00              and   #$00FF
5545 171E 85 09                 sta   dest+2
5546 1720
5547 1720                       ENTRY PCMove
5548 1720              PCMove                                  ;
5549 1720
5550 1720 64 0D                 stz   count+2                  ;Move 512 bytes
5551 1722 A9 00 02              lda   #512
5552 1725 85 0B                 sta   count
5553 1727 8F 51 00 00           sta   >PCXferCount
5554 172B 22 A4 16 E1           jsl   MoveData
5555 172F 60           BadBlock rts   
5556 1730
5557 1730                       ENDP 
5558 1730
5559 1730
5560 1730              ********************************************************************************
5561 1730              *
5562 1730              * PCWriteBlk - Writes a block to the ram disk
5563 1730              *
5564 1730              ********************************************************************************
5565 1730              PCWriteBlk PROC 
5566 1730                       longa on
5567 1730                       longi on
5568 1730
5569 1730 20 55 15              jsr   GetDiskBlock             ;Get the block
5570 1733 B0 19                 bcs   BadBlock                 ;Br if bad
5571 1735
5572 1735 A5 03 85 07           move_l addr,dest               ;Get the data
5573 173D AF 42 00 00           lda   >PCBuffer                ;Get source
5574 1741 85 03                 sta   source
5575 1743 AF 44 00 00           lda   >PCBuffer+2
5576 1747 29 FF 00              and   #$00FF
5577 174A 85 05                 sta   source+2
5578 174C 80 D2                 bra   PCMove                   ;Go move the data
5579 174E
5580 174E 60           BadBlock rts   
5581 174F
5582 174F                       ENDP 
5583 174F
5584 174F
5585 174F
5586 174F              ********************************************************************************
5587 174F              *
5588 174F              * PCControl - protocol converter control call
5589 174F              *
5590 174F              * Only call 0 (reset device)  is  valid
5591 174F              *
5592 174F              ********************************************************************************
5593 174F              PCControl PROC 
5594 174F                       longa on
5595 174F                       longi on
5596 174F
5597 174F AF 48 00 00           lda   >PCStatCode              ;Get control code
5598 1753 29 FF 00              and   #$00FF                   ;Only want low byte
5599 1756 F0 05                 beq   ControlOK                ;Br if reset
5600 1758 A9 21 00              lda   #PCBadCtl                ;Return Bad Status Error
5601 175B 85 01                 sta   Error
5602 175D 60           ControlOK rts   
5603 175E
5604 175E                       ENDP 
5605 175E
5606 175E
5607 175E
5608 175E              ********************************************************************************
5609 175E              *
5610 175E              * PCInit -     Initialization call from the protocol converter
5611 175E              *
5612 175E              ********************************************************************************
5613 175E              PCInit   PROC 
5614 175E                       longa on
5615 175E                       longi on
5616 175E
5617 175E A9 00 00              lda   #0
5618 1761 8F 51 00 00           sta   >PCXferCount
5619 1765 AD 40 16              lda   |BlockSize
5620 1768 D0 0A                 bne   DiskOK                   ;Br if there is already a disk
5621 176A 20 B3 14              jsr   MakeDisk
5622 176D 90 05                 bcc   DiskOK
5623 176F A9 28 00              lda   #PCNoDrive               ;No drive error
5624 1772 85 01                 sta   error
5625 1774 60           DiskOK   rts   
5626 1775
5627 1775                       ENDP 
5628 1775
5629 1775
5630 1775                       Title 'Equates for the protocol converter'
5631 1775              ********************************************************************************
5632 1775              *
5633 1775              * Equates for the protocol converter
5634 1775              *
5635 1775              ********************************************************************************
5636 1775              PCData   PROC 
5637 1775
5638 1775
5639 1775              * The Device information block
5640 1775                       ENTRY DIB
5641 1775              DIB                                     ; 
5642 1775 07                    DC B:7                         ;Name length
5643 1776                                                      ;     1234567890123456
5644 1776 52 41 4D 43           DC B:'RAMCARD         '
5645 1786 00                    DC B:$00                       ;Type
5646 1787 C0                    DC B:$C0                       ;Extended and disk switched
5647 1788 00 10                 DC B:$00,$10                   ;Version
5648 178A
5649 178A                       ENDP 
5650 178A
5651 178A
5652 178A
5653 178A
5654 178A
5655 178A                       END   
